<?php

use App\Models\LanguageField;

if (!function_exists('translate')) {

    function translate($key, $replace = [], $locale = null)
    {
        $locale = $locale ?? app()->getLocale();

        // Tách chuỗi bằng dấu chấm
        $parts = explode('.', $key);

        // Lấy phần đầu tiên làm zone
        $zone = array_shift($parts);

        // Lấy phần còn lại sau zone làm key
        $key = implode('.', $parts);

        // Kiểm tra hoặc tạo mới trong cơ sở dữ liệu
        $field = LanguageField::firstOrCreate(
            ['locale' => $locale, 'key' => $key, 'zone' => $zone],
            ['value' => ucfirst(str_replace('.', ' ', $key))]
        );

        return $field->value;
    }
}
