<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Ticket;
use App\Models\TicketDetail;
use App\Models\Factories;
use Illuminate\Http\Request;

class AdminController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        //$this->middleware('admin.check');

    }
    public function index()
    {
        $userCount = User::count();
        $ticketCount = Ticket::count();
        $ticketDataCount = TicketDetail::count();
        $factoriesCount = Factories::count();
        $data = [
            'userCount' => $userCount,
            'ticketCount' => $ticketCount,
            'ticketDataCount' => $ticketDataCount,
            'factoriesCount' => $factoriesCount,
        ];
       return view('admin.index', compact('data'));

    }
    public function factories()
    {
        return view('admin.factories');
    }
}
