<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Factories;
use Illuminate\Http\Request;

class FactoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $factories = factories::all(); // Tìm người dùng có ID = 1
        return view('admin.factories', compact('factories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name' => 'required|string|max:255|unique:factories',
        ]);
        $factory = Factories::create($validatedData);
        if ($factory) {
            return redirect()->route('admin.factories.index')->with('success', 'Factory created successfully');
        } else {
            return redirect()->route('admin.factories.index')->with('error', 'Factory creation failed. Name already exists.');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $factory = Factories::find($id);
        if ($factory) {
            $factory->delete();
            return redirect()->route('admin.factories.index')->with('success', 'Factory deleted successfully');
        } else {
            return redirect()->route('admin.factories.index')->with('error', 'Factory not found or could not be deleted');
        }
    }
}
