<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Permission;
use Illuminate\Http\Request;

class PermissionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        return view('admin.permissions');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $permissions = Permission::all();
        return response()->json($permissions);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        $this->validation($request);
        $permission = Permission::create([
            'name' => $request->name,
            'description' => $request->description,
            'guard_name' => 'web',
        ]);
        return response()->json(['message' => 'The item has been created successfully.'], 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $permissions = Permission::find($id);
        return response()->json($permissions);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $permission = Permission::find($id);
        $permission->description = $request->description;
        $permission->save();

        if ($permission) {
            return response()->json(['message' => 'The item #' . $id . ' has been updated successfully.'], 200);
        } else {
            return response()->json(['message' => 'The item #' . $id . ' has not been updated'], 404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $Permission = Permission::find($id); // Thay YourModel bằng tên của model bạn đang sử dụng

        if (!$Permission) {
            // Nếu không tìm thấy mục, trả về thông báo lỗi hoặc thực hiện xử lý phù hợp
            return response()->json(['message' => 'The item #' . $id . ' to be deleted was not found'], 404);
        }
        // Nếu mục tồn tại, xóa nó khỏi cơ sở dữ liệu
        $Permission->delete();
        // Trả về phản hồi cho phía client
        return response()->json(['message' => 'The item #' . $id . ' has been deleted successfully']);
    }

    public function validation($request)
    {
        return $this->validate($request, [
            'name' => 'required|string|max:255|unique:permissions',
            'description' => 'max:255',
        ]);
    }
}
