<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Permission;
use Spatie\Permission\Models\Role;
use Illuminate\Http\Request;

class RolesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $roles = Role::all();
        $permissions = Permission::all();
        $datas = [
            'roles' => $roles,
            'permissions' => $permissions,

        ];
        return view('admin.roles', compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $roles = Role::with('permissions')->get();
        $formattedRoles = $roles->map(function ($role) {
            return [
                'id' => $role->id,
                'name' => $role->name,
                'permissions' => $role->permissions->pluck('name')
            ];
        });

        return response()->json($formattedRoles);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $role = Role::with('permissions')->find($id);
        return response()->json($role);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $role = Role::findById($id);

        if (!$role) {
            return response()->json(['message' => 'The item #' . $id . ' does not exist.'], 404);
        } else {
            $permissionIds = $request->permission;

            // Check if the permissions exist before syncing
            $existingPermissions = Permission::whereIn('id', $permissionIds)->pluck('id')->toArray();
            if (count($existingPermissions) !== count($permissionIds)) {
                return response()->json(['message' => 'One or more of the specified permissions do not exist.'], 422);
            }

            $role->syncPermissions($existingPermissions);
            $updatedRole = Role::findById($id); // Get the updated role

            return response()->json(['message' => 'The item #' . $id . ' has been updated successfully.', 'role' => $updatedRole], 200);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
