<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\HomeController;
use App\Models\Departments;
use App\Models\Factories;
use App\Models\Positions;
use App\Models\Ticket;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Sections;
use App\Imports\UsersImport;
use Illuminate\Contracts\Session\Session;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Storage;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Traits\HasRoles;



class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function importView()
    {
        return view('admin.UserImport');
    }



    public function downloadSampleForm()
    {
        $path = Storage::disk('public')->path('excel-form/TicketSystem_TemplateImportUser.xlsx');
        return response()->download($path, 'TicketSystem_TemplateImportUser.xlsx');
    }

    public function import(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xlsx,xls',
        ]);

        $file = $request->file('file');

        $import = new UsersImport();
        Excel::import($import, $file);

        $messages = $import->getMessages();

        if (!empty($messages)) {
            return redirect()->back()->withErrors($messages)->withInput();
        }


        // Tìm tất cả người dùng chưa có vai trò
        //$usersWithoutRole = \App\Models\User::doesntHave('roles')->get();

        // Tạo vai trò 'user' nếu nó chưa tồn tại
        //$role = Role::firstOrCreate(['name' => 'user']);

        // Gán vai trò 'user' cho tất cả người dùng chưa có vai trò
       

        return redirect()->back()->with('success', 'File imported successfully.');
    }


    public function index(Request $request)
    {
        $users = User::query();
        $search = $request->input('search') ?? null;
        $s_factory = $request->input('factory') ?? null;
        if ($request->has('search') || $request->has('factory')) {

            //where fullname like %search% or id like %search%
            $users = $users->where(function ($query) use ($search) {
                $query->where('fullname', 'like', "%$search%")
                    ->orWhere('id', 'like', "%$search%")
                    ->orWhere('username', 'like', "%$search%");

                // Always apply factory filter

            });
            $users->where('id_factory', $s_factory);
        }

        $users->with('Factories');
        $users = $users->paginate(10);
        $Factories = Factories::all();


        return view('admin.user', compact(['users', 'Factories', 'search', 's_factory']));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //         use App\Models\Departments;
        // use App\Models\Factories;
        $factories = Factories::all();
        $roles = Role::where('name', '!=', 'admin')->where('name', '!=', 'administrator')->get();
        $depts = Departments::where('factory_id', Auth::user()->id_factory)->get()->Unique();
        $sessions = Sections::with('contry')->get();
        $positions = Positions::all();
        return view('admin.createUser', compact(['depts', 'roles', 'factories', 'sessions', 'positions']));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //validate the request and passsword = re-password
        $this->validate($request, [
            'fullname' => 'required|min:5|max:255',
            'username' => [
                'required',
                'min:5',
                'max:255',
                'unique:users',
                'regex:/^[a-zA-Z0-9_]+$/'
            ],
            'password' => 'required|min:6|max:255',
            're-password' => 'required|same:password',
            'role' => 'required|integer',
            'factory' => 'required|integer',
            'department' => 'required|integer',
            'section' => 'required|integer',
            'position' => 'required|integer',
        ]);


        //create new user
        $user = new User();
        $user->fullname = $request->fullname;
        $user->username = $request->username;
        $user->password = bcrypt($request->password);
        $user->id_factory = $request->factory;
        $user->email = $request->email;
        $user->id_dept = $request->department;
        $user->id_section = $request->section;
        $user->id_position2 = $request->position;
        $user->id_country = Sections::find($request->section)->id_factory;



        if ($user->save()) {


            $user = User::where('username', $request->username)->first();

            DB::table('model_has_roles')->Insert(
                [
                    'model_type' => 'App\Models\User',
                    'model_id' => $user->id,
                    'role_id' => $request->role,
                ],

            );


            // Create an instance of HomeController
            $homeController = new HomeController();

            // Call the CreateImagesForAllUser method
            $homeController->CreateImagesForAllUser();
            return redirect()->back()->with('success', "Create Success");
        }
        //status message errors
        return redirect()->back()->with('error', "Create Fail");
    }


    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $users_edit = User::with(['Factories', 'Departments'])->find($id);
        $users_edit->load('roles');
        if (!$users_edit) {
            return redirect()->route('admin.users.index')->with('error', 'User not found.');
        }
        $roles = Role::all();

        $factories = Factories::all();
        $departments = Departments::all();
        return view('admin.editUser', compact(['roles', 'users_edit', 'factories', 'departments']));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'fullname' => 'required|min:5|max:255',
            'role' => 'required|integer',
            'factories' => 'required|integer',
            'department' => 'required|integer',
        ]);
        $user = User::find($id);
        $user->id_factory = $request->factories;
        $user->id_dept = $request->department;
        $user->fullname = $request->fullname;
        $user->email = $request->email;
        $user->syncRoles($request->role);
        $user->save();
        return redirect()->back()->with('message', "Edit Success");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        //check user  = $id and not in ticket->created_by
        $user = User::find($id);

        if ($user) {
            //check user  = $id and not in ticket->created_by
            $check = Ticket::where('created_by', $id)->get();
            if ($check->count() > 0) {
                return redirect()->back()->with('error', "User Have Ticket Have Delete or Not Found");
            } else {
                $user->delete();
                return redirect()->back()->with('success', "User Deleted Successfully");
            }
        } else {
            return redirect()->back()->with('error', "User Not Found");
        }
    }

    public function changepass()
    {
        return view('user.changepass');
    }
}
