<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Controllers\HomeController;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use App\Models\Factories;


class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        $factories = Factories::with('Departments')->get();
        $datas = [
            'fatories' => $factories,
        ];
        return view('auth.register', compact('datas'));
    }

    /**
     * Handle an incoming registration request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request)
    {
        $request->validate([
            'username' => ['required', 'string', 'max:255', 'min:5', 'unique:users', 'regex:/^[A-Za-z0-9]+$/'],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
            'fullname' => ['required', 'string', 'max:255'],
            'department' => ['required', 'int', 'exists:departments,id'],
        ]);

        $user = User::create([
            'username' => $request->username,
            'fullname' => $request->fullname,
            'id_dept' => $request->department,
            'id_factory' => $request->factories,
            'password' => Hash::make($request->password),

        ]);
        $user->assignRole('user');

        event(new Registered($user));

        Auth::login($user);

        HomeController::CreateImagesForAllUser();

        return redirect(RouteServiceProvider::HOME);
    }
}
