<?php

namespace App\Http\Controllers;

use App\Events\Messenge;
use App\Models\Conversations;

use App\Models\Messenger;
use App\Models\Participant;
use App\Models\User;
use App\Notifications\GreetingNotification;
use App\Notifications\MessengeNotification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ConversationsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $conversations = Conversations::with(['participants', 'messages' => function ($query) {
            $query->latest();
        }])
            ->whereHas('participants', function ($query) {
                $query->where('user_id', Auth::id());
            })
            ->orderBy('id', 'DESC')
            ->get();

        // Now, let's loop through the conversations and grab the latest message for each one
        $conversations->each(function ($conversation) {
            $conversation->latest_message = $conversation->messages->first();
        });

        return response()->json($conversations);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $userIds = array_map('intval', $request->users);
        $userIds[] = Auth::id();

        $conversation = new Conversations();
        $conversation->name = $request->name;




        if ($conversation->save()) {
            foreach ($userIds as $user) {
                $participant = new Participant();
                $participant->conversation_id = $conversation->id;
                $participant->user_id = $user;
                $participant->save();
            }

            $users = User::whereIn('id', $userIds)->get();

            foreach ($users as $user) {
                $MessNoti = [
                    'title' => Auth::user()->fullname . " created new conversation",
                    'content' => "created new conversation",
                    'id_conversation' => $conversation->id,
                    'user_send' => Auth::user()->id,
                    'user_receive' => $user->id,
                ];
                $user->notify(new MessengeNotification($MessNoti));
            }
            $Messenge = [
                'userList' => $userIds,
                'type' => 'Conversation'
            ];
            Broadcast(new Messenge($Messenge));

            return $conversation->id;
        }
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $MessList = Messenger::where('conversation_id', $id)->with('user')->get();
        $Conversations = Conversations::where('id', $id)->with('participants')->get();
        $datas = [
            'Conversations' => $Conversations,
            'MessList' => $MessList,
            'Auth' => Auth::id()
        ];
        return response()->json($datas);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
