<?php

namespace App\Http\Controllers;

use App\Jobs\SendMailVeryAccount;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use Illuminate\Support\Str;


class EmailController extends Controller
{


    public function active(Request $request)
    {
        //      dd($request->all());
        $this->validate(request(), [
            'username' => 'required|exists:users,username',
            'email' => 'required|exists:users,email'
        ]);

        $user = User::where('username', $request->username)
            ->where('email', $request->email)
            ->first();
        if (!$user) {
            return redirect()->back()->with('errors', 'Username or email not found!');
        }
        SendMailVeryAccount::dispatch($user->id);
        return redirect()->route('form-active')->with('status', 'verification-link-sent');

    }
}
