<?php

namespace App\Http\Controllers;

use App\Events\Messenge;
use App\Models\Problems;
use App\Models\SubTaks;
use App\Models\Ticket;
use App\Models\TicketStatus;
use Illuminate\Http\Request;
use App\Models\Factories;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Laravolt\Avatar\Avatar;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Mail\TicketCreated;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Carbon;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function viewActive()
    {
        return view('viewactive');
    }

    public function index()
    {
        $statusList = TicketStatus::where('type', 'ticket')->whereNotIn('ID', [15, 16])->orderBy('Priority')->get();
        $ProblemList = Problems::all();
        $Factories = Factories::all();
        $lastChangePass = User::where('id', Auth::id())->first();

        $datas = [
            'statusList' => $statusList,
            'problemList' => $ProblemList,
            'factories' => $Factories,

        ];

        if ($lastChangePass) {
            $lastUpdated = Carbon::parse($lastChangePass->LastedUpdatePassword);
            $daysSinceLastChange = $lastUpdated->diffInDays(now());

            if ($daysSinceLastChange >= 75 && $daysSinceLastChange < 90) {
                $daysRemaining = 90 - $daysSinceLastChange;
                Session::flash(
                    'warning',
                    translate('ticket.Your password has not been changed for :days_since_last_change days. You have :days_remaining days left to update it before it expires.', [
                        'days_since_last_change' => $daysSinceLastChange,
                        'days_remaining' => $daysRemaining,
                    ])
                );
            } elseif ($daysSinceLastChange >= 90) {
                Session::flash(
                    'danger',
                    translate('ticket.Your password has expired. Please change it immediately to secure your account.')
                );
            }
        }


        return view('home', compact('datas'));
    }


    public function SendMessage()
    {
        Broadcast(new Messenge('aa'))->toOthers();

        //        $users = User::where('type', 'MG')->get();
        //        foreach ($users as $user){
        //            $user->syncRoles(5);
        //        }


        //        $this->createImagesForAllUser();
        //        $role = Role::find(10); // Thay 10 bằng ID của quyền bạn muốn cấp
        //        $usersWithoutPermission = User::hasPermissionTo($role->name)->get();
        //        foreach ($usersWithoutPermission as $user) {
        //            $user->givePermissionTo($role);
        //        }
        //Function create imaghes for user default


        // Lấy user bên Staff qua
        // Get all usernames of users


    }

    public function CreateImagesForAllUser()
    {

        // Tìm tất cả người dùng chưa có vai trò
        //$usersWithoutRole = \App\Models\User::doesntHave('roles')->get();

        // Tạo vai trò 'user' nếu nó chưa tồn tại
        //$role = Role::firstOrCreate(['name' => 'user']);

        // Gán vai trò 'user' cho tất cả người dùng chưa có vai trò
        //foreach ($usersWithoutRole as $user) {
        //    $user->assignRole($role);
        // }


        $users = User::where('avatar_url', null)->get();
        $avatar = new Avatar(config('laravolt.avatar'));
        $storagePath = public_path('images/users');
        foreach ($users as $user) {
            $image = $avatar->create($user->fullname)->setTheme('colorful')->toBase64();
            $filename = $user->id . '.png';
            $file_put_contents = file_put_contents($storagePath . '/' . $filename, base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $image)));
            $user->avatar_url = 'images/users/' . $filename;
            $user->save();
        }
    }

    public function MoveUserStaffToMe()
    {
        $users = User::where('id', '>', 30)->get();

        foreach ($users as $user) {
            $user->password = bcrypt('12345678');
            $user->save();
        }
    }

    public function upload(Request $request)
    {
        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $fileName = $file->getClientOriginalName();
            $path = $file->store('images/chat');
            $storedFileName = basename($path);
            $url = ('storage/images/chat/' . $storedFileName);
            $fullUrl = asset($url);
            return response()->json(['location' => $fullUrl]);
        } else {
            return response('Lỗi khi tải lên hình ảnh.', 400);
        }
    }

    public function test1()
    {


        $tickets = Ticket::with([
            'factories',
            'acceptedBy',
            'doneBy',
            'createdBy',
            'department',
            'ticketDetails',
            'hasStatus',
            'hasType.hasProblem',
            'hasRate',
            'hasApprove'
        ])
            ->orderBy(function ($query) {
                $query->from('ticket_details')
                    ->whereColumn('ticket_details.ticket_id', 'tickets.id')
                    ->select('id')
                    ->latest()
                    ->limit(1);
            }, 'desc')->get();


        dd($tickets);


        //User::where('username', 'A1A2444418')->update(['password' => Hash::make('pass@12345678')]);
        // User::where('username', 'A1A1416868')->update(['password' => Hash::make('Nuwan@12345678')]);
        // User::where('username', 'A1A1518216')->update(['password' => Hash::make('Sarunya@12345678')]);
        // User::where('username', 'A1A2130718')->update(['password' => Hash::make('Best@12345678')]);
        // User::where('username', 'A1A1822258')->update(['password' => Hash::make('Dada@12345678')]);

        //User::where('username', 'A1A2029470')->update(['password' => Hash::make('Tien@12345678')]);

        $ticket = Ticket::with(['createdBy', 'hasType', 'subtasks.staff_handle'])->find(3342);
        //$ticket->createdBy->email

        dd($ticket);

        Mail::to($ticket->createdBy->email)->send(new TicketCreated($ticket));

    }

    public function test(Request $request)
    {


        $perPage = 10;

        //Role of Auth
        $listIDTicket = [];
        $listTicketOfHandleInCountry = [];


        $listPermissions = Auth::user()->getAllPermissions()->pluck('name');
        //$listPermissions = User::find(6508)->getAllPermissions()->pluck('name');// test


        $tickets = Ticket::with([
            'factories',
            'acceptedBy',
            'doneBy',
            'createdBy',
            'department',
            'ticketDetails',
            'hasStatus',
            'hasType.hasProblem',
            'hasRate',
            'hasApprove',
            'subtasks.staff_handle',
            'factories.Country',
        ])
            ->where(function ($query) use ($listPermissions) {

                //Ticket my send
                $query->where('created_by', Auth::id());


                if (!$listPermissions->contains('forward-all-factories')) {
                    if ($listPermissions->contains('forward-in-country')) {
                        // Filter by factories related to the user's country
                        $query->orWhereHas('factories.Country', function ($query) {
                            $query->where('id', Auth::user()->id_country);
                        })
                            // Or filter by staff_handle related to the user's country
                            ->orWhereHas('subtasks.staff_handle', function ($query) {
                                $query->where('id_factory', Auth::user()->id_country);
                            });


                    }

                    // in local factory
                    if ($listPermissions->contains('forward-in-factory')) {
                        $query->OrWhere('factories_id', Auth::user()->id_country);

                    }


                    //Ticket my handle
                    $query->orWhereHas('subtasks.staff_handle', function ($query) {
                        $query->OrWhere('id_user', Auth::id());

                    });


                    //Auth type = 'MG' can see all ticket of id_determent
                    if (Auth::user()->type == 'MG') {
                        $query->OrWhere('department_id', Auth::user()->id_dept);

                    }


                }


            })
            ->get();


        dd($tickets);

        //all country r
        if ($listPermissions->contains('forward-all-factories')) {
            $listIDTicket = array_merge($listIDTicket, Ticket::all()->pluck('id')->toArray());
        }


        //in country r
        if ($listPermissions->contains('forward-in-country')) {
            $listIDTicket = array_merge($listIDTicket, Ticket::whereHas('factories', function ($query) {
                $query->where('id_country', Auth::user()->id_country);
            })->pluck('id')->toArray());

            $listTicketOfHandleInCountry = Ticket::whereHas('subtasks', function ($subtasks) {
                $subtasks->whereHas('staff_handle', function ($query) {
                    $query->where('id_country', Auth::user()->id_country);
                });
            })->pluck('id')->toArray();


            $listIDTicket = array_merge($listIDTicket, $listTicketOfHandleInCountry);


        }


        // in local factory r
        if ($listPermissions->contains('forward-in-factory')) {
            $listIDTicket = array_merge($listIDTicket, Ticket::where('factories_id', Auth::user()->id_factory)->pluck('id')->toArray());
        }

        //Ticket my handle r
        $subTasks = SubTaks::where('id_user', Auth::id())->pluck('id_ticket');

        if ($subTasks->isNotEmpty()) {
            $listIDTicket = array_merge($listIDTicket, $subTasks->toArray());
        }

        //Ticket my send
        $mySent = Ticket::where('created_by', Auth::id())->pluck('id');
        if ($mySent->isNotEmpty()) {
            $listIDTicket = array_merge($listIDTicket, $mySent->toArray());
        }

        //Auth type = 'MG' can see all ticket of id_determent
        if (Auth::user()->type == 'MG') {
            $idTicketForMG = Ticket::where('department_id', Auth::user()->id_dept)->pluck('id');
            $listIDTicket = array_merge($listIDTicket, $idTicketForMG->toArray());
        }

        //remove all double
        $listIDTicket = array_unique($listIDTicket);

        //dd($listIDTicket);

        $tickets = Ticket::whereIn('id', $listIDTicket);

        $search = $request->search;

        if (isset($search['title'])) {
            $searchValue = $search['title'];

            $tickets->where(function ($query) use ($searchValue) {
                $query->where('id', 'like', '%' . $searchValue . '%')
                    ->orWhere('title', 'like', '%' . $searchValue . '%');
            });
        }


        if (isset($search['onlyMe'])) {
            if ($search['onlyMe'] == 'true') {
                $userseach = Auth::user()->id;
                $userRoleNames = Auth::user()->getRoleNames();

                if ($userRoleNames->contains('ticket-holder') || $userRoleNames->contains('admin') || $userRoleNames->contains('ticket-sorter')) {
                    $tickets = Ticket::where(function ($query) use ($userseach) {
                        $query->whereHas('subtasks.staff_handle', function ($query) use ($userseach) {
                            $query->where('id', $userseach);
                        });
                    });

                } else {
                    $tickets = Ticket::where(function ($query) use ($userseach) {
                        $query->whereHas('createdBy', function ($query) use ($userseach) {
                            $query->where('id', $userseach);
                        });
                    });
                }


                // $tickets = Ticket::where(function ($query) use ($userseach) {
                //     $query->whereHas('createdBy', function ($query) use ($userseach) {
                //         $query->where('id', $userseach);
                //     });
                //     // ->orWhereHas('subtasks.staff_handle', function ($query) use ($userseach) {
                //     //     $query->where('id', $userseach);
                //     // });
                // });
            }
        }


        if (isset($search['fullname'])) {
            $userseach = $search['fullname'];
            $tickets = Ticket::where(function ($query) use ($userseach) {
                $query->whereHas('createdBy', function ($query) use ($userseach) {
                    $query->where('fullname', 'like', '%' . $userseach . '%')
                        ->orWhere('username', 'like', '%' . $userseach . '%');
                })->orWhereHas('subtasks.staff_handle', function ($query) use ($userseach) {
                    $query->where('fullname', 'like', '%' . $userseach . '%');
                });
            });
        }
        if (isset($search['department'])) {
            //department_id
            $department = $search['department'];
            $tickets = Ticket::whereHas('department', function ($query) use ($department) {
                $query->where('name', 'like', '%' . $department . '%');
            });
        }
        if (isset($search['ranges'])) {
            $start_date = DateTime::createFromFormat('d/m/Y', $search['ranges'][0])->format('Y-m-d');
            $end_date = DateTime::createFromFormat('d/m/Y', $search['ranges'][1])->format('Y-m-d');
            $tickets->whereBetween('date_send', [$start_date, $end_date]);
        }

        if (isset($search['factories'])) {
            if (count($search['factories']) > 0) {
                $tickets->whereIn('factories_id', $search['factories']);
            }
        }
        // else {
        //     if (Auth::user()->id_factory !== 1) { // Ensure that the id_factory is being compared as an integer.
        //         $tickets->where('factories_id', Auth::user()->id_factory);
        //     }
        // }


        if (isset($search['status'])) {
            $tickets->whereIn('status', $search['status']);
        } else {
            $tickets->where('status', 0);
        }

        if (isset($search['type']) && is_array($search['type'])) {
            $tickets->whereHas('hasType.hasProblem', function ($query) use ($search) {
                $query->whereIn('id', $search['type']);
            });
        }


        //End query search
        $tickets = $tickets->with([
            'factories',
            'acceptedBy',
            'doneBy',
            'createdBy',
            'department',
            'ticketDetails',
            'hasStatus',
            'hasType.hasProblem',
            'hasRate',
            'hasApprove'
        ])
            ->orderBy(function ($query) {
                $query->from('ticket_details')
                    ->whereColumn('ticket_details.ticket_id', 'tickets.id')
                    ->select('id')
                    ->latest()
                    ->limit(1);
            }, 'desc')->get();

        // Manually create a paginator
        $currentPage = $request->page ?? 1; // Use the page parameter from the request or default to 1

        $items = $tickets->slice(($currentPage - 1) * $perPage, $perPage)->all();

        // Create the paginator instance
        $rs = new LengthAwarePaginator($items, $tickets->count(), $perPage, $currentPage, [
            'path' => LengthAwarePaginator::resolveCurrentPath(),
            'pageName' => 'page',

        ]);

        //$rs['test'] =  Auth::user()->id_factory;
        dd($rs);
        return response()->json($rs);
    }


    public function test2()
    {
        // $user = Auth::user();

        // $year  = 2024;
        // $results = DB::select('EXEC dbo.usp_TicketingSystem_StatsProcessTimeByMonth @pYear = :year', ['year' => $year]);
        // $labels = [];
        // $staffData = [];
        // $ratingData = [];

        // foreach ($results as $result) {
        //     $labels[] = $result->TransMonth;
        //     $MTTR_MeanTimeToRepair[] = $result->MTTR_MeanTimeToRepair;
        //     $TRT_TicketResponseTime[] = $result->TRT_TicketResponseTime;
        // }


        // dd()


        //dd(Auth::user()->hasRole('ticket-sorter'));


        // DB::table('model_has_roles')->insert([
        //     'role_id' => 10,
        //     'model_type' => 'App\Models\User', // Đây là namespace của mô hình User
        //     'model_id' => 18233, // ID của người dùng cụ thể
        // ]);

        //
        //  $user_create_ticket = Ticket::find(1191)->subtasks->pluck('id_user')->unique();;
        //   dd($user_create_ticket);

        // $ticket = ticket::with(['factories', 'subtasks'])->find(1178);

        // $id_factory_ticket = $ticket->factories->id;
        // $id_country_ticket = $ticket->factories->id_country;


        // //Select all country
        // $ForwarderAllContry = User::permission('forward-all-factories')->where('is_blocked','!=', true)->pluck('id');
        // dd($ForwarderAllContry);


        // //Select in country
        // $ForwarderInContry = User::permission('forward-in-country')->where('id_country', $id_country_ticket)->where('is_blocked','!=', true)->pluck('id');

        // //Select 1 factory
        // $ForwarderInFactory = User::permission('forward-in-factory')->where('id_factory', $id_factory_ticket)->where('is_blocked','!=', true)->pluck('id');


        // $ticketSorter = $ForwarderAllContry->merge($ForwarderInContry)->merge($ForwarderInFactory)->unique();


        // $user_created = $ticket->created_by;

        // //get list id user handle Ticket_Holer
        // $Ticket_Holer = $ticket->subtasks->pluck('id_user')->unique();


        // $ticket = ticket::with(['factories', 'subtasks'])->find(1086);
        // $ticketSorter = $ticket->subtasks->pluck('id_user')->unique();
        // dd   ((new TicketController)->GetListUserNotification(1086, 'new_subtaks_ticket'));


        // $type  = 'approve_holding_subtaks_ticket';

        // $id_factory_ticket = $ticket->factories->id;
        // $id_country_ticket = $ticket->factories->id_country;


        // //Select all country
        // $ForwarderAllContry = User::whereHas('permissions', function ($query) {
        //     $query->where('name', 'forward-all-factories');
        // })->pluck('id');


        // //Select in country
        // $ForwarderInContry = User::whereHas('permissions', function ($query) use ($id_country_ticket) {
        //     $query->where('name', 'forward-in-country')->where('id_country', $id_country_ticket);
        // })->pluck('id');


        // //Select 1 factory
        // $ForwarderInContry = User::whereHas('permissions', function ($query) use ($id_factory_ticket) {
        //     $query->where('name', 'forward-in-factory')->where('id_country', $id_factory_ticket);
        // })->pluck('id');


        // $Ticket_Holer = $ForwarderAllContry->merge($ForwarderAllContry)->merge($ForwarderInContry);
        // $user_created = $ticket->created_by;

        // //get list id user handle
        // $ticketSorter = $ticket->subtasks->pluck('id_user');


        // switch ($type) {
        //     case 'user_created_ticket':
        //         $ListIDGetNotification = $ticketSorter;
        //         break;
        //     case 'holder_reject_ticket':
        //         $ListIDGetNotification = $user_created;
        //         break;
        //     case 'holder_subtaks_ticket':
        //         $ListIDGetNotification = $Ticket_Holer->merge($user_created);
        //         break;
        //     case 'holding_subtaks_ticket':
        //         $ListIDGetNotification = $ticketSorter;
        //         break;
        //     case 'approve_holding_subtaks_ticket':
        //         $ListIDGetNotification = $Ticket_Holer->merge($user_created);
        //         break;
        //     case 'reject_holding_subtaks_ticket':
        //         $ListIDGetNotification = $Ticket_Holer;
        //         break;
        //     case 'canncel_holding_subtaks_ticket':

        //         break;
        //     case 'auto_done_ticket':
        //         $ListIDGetNotification = $user_created;
        //         break;
        //     case 're-open_ticket':
        //         $ListIDGetNotification = $Ticket_Holer;
        //         break;
        //     case 'finished_ticket':

        //         break;

        //     default:
        //         # code...
        //         break;
        // }

        // $notifications = $ListIDGetNotification->unique(); // Get unique notifications
        // $userNotifications = Auth::user()->id; // Get authenticated user's ID

        // $notificationsDiff = $notifications->diff($userNotifications)->toArray(); // Find the difference

        // return $notificationsDiff;
    }
}
