<?php

namespace App\Http\Controllers;

use App\Events\Messenge;
use App\Models\Conversations;
use App\Models\Messenger;
use App\Models\Participant;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class MessengersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $contacts = User::where('id', 30)->get();
        $chats = Conversations::with(['participants', 'messages' => function ($query) {
            $query->where('user_id', '!=', Auth::id())->orderBy('created_at', 'desc')->take(1);
        }])
            ->whereHas('participants', function ($query) {
                $query->where('user_id', Auth::id());
            })
            ->get();
        return view('messages', compact('contacts', 'chats'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $valiate = $request->validate([
            'messcontent' => 'max:1000',
            'conversation_id' => 'exists:conversations,id | required'
        ]);

        $messenge = new Messenger();
        $messenge->user_id = Auth::id();
        $messenge->content =$request->messcontent;
        $messenge->conversation_id =$request->conversation_id;
        if( $messenge->save()){
            $userList = Participant::where('conversation_id', $request->conversation_id)->pluck('user_id')->toArray();
            $Messenge = [
                'userList' => $userList,
                'type' => 'Reply',
                'conversation_id' => $messenge->conversation_id,
                'user_send' =>  Auth::id()
            ];
            Broadcast(new Messenge($Messenge));

            return response()->json(['conversationID' => $request->conversation_id], 200);
        }
       return  $request;
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */


    public function showListMessNoti(){

    }

    public function show($id)
    {
        $messList = Messenger::all();
        return  response()->json($messList);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

}
