<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use App\Notification;
use Illuminate\Support\Facades\Auth;
use App\Message;

class NotificationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $notifications = Auth::user()->notifications()
            ->where('type', 'App\Notifications\GreetingNotification')
            ->cursorPaginate(20);

        //Query $notification->data['user_id_created']} to user with find(id)

        foreach ($notifications as $notification) {
            $notification->fullname = User::find($notification->data['user_id_created'])->fullname;
        }

        return view('notifications', compact('notifications'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $user = Auth::user();
//        if ($user && $user->id == $id) {
//            $notification = Notification::where('notifiable_type', get_class($user))
//                ->where('notifiable_id', $id)
//                ->find($notificationId);
//            return response()->json($notification);
//        }
        $notifications = $user->notifications;

        return response()->json($notifications);


    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $user = Auth::user();
        $user = auth()->user();
        $notifications = $user->notifications()
            ->where('type', 'App\Notifications\GreetingNotification')
            ->take(10)
            ->get()
            ->toArray();

        $numUnread = $user->notifications()
            ->where('type', 'App\Notifications\GreetingNotification')->where('read_at', null)->count();

        $results = [
            'notifications' => $notifications,
            'numUnread' => $numUnread,
        ];

        return $results;

        //return response()->json($results);
    }

    public function showMesNoti()
    {
        $user = Auth::user();
        $notifications = $user->notifications()
            ->where('type', 'App\Notifications\MessengeNotification')
            ->take(10)
            ->get()
            ->toArray();


        $numUnread = $user->notifications()->where('read_at', null)->where('type', 'App\Notifications\MessengeNotification')->count();
        $results = [
            'notifications' => $notifications,
            'numUnread' => $numUnread,
        ];

        return $results;

    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */

    function MakeReadAll()
    {
        $user = Auth::user();
        $user->unreadNotifications->markAsRead();
        return response()->json(['message' => 'All notifications marked as read.']);

    }

    public function readMessengeNotification($id)
    {
        $user = Auth::user();
        $notification = $user->notifications->find($id);
        if ($notification) {
            $notification->markAsRead();
            return response('Success', 200);
        } else {
            return response('Notification not found', 404);
        }
    }

    public function update(Request $request, $id)
    {
        $user = Auth::user();
        $notification = $user->notifications->find($id);
        if ($notification) {
            $notification->markAsRead();
            return response()->json(['status' => 'success', 'message' => 'Notification marked as read']);

        } else {
            return response()->json(['status' => 'error', 'message' => 'Notification not found or it does not belong to the user']);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $user = Auth::user();
        $notification = $user->notifications->find($id);
        if ($notification) {
            $notification->delete();
            return response()->json(['status' => 'success', 'message' => 'Notification marked as read']);

        } else {
            return response()->json(['status' => 'error', 'message' => 'Notification not found or it does not belong to the user']);
        }
    }
}
