<?php
// app/Http/Controllers/PasswordController.php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class PasswordController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function showChangePasswordForm()
    {
        return view('changepass');
    }

    public function changePassword(Request $request)
    {

        #password =  min 12 characters, at least one uppercase letter, one lowercase letter, one number and one special character
        $request->validate([
            'password' => [
                'required',
                'string',
                'min:12',
                'confirmed',
                'regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*(_|[^\w])).+$/'
            ],
            'password_confirmation' => ['required', 'string', 'min:12'],
        ], [
            'password.regex' => 'The password format is invalid. Please make sure it contains at least one lowercase letter, one uppercase letter, one digit, and one special character.',
        ]);


        if ($request->password != $request->password_confirmation) {
            return redirect()->route('changepass')->with('error', 'Password and Confirm Password do not match.');
        } else {
            Auth::user()->update([
                'password' => Hash::make($request->password),
                'first_time_login' => "2",
                'LastedUpdatePassword' => now()
            ]);

            //Out Auth
            Auth::logout();

            return redirect()->route('login')->with('status', 'Password changed successfully!');
        }


    }
}
