<?php

namespace App\Http\Controllers;

use App\Models\Ticket;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

use function PHPSTORM_META\map;

class ReportsConroller extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View|\Illuminate\Http\Response
     */
    public function index()
    {
        $id_dept = Auth::user()->id_dept;
        $chart_finish_user_query = DB::select(
            /** @lang text */
            "
                    SELECT a.username, d.fullname, AVG(c.staff_star) as avg_star, COUNT(c.staff_star) as ticket_finish_count
                        FROM HR.dbo.TicketingSystem_users AS a
                                 INNER JOIN HR.dbo.TicketingSystem_tickets AS b ON
                                    b.users_handle_id = CAST(a.id AS VARCHAR) OR
                                    b.users_handle_id LIKE CAST(a.id AS VARCHAR) + ',%' OR
                                    b.users_handle_id LIKE '%,' + CAST(a.id AS VARCHAR) + ',%' OR
                                    b.users_handle_id LIKE '%,' + CAST(a.id AS VARCHAR)
                                 INNER JOIN HR.dbo.TicketingSystem_ticket_finish_detail as c ON c.id_ticket = b.id
                                 INNER JOIN HR.dbo.staff as d ON a.username = d.id_staff
                                 WHERE a.id_dept = $id_dept
                        GROUP BY a.username, d.fullname
                "
        );

        $chartProblem = DB::select("
        select count(b.name) as count, b.name as problem , c.name as contry from TicketingSystem_tickets as a
            inner join  TicketingSystem_prolem_lists as b on a.type = b.id
            inner join TicketingSystem_factories as c on a.factories_id = c.id
        group by b.name, c.name
        ");

        $table1 = DB::select("SELECT a.username, d.fullname,e.name as factories,  AVG(c.staff_star) as avg_star, COUNT(c.staff_star) as ticket_finish_count
        FROM HR.dbo.TicketingSystem_users AS a
                 INNER JOIN HR.dbo.TicketingSystem_tickets AS b ON
                    b.users_handle_id = CAST(a.id AS VARCHAR) OR
                    b.users_handle_id LIKE CAST(a.id AS VARCHAR) + ',%' OR
                    b.users_handle_id LIKE '%,' + CAST(a.id AS VARCHAR) + ',%' OR
                    b.users_handle_id LIKE '%,' + CAST(a.id AS VARCHAR)
                 INNER JOIN HR.dbo.TicketingSystem_ticket_finish_detail as c ON c.id_ticket = b.id
                 INNER JOIN HR.dbo.staff as d ON a.username = d.id_staff
                 INNER JOIN TicketingSystem_factories as e on b.factories_id = e.id
        GROUP BY a.username, d.fullname, e.name");


        $table2 = DB::select("EXEC [Ticketing_system_reports]", []);
        $labels = [];
        $data = [];


        foreach ($chart_finish_user_query as $item) {
            $labels[] = $item->fullname;
            $data[] = [
                'avg' => $item->avg_star,
                'sum' => $item->ticket_finish_count,
            ];
        }


        $chartData = [
            'labels' => $labels,
            'datasets' => [
                [
                    'label' => 'Average Stars',
                    'data' => array_column($data, 'avg'),
                    'borderWidth' => 1,
                ],
                [
                    'label' => 'Ticket Finish Count',
                    'data' => array_column($data, 'sum'),
                    'borderWidth' => 1,
                ],
            ],
        ];





        return view('reports', compact('chartData', 'chartProblem', 'table1', 'table2'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }



    function percentStatusChart(Request $request)
    {
        $year = $request->year;
        $id_factory = $request->factory;

        $totalTicket = Ticket::count();
        $totalTicketDone = Ticket::where('status', 6)->count();
        $totalTicketFinish = Ticket::where('status', 4)->count();


        $labels = [];
        $ticketDoneData = [];
        $ticketFinishData = [];

        $results = DB::select('
        EXEC [dbo].[usp_TicketingSystem_StatsTicket] 
		 @pYear = :year
		 , @pFactoryId = :factory
        ', ['year' => $year, 'factory' => $id_factory]);

        foreach ($results as $result) {
            $labels[] = $result->TransMonth;
            $ticketDoneData[] = $result->NumOfTicketDone;
            $ticketFinishData[] = $result->NumOfTicketFinished;
        }


        return response()->json([
            'totalTicket' => $totalTicket,
            'totalTicketDone' => $totalTicketDone,
            'totalTicketFinish' => $totalTicketFinish,
            'labels' => $labels,
            'ticketDoneData' => $ticketDoneData,
            'ticketFinishData' => $ticketFinishData

        ]);
    }



    public function StatsProcessTimeByProblemType(Request $request)
    {
        $year = $request->year;
        $id_factory = $request->factory;

        $results = DB::select('EXEC dbo.usp_TicketingSystem_StatsProcessTimeByProblemType @pYear = :year , @pFactoryId = :factory', ['year' => $year, 'factory' => $id_factory]);
        $data = [];
        $labels = [];
        $MTTR_MeanTimeToRepair = [];
        $TRT_TicketResponseTime = [];

        foreach ($results as $result) {

            $typeIssue = $result->ProblemName;
            $typeIssue = str_replace(' ', '', $typeIssue);
            if (!isset($data[$typeIssue])) {
                $data[$typeIssue] = [
                    'labels' => [],
                    'MTTR_MeanTimeToRepair' => [],
                    'TRT_TicketResponseTime' => []
                ];
            }
            // Append data to arrays
            $data[$typeIssue]['labels'][] = $result->TransMonth;
            $data[$typeIssue]['MTTR_MeanTimeToRepair'][] = $result->MTTR_MeanTimeToRepair;
            $data[$typeIssue]['TRT_TicketResponseTime'][] = $result->TRT_TicketResponseTime;

        }

        return response()->json($data);

    }

    public function TicketDowntimeByIssueChart(Request $request)
    {
        $year = $request->year;
        $id_factory = $request->factory;
        $type = $request->type;

        $results = DB::select('EXEC dbo.usp_TicketingSystem_StatsProcessTimeByType @pYear = :year , @pFactoryId = :factory', ['year' => $year, 'factory' => $id_factory]);
        $data = [];
        $labels = [];
        $MTTR_MeanTimeToRepair = [];
        $TRT_TicketResponseTime = [];




        foreach ($results as $result) {

            $typeIssue = $result->TypeName;
            $typeIssue = str_replace(' ', '', $typeIssue);
            if (!isset($data[$typeIssue])) {
                $data[$typeIssue] = [
                    'labels' => [],
                    'MTTR_MeanTimeToRepair' => [],
                    'TRT_TicketResponseTime' => []
                ];
            }
            // Append data to arrays
            $data[$typeIssue]['labels'][] = $result->TransMonth;
            $data[$typeIssue]['MTTR_MeanTimeToRepair'][] = $result->MTTR_MeanTimeToRepair;
            $data[$typeIssue]['TRT_TicketResponseTime'][] = $result->TRT_TicketResponseTime;

        }

        return response()->json($data);
    }



    public function AvgChartStar(Request $request)
    {
        $id_factory = $request->factory;
        $results = DB::select("SELECT b.fullname, AVG(d.staff_star) as AVG_staff_star , AVG(d.star) as AVG_ticket_star , count(c.id) as TicketCount from TicketingSystem_SubTaks as a
        inner join TicketingSystem_users as b on a.id_user = b.id
        inner join TicketingSystem_tickets as c on c.id = a.id_ticket
        inner join TicketingSystem_ticket_finish_detail as d on d.id_ticket  = c.id
        where c.factories_id = $id_factory
        group by b.fullname
        ");

        $labels = [];
        $AVG_staff_star = [];
        $AVG_ticket_star = [];
        $TicketCount = [];

        foreach ($results as $result) {
            $labels[] = $result->fullname;
            $AVG_staff_star[] = $result->AVG_staff_star;
            $AVG_ticket_star[] = $result->AVG_ticket_star;
            $TicketCount[] = $result->TicketCount;
        }


        $data =[
            'labels' => $labels,
            'AVG_staff_star' => $AVG_staff_star,
            'AVG_ticket_star' => $AVG_ticket_star,
            'TicketCount' => $TicketCount,
        ];

        return response()->json($data);

    }

    public function TicketDownTimeChart(Request $request)
    {

        $year = $request->year;
        $id_factory = $request->factory;
        $results = DB::select('EXEC dbo.usp_TicketingSystem_StatsProcessTimeByMonth @pYear = :year , @pFactoryId = :factory', ['year' => $year, 'factory' => $id_factory]);
        $labels = [];
        $MTTR_MeanTimeToRepair = [];
        $TRT_TicketResponseTime = [];

        foreach ($results as $result) {
            $labels[] = $result->TransMonth;
            $MTTR_MeanTimeToRepair[] = $result->MTTR_MeanTimeToRepair;
            $TRT_TicketResponseTime[] = $result->TRT_TicketResponseTime;
        }
        $data['radarChart'] = [
            'labels' => $labels,
            'MTTR_MeanTimeToRepair' => $MTTR_MeanTimeToRepair,
            'TRT_TicketResponseTime' => $TRT_TicketResponseTime,
        ];

        return response()->json($data);
    }

    public function radarChart(Request $request)
    {

        $month = $request->month;
        $year = $request->year;
        $factory = $request->factory;
        $query = "
        SELECT d.fullname, b.id_user, 
               AVG(c.staff_star) as AVG_Staff, 
               AVG(c.star) as AVG_Rating
        FROM TicketingSystem_tickets as a
        INNER JOIN TicketingSystem_SubTaks as b ON a.id = b.id_ticket
        INNER JOIN TicketingSystem_ticket_finish_detail as c ON a.id = c.id_ticket
        INNER JOIN TicketingSystem_users as d ON b.id_user = d.id
        WHERE a.status = 4
          AND YEAR(a.created_at) = $year
          AND MONTH(a.created_at) = $month
          AND d.id_factory = $factory
          AND b.deleted_at is null
        GROUP BY b.id_user, d.fullname,MONTH(a.created_at)
    ";

        $tickets = DB::select(DB::raw($query));

        // Prepare the data for the radar chart
        $labels = [];
        $staffData = [];
        $ratingData = [];

        foreach ($tickets as $ticket) {
            $labels[] = $ticket->fullname;
            $staffData[] = $ticket->AVG_Staff;
            $ratingData[] = $ticket->AVG_Rating;
        }

        // Convert PHP arrays to JSON
        // $labelsJson = join($labels,);
        // $staffDataJson = json_encode($staffData);
        // $ratingDataJson = json_encode($ratingData);

        $data['radarChart'] = [
            'labels' => $labels,
            'staffData' => $staffData,
            'ratingData' => $ratingData,
        ];


        return response()->json($data);
    }
}
