<?php

namespace App\Http\Controllers;

use App\Models\SubTaks;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Jobs\WriteHistoryTicket;
use App\Jobs\ProcessTicketUpdate;
use App\Models\Ticket;
use App\Models\User;

class SubTaksController extends Controller
{


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        //

    }

    public function checkSubTaskEmpty($id)
    {
        $subTasks = SubTaks::find($id);
        return response()->json($subTasks);
    }

    public function updateholdingsustaks($id, Request $request)
    {
        $subTasks = SubTaks::find($id);
        $id_ticket = $subTasks->id_ticket;
        $subTasks->request = $request->subtask_request;
        $subTasks->id_status = 14; //Request Holding

        if ($subTasks->save()) {
            (new TicketController)->handleTicketStatusWithSubTasksStatus($id_ticket);
            $ticket = Ticket::find($subTasks->id_ticket);
            $NameHandle = User::where('id', $subTasks->created_by)->first()->fullname;
            $forwardName = Auth::user()->fullname;
            $ticketNoti = [
                'title' => "Ticket id#{$ticket->id} has new holding",
                'text' => "{$forwardName} request to {$NameHandle} for holding ticket #{$ticket->id}",
                'id' => $ticket->id,
                'type' => "Ticket",
                'user_id_created' => Auth::user()->id,
                'user_receive' => (new TicketController)->GetListUserNotification($subTasks->id_ticket, 'holding_subtaks_ticket')

            ];


            WriteHistoryTicket::dispatch($ticket, 'Ticket Holding', "Request Holding to $NameHandle", Auth::user()->id);
            ProcessTicketUpdate::dispatch($ticketNoti);

            return response()->json(['message' => 'Update success', 'id_ticket' => $ticket->id]);
        } else {
            return response()->json(['message' => 'Update fail']);
        }
    }


    //done_subtask
    public function done_subtask($id)
    {
        $subTasks = SubTaks::find($id);


        if ($subTasks) {
            $subTasks->id_status = 12;
            $subTasks->save();

            (new TicketController)->handleTicketStatusWithSubTasksStatus($subTasks->id_ticket);
            $ticket = Ticket::find($subTasks->id_ticket);
            $NameHandle = User::where('id', $subTasks->id_user)->first()->fullname;
            $forwardName = Auth::user()->fullname;

            return response()->json(['message' => 'Update success']);
        } else {
            return response()->json(['message' => 'Update fail']);
        }
    }

    //reject_subtask
    public function reject_subtask($id)
    {
        $subTasks = SubTaks::find($id);


        if ($subTasks) {
            $subTasks->id_status = 11;
            $subTasks->save();
            (new TicketController)->handleTicketStatusWithSubTasksStatus($subTasks->id_ticket);
            $ticket = Ticket::find($subTasks->id_ticket);
            $NameHandle = User::where('id', $subTasks->id_user)->first()->fullname;
            $forwardName = Auth::user()->fullname;

            $ticketNoti = [
                'title' => "Ticket id#{$ticket->id} has reject request holding",
                'text' => "{$forwardName} request to {$NameHandle} for reject holding ticket #{$ticket->id}",
                'id' => $ticket->id,
                'type' => "Ticket",
                'user_id_created' => Auth::user()->id,
                'user_receive' => [intval($subTasks->id_user)]

            ];


            WriteHistoryTicket::dispatch($ticket, 'Ticket Holding', "Request Holding to $NameHandle", Auth::user()->id);
            ProcessTicketUpdate::dispatch($ticketNoti);


            return response()->json(['message' => 'Update success']);
        } else {
            return response()->json(['message' => 'Update fail']);
        }
    }




    //sub taks cancel request 

    public function cancel_request_subtask($id)
    {
        $subTasks = SubTaks::find($id);


        if ($subTasks) {
            $subTasks->id_status = 11;
            $subTasks->save();
            (new TicketController)->handleTicketStatusWithSubTasksStatus($subTasks->id_ticket);
            $ticket = Ticket::find($subTasks->id_ticket);
            $NameHandle = User::where('id', $subTasks->id_user)->first()->fullname;

            WriteHistoryTicket::dispatch($ticket, 'Canncel holding', "$NameHandle cancel holding", Auth::user()->id);

            return response()->json(['message' => 'Update success']);
        } else {
            return response()->json(['message' => 'Update fail']);
        }
    }

    //subtasksapproveds
    public function subtasksapproveds($id)
    {
        $subTasks = SubTaks::find($id);
        $subTasks->id_status = 13;

        if ($subTasks->save()) {
            (new TicketController)->handleTicketStatusWithSubTasksStatus($subTasks->id_ticket);
            $ticket = Ticket::find($subTasks->id_ticket);
            $NameHandle = User::where('id', $subTasks->id_user)->first()->fullname;
            $forwardName = Auth::user()->fullname;
            $ticketNoti = [
                'title' => "Ticket id#{$ticket->id} has new Approved request holding",
                'text' => "{$forwardName} Approved request holding of {$NameHandle} in ticket #{$ticket->id}",
                'id' => $ticket->id,
                'type' => "Ticket",
                'user_id_created' => Auth::user()->id,
                'user_receive' => [intval($subTasks->id_user)]
            ];


            WriteHistoryTicket::dispatch($ticket, 'Approved task', "{$forwardName} approved $NameHandle request", Auth::user()->id);
            ProcessTicketUpdate::dispatch($ticketNoti);

            return response()->json(['message' => 'Update success']);
        } else {
            return response()->json(['message' => 'Update fail']);
        }
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'subtask_title' => 'required',
            'subtask_staff' => 'required|numeric',
            'id_ticket' => 'required|numeric',
        ]);

        //insert
        $subtabInsert = SubTaks::create([
            'id_ticket' => $request->id_ticket,
            'id_status' => 11,
            'task_name' => $request->subtask_title,
            'reason' => $request->subtask_reason,
            'solution' => $request->subtask_solution,
            'id_user' => $request->subtask_staff,
            'created_by' => Auth::id(),
            'updated_by' => Auth::id(),
        ]);

        //check insert success return
        //list id staff current handle  = Ticket::find($subtabInsert->id_ticket)->created_by

        if ($subtabInsert) {
            (new TicketController)->handleTicketStatusWithSubTasksStatus($subtabInsert->id_ticket);
            $ticket = Ticket::find($subtabInsert->id_ticket);

            if ($ticket->assign_at == null) {
                $ticket->assign_at = now();
            }
            $ticket->save();
            $user_create_ticket = $ticket->created_by;
            $current_staff_handle = intval($request->subtask_staff);
            $mergedArray = [$user_create_ticket, $current_staff_handle];
            $userId = Auth::user()->id;
            $mergedArray = collect($mergedArray)->flatten()->reject(function ($userIdInArray) use ($userId) {
                return $userIdInArray == $userId;
            })->toArray();







            //$list_sent = $current_staff_handle->merge($user_create_ticket);

            $NameHandle = User::where('id', $subtabInsert->id_user)->first()->fullname;
            $forwardName = Auth::user()->fullname;
            $ticketNoti = [
                'title' => "Ticket id#{$ticket->id} has new assign",
                'text' => "{$forwardName} has assigned {$NameHandle} to handle ticket #{$ticket->id}",
                'id' => $ticket->id,
                'type' => "Ticket",
                'user_id_created' => Auth::user()->id,
                'user_receive' => $mergedArray
            ];


            WriteHistoryTicket::dispatch($ticket, 'Forward ticket', "Assign to $NameHandle", Auth::user()->id);
            ProcessTicketUpdate::dispatch($ticketNoti);

            return response()->json(['message' => 'Insert success']);
        } else {
            return response()->json(['message' => 'Insert fail']);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $subTasks = SubTaks::with(['Status', 'user_assign', 'staff_handle', 'updated_by'])->where('id_ticket', $id)->get();
        return response()->json(['data' => $subTasks]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = SubTaks::with(['Status', 'staff_handle', 'user_assign'])->find($id);
        return response()->json($data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $subTask = SubTaks::find($id);

        // Check if the subtask exists
        if (!$subTask) {
            return response()->json(['message' => 'Subtask not found'], 404);
        }


        $subTaskData = [
            'updated_by' => Auth::id()
        ];

        if ($request->has('subtask_title')) {
            $subTaskData['task_name'] = $request->subtask_title;
        }

        if ($request->has('subtask_reason')) {

            $subTaskData['reason'] = $request->subtask_reason;
        }

        if ($request->has('subtask_solution')) {
            $subTaskData['solution'] = $request->subtask_solution;
        }

        if ($request->has('subtask_staff')) {
            $subTaskData['id_user'] = $request->subtask_staff;
        }

        if ($request->has('subtask_request')) {
            $subTaskData['request'] = $request->subtask_request;
        }


        $subTask->update($subTaskData);

        // Check if the update was successful
        if ($subTask->wasChanged()) {
            return response()->json(['message' => 'Update success']);
        } else {
            return response()->json(['message' => 'Update fail']);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $subTask = SubTaks::find($id);

        // Kiểm tra xem $subTask có tồn tại không
        if ($subTask) {

            $countNumberStaffSubstaff = SubTaks::where('id_ticket', $subTask->id_ticket)->count();
            $subTask->deleted_by = Auth::id(); // Gán người thực hiện soft delete


            $NameHandle = User::where('id', $subTask->id_user)->first()->fullname;
            WriteHistoryTicket::dispatch(Ticket::find($subTask->id_ticket), 'Delete Task', "Remove $NameHandle in task", Auth::user()->id);


            $subTask->save(); // Lưu thay đổi
            $subTask->delete(); // Thực hiện soft delete


            //count number staff in sub staff if count > 1 run below
            if ($countNumberStaffSubstaff > 1) {
                (new TicketController)->handleTicketStatusWithSubTasksStatus($subTask->id_ticket);

            }

            // Sử dụng phương thức delete() để thực hiện soft delete






            return response()->json(['message' => 'Soft delete success']);
        } else {
            return response()->json(['message' => 'Subtask not found'], 404);
        }
    }
}
