<?php

namespace App\Http\Controllers;

use App\Jobs\ProcessTicketUpdate;
use App\Jobs\SendMailForUserCreatedTicket;
use App\Jobs\SendMailVeryAccount;
use App\Jobs\WriteHistoryTicket;
use App\Mail\SendMail;
use App\Models\MailConfig;
use App\Services\EmailConfigManager;
use Illuminate\Http\Request;
use App\Events\Messenge;
use App\Models\Problems;
use App\Models\SubTaks;
use App\Models\Ticket;
use App\Models\TicketStatus;
use App\Models\Factories;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Laravolt\Avatar\Avatar;
use Spatie\Permission\Models\Permission;
use ZipArchive;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Hash;
use App\Mail\TicketCreated;
use Illuminate\Support\Facades\Mail;
use Illuminate\Queue\Jobs\Job;

class Testcontroller extends Controller
{

    public function testJob()
    {
//        $emailConfigManager = new EmailConfigManager();
//        $mailConfigs = MailConfig::all();
//        foreach ($mailConfigs as $config) {
//            $config->mail_encryption = false;
//            $emailConfigManager->applyConfig($config->toArray());
//            dd($config->toArray());
//        }


        // $user = User::where('username', 'admin')->first();
        //SendMailForUserCreatedTicket::dispatch(Ticket::find(3614));


        $ticketNoti = [
            'title' => "New Ticket ✉️ #3896",
            'text' => Auth::user()->fullname . " create ticket :" . 123123,
            'id' => 3896,
            'type' => "Ticket",
            'user_id_created' => 1,
            'user_receive' => [17439],
        ];


        //WriteHistoryTicket::dispatch($ticket, 'Create ticket', 'Create ticket', Auth::user()->id);
        ProcessTicketUpdate::dispatch($ticketNoti);

        //return response()->json(['ticket_id' => $id_TicketDetail], 200);


    }


    public function test(Request $request)
    {
        $perPage = 10;
        $currentPage = $request->input('page', 1);
        $offset = ($currentPage - 1) * $perPage;
        $search = $request->search;
        $userId = Auth::id();
        $querySearch = null;
        $factorySearch = null;
        $search['status'] = [1, 2, 3, 4, 5, 6, 7, 8, 9];
        $search['type'] = [1, 2, 3, 4, 5, 6, 7, 8, 9];
        $listPermissions = Auth::user()->getAllPermissions()->pluck('name');

        //dd($listPermissions);

        if (isset($search["title"])) {
            $querySearch .= " AND ( a.title like '%" . $search['title'] . "%' or a.id like '%" . $search['title'] . "%')";
        }
        if (isset($search["fullname"])) {
            $querySearch .= " AND ( b.fullname like '%" . $search['fullname'] . "%' or d.fullname like '%" . $search['fullname'] . "%')";
        }
        if (isset($search["department"])) {
            $querySearch .= " AND ( e.name like '%" . $search['department'] . "%')";
        }
        if (isset($search["factories"])) {
            $querySearch .= " AND (a.factories_id = " . $search['factories'] . ")";
        }

        if (isset($search["ranges"])) {
            $start_date = DateTime::createFromFormat('d/m/Y', $search['ranges'][0])->format('Y-m-d');
            $end_date = DateTime::createFromFormat('d/m/Y', $search['ranges'][1])->format('Y-m-d');
            $querySearch .= " AND a.date_send between '" . $start_date . "' and '" . $end_date . "'";
        }

        if ($querySearch === null) {
            $querySearch = " AND (a.created_by = $userId OR c.id_user = $userId)";
        }

        if (isset($search["status"])) {
            $querySearch .= " AND (a.status in (" . implode(",", $search['status']) . "))";
        } else {
            $querySearch .= " AND (a.status = 0)";
        }
        if (isset($search["type"])) {
            $querySearch .= " AND (a.type in (" . implode(",", $search['type']) . "))";
        } else {
            $querySearch .= " AND (a.type = 0)";
        }


//        Limit factory zone by role


//        if ($listPermissions->contains('forward-all-factories')) {
//            $factorySearch = " AND (f.id_country = " . Auth::user()->id_country . " OR d.id_country = " . Auth::user()->id_country . ")";
//        }


        if ($listPermissions->contains('forward-in-country')) {
            $factorySearch = " AND (f.id_country = " . Auth::user()->id_country . " OR d.id_country = " . Auth::user()->id_country . ")";
        }
        if ($listPermissions->contains('forward-in-factory')) {
            $factorySearch = " AND (e.factories_id = " . Auth::user()->id_factory . " OR d.id_factory = " . Auth::user()->id_factory . ")";
        }

        $tickets = DB::select("WITH CTE AS (
                SELECT
                    a.*,
                    h.name as statusName,
                    g.updated_at AS timeUpdate,
                    ROW_NUMBER() OVER (
                        PARTITION BY a.id
                        ORDER BY g.updated_at DESC
                        ) AS row_num
                FROM TicketingSystem_tickets AS a
             INNER JOIN TicketingSystem_users AS b ON a.created_by = b.id
             LEFT JOIN TicketingSystem_SubTaks AS c ON a.id = c.id_ticket
             LEFT JOIN TicketingSystem_users AS d ON c.id_user = d.id
                INNER JOIN TicketingSystem_factories AS f ON a.factories_id = f.id
                INNER JOIN TicketingSystem_ticket_details AS g ON a.id = g.ticket_id
                     INNER JOIN TicketingSystem_ticket_status as h ON a.status = h.id
              WHERE 1 = 1 $querySearch $factorySearch
),
                  TOTAL AS (
                      SELECT *
                      FROM CTE
                      WHERE row_num = 1
                  )
                     SELECT *
                     FROM (
                              SELECT *,
                                     ROW_NUMBER() OVER (ORDER BY timeUpdate DESC) AS row_num2
                              FROM TOTAL
                          ) AS FinalResult
                     WHERE row_num2 BETWEEN ? AND ?", [
            ($offset + 1),
            ($offset + $perPage)
        ]);

        $totalQuery = "WITH CTE AS (
        SELECT
            a.*,

            g.updated_at AS timeUpdate,
            ROW_NUMBER() OVER (
                PARTITION BY a.id
                ORDER BY g.updated_at DESC
            ) AS row_num
        FROM TicketingSystem_tickets AS a
        INNER JOIN TicketingSystem_users AS b ON a.created_by = b.id
        LEFT JOIN TicketingSystem_SubTaks AS c ON a.id = c.id_ticket
        LEFT JOIN TicketingSystem_users AS d ON c.id_user = d.id
        INNER JOIN TicketingSystem_factories AS f ON a.factories_id = f.id
        INNER JOIN TicketingSystem_ticket_details AS g ON a.id = g.ticket_id

        WHERE 1=1 $querySearch $factorySearch
    ),
    TOTAL AS (
        SELECT *
        FROM CTE
        WHERE row_num = 1
    )
    SELECT COUNT(*) AS totalCount FROM TOTAL";
        $totalResult = DB::selectOne($totalQuery);
        $total = $totalResult->totalCount;

        return response()->json([
            'data' => $tickets,
            'current_page' => $currentPage,
            'per_page' => $perPage,
            'total' => $total,
            'last_page' => ceil($total / $perPage),
        ]);
    }


}
