<?php

namespace App\Http\Controllers;

use App\Events\CreateIssue;
use App\Events\UsersNotification;
use App\Jobs\SendMailForUserCreatedTicket;
use App\Jobs\WriteHistoryTicket;
use App\Models\Countries;
use App\Models\Departments;
use App\Models\Factories;
use App\Models\FilesUpload;
use App\Models\ManagerPending;
use App\Models\ProblemLists;
use App\Models\SubTaks;
use App\Models\Ticket;
use App\Models\TicketDetail;
use App\Models\TicketHistory;
use App\Models\TicketRate;
use App\Models\TicketReject;
use App\Models\TicketStatus;
use App\Models\User;
use App\Notifications\GreetingNotification;
use Carbon\Carbon;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Bus;
use App\Jobs\ProcessTicketUpdate;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Concerns\ToArray;
use App\Mail\TicketCreated;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;


class TicketController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    public function ticket_offline(Request $request)
    {

        $request->validate([
            'time_start' => 'required',
            'time_end' => 'required',
            'holder_name' => 'required',
            'inputReason' => 'required',
            'inputSolution' => 'required',
        ]);
        $ticketNew = $this->store($request);
        $data = $ticketNew->getData();  // Lấy dữ liệu JSON dưới dạng đối tượng

        if (isset($data->ticket_id)) {
            // Tìm ticket theo ID
            $ticket = Ticket::find($data->ticket_id);

            if ($ticket) {
                $ticket->status = 4;
                $ticket->assign_at = Carbon::parse($request->time_start)->format('Y-m-d H:i:s');
                $ticket->finish_at = Carbon::parse($request->time_end)->format('Y-m-d H:i:s');
                $ticket->save();

                if (isset($request->holder_name) && count($request->holder_name) > 0) {

                    foreach ($request->holder_name as $key => $staff) {
                        SubTaks::create([
                            'id_ticket' => $data->ticket_id,
                            'id_status' => 12,
                            'task_name' => 'ticket offline',
                            'id_user' => $request->holder_name[$key],
                            'reason' => $request->inputReason[$key],
                            'solution' => $request->inputSolution[$key],
                        ]);
                    }


                }

                return $ticketNew;
            }
        } else {
            return $ticketNew;
        }


    }

    public function checkLimitCreateTicket()
    {
        $idUser = Auth::user()->id;

        //        $total_time_ago = DB::select("SELECT SUM(datediff(minute, created_at, getdate())) AS total_time_ago
        //FROM (
        //         SELECT TOP 5 datediff(minute, created_at, getdate()) AS time_ago, created_at
        //         FROM TicketingSystem_tickets
        //         WHERE created_by = $idUser
        //         ORDER BY created_at DESC
        //     ) AS ranked_tickets;");


        $status_opening = true;

        //new fix
        $total_time_ago = Ticket::where('created_by', $idUser)->orderBy('created_at', 'desc')->take(5)->get();

        $totalTime = $total_time_ago->sum(function ($ticket) {
            return Carbon::parse($ticket->created_at)->diffInMinutes(Carbon::now());
        });


        if ($total_time_ago->count() < 5) {
            if ($totalTime < 15) {
                $status_opening = true;
            }
        } else {
            if ($totalTime < 15) {
                $status_opening = false;
            }
        }


        $res = [
            'total_time_ago' => $totalTime,
            'status' => $status_opening,
            'wait' => 15 - $totalTime,
            'numberTicket' => $total_time_ago->count(),
        ];


        //check >15 return true else false and  countdown time
        return response()->json($res);
    }

    public function index(Request $request)
    {
        $perPage = 10;
        $currentPage = intval($request->input('page', 1));
        $search = $request->search;
        $userId = Auth::id();
        $querySearch = null;
        $factorySearch = null;
        $listPermissions = Auth::user()->getAllPermissions()->pluck('name');

        $joinDepartments = null;

        //dd($listPermissions);

        if (isset($search["title"])) {
            $querySearch .= " AND ( a.title like '%" . $search['title'] . "%' or a.id like '%" . $search['title'] . "%')";
        }
        if (isset($search["fullname"])) {
            $querySearch .= " AND ( b.fullname like '%" . $search['fullname'] . "%' or d.fullname like '%" . $search['fullname'] . "%')";
        }
        if (isset($search["department"])) {
            $joinDepartments = "INNER JOIN dbo.TicketingSystem_departments l WITH(NOLOCK) on l.factory_id =a.department_id";
            $querySearch .= " AND ( l.name like '%" . $search['department'] . "%')";
        }
        if (isset($search["factories"])) {
            $querySearch .= " AND (a.factories_id = " . $search['factories'] . ")";
        }

        if (isset($search["ranges"])) {
            $start_date = DateTime::createFromFormat('d/m/Y', $search['ranges'][0])->format('Y-m-d');
            $end_date = DateTime::createFromFormat('d/m/Y', $search['ranges'][1])->format('Y-m-d');
            $querySearch .= " AND a.date_send between '" . $start_date . "' and '" . $end_date . "'";
        }


        if (isset($search["onlyMe"])) {
            if ($search["onlyMe"] == 'true') {
                $querySearch = " AND (a.created_by = $userId OR c.id_user = $userId)";
            }
        } else {
            $querySearch = " OR (a.created_by = $userId OR c.id_user = $userId)";
        }


        //dd($querySearch);

        if (isset($search["status"])) {
            $querySearch .= " AND (a.status in (" . implode(",", $search['status']) . "))";
        } else {
            $querySearch .= " AND (a.status = 0)";
        }
        if (isset($search["type"])) {
            $querySearch .= " AND (k.id in (" . implode(",", $search['type']) . "))";
        } else {
            // $querySearch .= " AND (a.type = 0)";
        }

        if (!$listPermissions->contains('forward-all-factories')) {
            if ($listPermissions->contains('forward-in-country')) {
                $factorySearch = " AND (f.id_country = " . Auth::user()->id_country . " OR d.id_country = " . Auth::user()->id_country . ")";
            } else {
                if ($listPermissions->contains('forward-in-factory')) {
                    $factorySearch = " AND (e.factories_id = " . Auth::user()->id_factory . " OR d.id_factory = " . Auth::user()->id_factory . ")";
                } else {
                    $factorySearch = " AND (e.id_factory = " . Auth::user()->id_factory . " OR d.id_factory = " . Auth::user()->id_factory . ")";
                    $querySearch .= " AND (a.created_by = $userId OR c.id_user = $userId)";
                }
            }
        }


        $totalQuery = "WITH CTE AS (
        SELECT
            a.*,
            g.updated_at AS timeUpdate,
            ROW_NUMBER() OVER (
                PARTITION BY a.id
                ORDER BY g.updated_at DESC
            ) AS row_num
             FROM TicketingSystem_tickets AS a WITH(NOLOCK)
             INNER JOIN TicketingSystem_users AS b WITH(NOLOCK) ON a.created_by = b.id
             LEFT JOIN TicketingSystem_SubTaks AS c WITH(NOLOCK) ON a.id = c.id_ticket
             LEFT JOIN TicketingSystem_users AS d WITH(NOLOCK) ON c.id_user = d.id
             INNER JOIN TicketingSystem_users as e WITH(NOLOCK) ON a.created_by = e.id
             INNER JOIN TicketingSystem_factories AS f WITH(NOLOCK) ON a.factories_id = f.id
             INNER JOIN TicketingSystem_ticket_details AS g WITH(NOLOCK) ON a.id = g.ticket_id
             INNER JOIN TicketingSystem_ticket_status as h WITH(NOLOCK) ON a.status = h.id
             INNER JOIN TicketingSystem_prolem_lists as i WITH(NOLOCK) ON a.type = i.id
             LEFT JOIN TicketingSystem_ticket_finish_detail as j WITH(NOLOCK) ON a.id = j.id_ticket
             INNER JOIN TicketingSystem_problems as k WITH(NOLOCK) on k.id = i.problem_id
             $joinDepartments
        WHERE 1=1 $querySearch $factorySearch
    ),
    TOTAL AS (
        SELECT *
        FROM CTE
        WHERE row_num = 1
    )
    SELECT COUNT(*) AS totalCount FROM TOTAL";
        $totalResult = DB::selectOne($totalQuery);
        $total = intval($totalResult->totalCount);

        // Tính số trang thực tế
        $lastPage = (int)ceil($total / $perPage);
        if ($currentPage > $lastPage) {
            $currentPage = $lastPage;
        }
        if ($currentPage < 1) {
            $currentPage = 1;
        }
        $offset = ($currentPage - 1) * $perPage;

        $tickets = DB::select("WITH CTE AS (
                SELECT
                    a.*,
                    h.name as statusName,
                    h.display as statusDisplay,
                    g.updated_at AS timeUpdate,
                    k.name as problemName,
                    k.display as problemDisplay,
                    j.star as starCount,
                    e.fullname as created_by_name,
                    e.avatar_url as created_by_avatar,
                    e.id as created_by_id,
                    ROW_NUMBER() OVER (
                        PARTITION BY a.id
                        ORDER BY g.updated_at DESC
                        ) AS row_num
             FROM TicketingSystem_tickets AS a WITH(NOLOCK)
             INNER JOIN TicketingSystem_users AS b WITH(NOLOCK) ON a.created_by = b.id
             LEFT JOIN TicketingSystem_SubTaks AS c WITH(NOLOCK) ON a.id = c.id_ticket
             LEFT JOIN TicketingSystem_users AS d WITH(NOLOCK) ON c.id_user = d.id
             INNER JOIN TicketingSystem_users as e WITH(NOLOCK) ON a.created_by = e.id
             INNER JOIN TicketingSystem_factories AS f WITH(NOLOCK) ON a.factories_id = f.id
             INNER JOIN TicketingSystem_ticket_details AS g WITH(NOLOCK) ON a.id = g.ticket_id
             INNER JOIN TicketingSystem_ticket_status as h WITH(NOLOCK) ON a.status = h.id
             INNER JOIN TicketingSystem_prolem_lists as i WITH(NOLOCK) ON a.type = i.id
             LEFT JOIN TicketingSystem_ticket_finish_detail as j WITH(NOLOCK) ON a.id = j.id_ticket
             INNER JOIN TicketingSystem_problems as k WITH(NOLOCK) on k.id = i.problem_id
             $joinDepartments
              WHERE 1 = 1 $querySearch $factorySearch
),
                  TOTAL AS (
                      SELECT *
                      FROM CTE
                      WHERE row_num = 1
                  )
                     SELECT *
                     FROM (
                              SELECT *,
                                     ROW_NUMBER() OVER (ORDER BY timeUpdate DESC) AS row_num2
                              FROM TOTAL
                          ) AS FinalResult
                     WHERE row_num2 BETWEEN ? AND ?", [
            ($offset + 1),
            ($offset + $perPage)
        ]);


        return response()->json([
            'data' => $tickets,
            'current_page' => $currentPage,
            'per_page' => $perPage,
            'total' => $total,
            'last_page' => ceil($total / $perPage),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function requestapprovalTicket(Request $request, $id)
    {

        $ManagerPending = new ManagerPending();
        $ManagerPending->ticket_id = $id;
        $ManagerPending->manager_id = $request->Manager;
        $ManagerPending->user_created = Auth::id();
        $ManagerInfor = User::find($request->Manager);

        $ManagerPending->save();
        if ($ManagerPending->save()) {
            $ticket = Ticket::find($id);
            $ticket->status = 3;
            $ticket->accept_id = $ManagerPending->id;
            $ticket->save();
            $ticketNoti = [
                'title' => "Request acceptance",
                'text' => Auth::user()->fullname . " has sent a request for acceptance",
                'id' => $ticket->id,
                'type' => "Ticket",
                'user_id_created' => Auth::user()->id,
                'dept_id' => $ManagerInfor->id_dept,

            ];
            Broadcast(new CreateIssue($ticketNoti))->toOthers();
            $user = $ManagerInfor;
            $user->notify(new GreetingNotification($ticketNoti));
            return response()->json(['ticket_id' => $ticket->id], 200);
        } else {
            return response()->json(['message' => 'Ticket creation failed'], 400);
        }
    }

    public function loadDepartment($id)
    {
        $Departments = Departments::where('factory_id', $id)->get();
        $Auth = Auth::user()->Departments;
        $datas = [
            'Departments' => $Departments,
            'Auth' => $Auth->id,
        ];
        return response()->json($datas);
    }

    public function loadprolemType($id)
    {
        $ProlemList = ProblemLists::where('problem_id', $id)->get();
        return $ProlemList;
    }

    public function create()
    {
        $user = User::find(Auth::user()->id);
        $factories = Factories::all();
        $departments = Departments::all();
        $datas = [
            'user' => $user,
            'factories' => $factories,
            'departments' => $departments,

        ];
        return response()->json($datas);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        $validated = $request->validate([
            'problem' => 'required|max:255',
            'factories' => 'required',
            'departments' => 'required',
            'title' => 'required|min:1',
            'content' => 'required|max:4000',
        ]);

        $files = $request->file('file-input');
        $paths = [];
        $file_db_id = null;

        $ticket = new Ticket();
        $ticket->type = $request->input('type');
        $ticket->factories_id = $request->input('factories');
        $ticket->department_id = $request->input('departments');
        $ticket->status = 1;
        $ticket->date_send = date('Y-m-d');
        $ticket->created_by = Auth::id();
        $ticket->title = $request->input('title');
        $ticket->save();
        if ($ticket) {
            $id_TicketDetail = $ticket->id;
            $TicketDetail = new TicketDetail();
            $TicketDetail->ticket_id = $id_TicketDetail;
            $TicketDetail->user_id = Auth::id();
            $TicketDetail->contentData = $request->input('content');
            if ($TicketDetail->save()) {
                if ($request->hasFile('file-input')) {
                    foreach ($request->file('file-input') as $file) {
                        $filename = $file->getClientOriginalName();
                        $fileSize = $file->getSize();
                        $fileExtension = $file->getClientOriginalExtension();
                        //random name + extension
                        $hashNameFile = md5($filename . time());
                        $path = $file->storeAs('uploads', $hashNameFile);
                        FilesUpload::create([
                            'id_user' => Auth::id(),
                            'filename' => $filename,
                            'path' => $path,
                            'slug' => $hashNameFile,
                            'size' => $fileSize,
                            'extension' => $fileExtension,
                            'detail_ticket_id' => $TicketDetail->id,
                        ]);
                    }
                }

                $ticketNoti = [
                    'title' => "New Ticket ✉️ #$ticket->id",
                    'text' => Auth::user()->fullname . " create ticket :" . $ticket->title,
                    'id' => $ticket->id,
                    'type' => "Ticket",
                    'user_id_created' => Auth::user()->id,
                    'user_receive' => $this->GetListUserNotification($ticket->id, 'user_created_ticket'),
                ];


                WriteHistoryTicket::dispatch($ticket, 'Create ticket', 'Create ticket', Auth::user()->id);
                ProcessTicketUpdate::dispatch($ticketNoti);

                return response()->json(['ticket_id' => $id_TicketDetail], 200);
            };
        }
        return response()->json(['message' => 'Ticket creation failed'], 400);
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id)
    {
        $check = $this->check_permisionViewTicket($id);
        if (!$check) {
            return response()->json(['message' => 'Permission denied'], 400);
        }

        $TicketInfo = Ticket::with(['subtasks.staff_handle', 'factories', 'hasType.hasProblem'])->find($id);
        //dd($TicketInfo['subtasks'][0]['staff_handle']['fullname']);


        $TicketDetail = TicketDetail::with(['UserCreate', 'UserCreate.Departments', 'ticket.hasApprove', 'ticket.hasType', 'ticket.department', 'Files'])
            ->where('ticket_id', $id)
            ->orderBy('created_at', 'asc')
            ->get();


        // Lấy thông tin người dùng từ cột users_handle_id trong mô hình Ticket
        $TicketDetail->each(function ($detail) {
            // Tách chuỗi users_handle_id thành mảng các ID người dùng
            $userIds = explode(',', $detail->ticket->users_handle_id);

            // Truy vấn bảng User để lấy thông tin về người dùng
            $users = User::whereIn('id', $userIds)->get();

            // Thêm thông tin người dùng vào mô hình TicketDetail
            $detail->ticket->users_handle = $users;
        });


        $buttonList = array(

            'request_in_lark' => '<a  type="button" href = "https://x51wac9awp9.sg.larksuite.com/share/base/form/shrlgd0wxAGb5XmabXsUUTPBNcc" target = "_blank"
            class="btn btn-primary waves-effect waves-light">
            <i class="fa-solid fa-envelope"></i>&nbsp;
        <span class="align-middle">' . trans('ticket.request_in_lark') . '</span>
    </a>',


            'finish' => ' <button id="Ticket-finish" type="button"
                                                    class="btn btn-success waves-effect waves-light">
                                                <i class="ti ti-check ti-xs me-1"></i>
                                                <span class="align-middle">' . trans('ticket.Finish') . '</span>
                                            </button>',
            'approve' => ' <button id="Ticket-Approval" type="button"
                                                    class="btn btn-success waves-effect waves-light">
                                                <i class="ti ti-check ti-xs me-1"></i>
                                                <span class="align-middle">' . trans('ticket.Approval') . '</span>
                                            </button>',
            'send' => ' <button type="submit" id="sendComment" class="btn btn-primary waves-effect waves-light">
                                                <i class="ti ti-send ti-xs me-1"></i>
                                                <span class="align-middle">' . trans('ticket.Send') . '</span>
                                            </button>',
            'sendToApproval' => ' <button type="button" class="btn btn-primary waves-effect waves-light" id="Ticket-send-Approval" data-bs-toggle="modal" data-bs-target="#ModalToApproval">
                                                <i class="ti ti-arrow-forward-up ti-xs me-1"></i>
                                                <span class="align-middle">' . trans('ticket.To Approval') . '</span>
                                            </button>',
            'Forward' => ' <button type="button" class="btn btn-info waves-effect waves-light" id="Ticket-Forward" value=' . $id . '>
                                               <i class="fa-solid fa-forward"></i>
                                                <span class="align-middle"> ' . trans('ticket.break_down') . '</span>
                                            </button>',
            'Reject' => ' <button type="button" class="btn btn-danger waves-effect waves-light" id="Ticket-Reject" value=' . $id . '>
                                                <i class="ti ti-mail-off ti-xs me-1"></i>
                                                <span class="align-middle">' . trans('ticket.Reject') . '</span>
                                            </button>',

            'Solve' => ' <button type="button" class="btn btn-success waves-effect waves-light" data-status="done" id="Ticket-Solve" value=' . $id . '>
                                                <i class="ti ti-check ti-xs me-1"></i>
                                                <span class="align-middle">' . trans('ticket.Solve') . '</span>
                                            </button>',

            'holding_subtask' => ' <button id="holding_subtask" data-status="holding" type="button" value=' . $id . '
                                                    class="btn btn-warning waves-effect waves-light">
                                                <i class="ti ti-check ti-xs me-1"></i>
                                                <span class="align-middle">' . trans('ticket.holding_subtask') . '</span>
                                            </button>',

            'cancel_holding_subtask' => ' <button id="cancel_holding_subtask" data-status="holding" type="button" value=' . $id . '
                                                    class="btn btn-warning waves-effect waves-light">
                                                <i class="ti ti-check ti-xs me-1"></i>
                                                <span class="align-middle">' . trans('ticket.cancel_holding_subtask') . '</span>
                                            </button>',

            'Cancel' => ' <button type="button" class="btn btn-danger waves-effect waves-light" id="Ticket-Reject" value=' . $id . '>
                                                <i class="ti ti-mail-off ti-xs me-1"></i>
                                                <span class="align-middle">' . trans('ticket.Cancel') . '</span>
                                            </button>',

        );

        if (!empty($TicketDetail) && isset($TicketDetail[0])) {
            $ticketCount = TicketDetail::where('ticket_id', $id)->count();
            foreach ($TicketDetail as $detail) {
                $detail->formatted_created_at = Carbon::parse($detail->created_at)->format('M dS Y, h:i A');
                $detail->ticket_count = $ticketCount - 1;
            }
            $created_by = $TicketDetail[0]->ticket->created_by;
            $ticketHandle = $TicketDetail[0]->ticket->hasStatus;
            $dataApprove = $TicketDetail[0]->ticket->hasApprove;


            $userHandle = User::find(Auth::id());
            $ButtonTopArea = array();
            $ButtonBottomArea = array();
            $listUserHandle = $TicketDetail[0]->ticket->users_handle_id;

            // dd($TicketDetail[0]->ticket->hasType->id);
            //TicketInfo

            if ($TicketDetail[0]->ticket->hasType->hasProblem->id === 2) {

                //  if ($TicketDetail[0]->ticket->hasType->id === 5) {
                $ButtonBottomArea[] = $buttonList['request_in_lark'];
            }

            switch ($ticketHandle->id) {
                case 1:
                case 5:
                case 6:
                case 7:
                case 8:
                    $TextareaStatus = true;
                    $ButtonBottomArea[] = $buttonList['send'];

                    //Check im created ticket or not ?
                    if ($created_by === Auth::id()) {
                        if ($ticketHandle->id == 6) {
                            $ButtonBottomArea[] = $buttonList['finish'];
                        }
                        if ($ticketHandle->id != 4) {
                            $ButtonBottomArea[] = $buttonList['Cancel'];
                        }
                    }

                    // //Check im has solved or not
                    // $subTask = SubTaks::where('id_ticket', $id)->where('id_user', Auth::id())->first();

                    // if ($subTask) {
                    //     if ($subTask->id_status == 11) { // processing
                    //         $ButtonBottomArea[] = $buttonList['Solve'];
                    //         $ButtonBottomArea[] = $buttonList['holding_subtask'];
                    //     }
                    //     if ($subTask->id_status == 14 || $subTask->id_status == 13) {
                    //         $ButtonBottomArea[] = $buttonList['cancel_holding_subtask'];
                    //     }
                    // } else {
                    //     // Handle case where no subtask was found
                    //     // For example, you might want to show a message or take some other action
                    //     // You can add appropriate code here based on your application's logic
                    // }

                    break;

                default:
                    $TextareaStatus = false;
                    break;
            }
            //check $ticketHandle->id in ([1,5,6,7,8])
            if ($ticketHandle->id === 1 || $ticketHandle->id === 5 || $ticketHandle->id === 6 || $ticketHandle->id === 7 || $ticketHandle->id === 8) {

                if ($userHandle->hasPermissionTo('forward-in-factory') || $userHandle->hasPermissionTo('forward-in-country') || $userHandle->hasPermissionTo('forward-all-factories')) {

                    if ($userHandle->hasPermissionTo('forward ticket')) {
                        $ButtonBottomArea[] = $buttonList['Forward'];
                    }

                    if ($ticketHandle->id == 1) {
                        $ButtonBottomArea[] = $buttonList['Reject'];
                    }
                }
            } else {
                if ($ticketHandle->id === 3 && $dataApprove->manager_id === $userHandle->id) {
                    if ($dataApprove->accept === null) {
                        $TextareaStatus = true;
                        $ButtonBottomArea[] = $buttonList['send'];
                        $ButtonBottomArea[] = $buttonList['approve'];
                        $ButtonBottomArea[] = $buttonList['Reject'];
                    }
                }
            }

            $buttons = [
                'ButtonTopArea' => $ButtonTopArea,
                'ButtonBottomArea' => $ButtonBottomArea,
                'Textarea' => $TextareaStatus,
            ];

            $History = TicketHistory::with('user')->where('id_ticket', $id)->orderBy('created_at', 'asc')->get();

            foreach ($History as $historyItem) {
                $historyItem->formatted_created_at = Carbon::parse($historyItem->created_at)->format('M dS Y, H:i');
                // get right full name
                $fullname = $historyItem->user->fullname;
                $parts = explode(' ', $fullname);
                $historyItem->fullname = end($parts); // Lấy phần tên cuối cùng
            }


            $datas = [
                'TicketInfo' => $TicketInfo,
                'TicketDetail' => $TicketDetail,
                'Buttons' => $buttons,
                'Timeline' => $History,
            ];

            return response()->json($datas);
        } else {
            return response()->json(['message' => 'Ticket Not Found'], 400);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */

    public function updateDetail(Request $request, $id)
    {
        //        $Ticket_Dept = Ticket::find($id)->department_id;


        $request->validate([
            'content' => 'required|max:4000',
        ]);
        $content = $request->input('content');

        // Collection list of user IDs who created the ticket and handled the ticket
        $author_ticket = [];
        $ticket = Ticket::find($id);


        $TicketDetail = TicketDetail::create([
            'contentData' => $content,
            'ticket_id' => $ticket->id,
            'user_id' => auth()->user()->id,
        ]);

        $ticketNoti = [
            'title' => Auth::user()->fullname . " replied:",
            'text' => $request->input('content'),
            'id' => $ticket->id,
            'type' => "Ticket",
            'user_id_created' => Auth::user()->id,
            'user_receive' => $this->GetListUserNotification($ticket->id, 'reply_ticket_status_waiting'),
        ];


        if ($TicketDetail) {

            //if ticket status is 6 change to 7 else  5
            if (intval($ticket->status) === 6 && $ticket->created_by === Auth::id()) { //done
                $ticketNoti['title'] = "Ticket #$ticket->id has been Re-open";
                $ticketNoti['text'] = Auth::user()->fullname . " has re-opened ticket: " . Str::limit($ticket->title, 30, '...');
                $ticketNoti['user_receive'] = $this->GetListUserNotification($ticket->id, 're-open_ticket');
            }
            if (intval($ticket->status) === 5) { // Processing
                $ticketNoti['user_receive'] = $this->GetListUserNotification($ticket->id, 'reply_ticket_status_processing');
            }

            if ($request->hasFile('file-input')) {
                foreach ($request->file('file-input') as $file) {
                    $filename = $file->getClientOriginalName();
                    $fileSize = $file->getSize();
                    $fileExtension = $file->getClientOriginalExtension();
                    //random name + extension
                    $hashNameFile = md5($filename . time());
                    $path = $file->storeAs('uploads', $hashNameFile);
                    FilesUpload::create([
                        'id_user' => Auth::id(),
                        'filename' => $filename,
                        'path' => $path,
                        'slug' => $hashNameFile,
                        'size' => $fileSize,
                        'extension' => $fileExtension,
                        'detail_ticket_id' => $TicketDetail->id,
                    ]);
                }
            }


            // bỏ vào hàng đợi
            if (intval($ticket->status) === 6 && $ticket->created_by === Auth::id()) {
                $ticketNoti['user_receive'] = $this->GetListUserNotification($ticket->id, 're-open_ticket');
                $ticket->status = 7; //re-open
                $ticket->save();
                $subtaks = SubTaks::where('id_ticket', $ticket->id);
                $subtaks->update(['id_status' => 11]);
                WriteHistoryTicket::dispatch($ticket, 'Re-open ticket', 'Re-open ticket', Auth::user()->id);
            }

            ProcessTicketUpdate::dispatch($ticketNoti);
            return response()->json(['message' => 'The item #' . $id . ' has been updated successfully.'], 200);
        }
    }

    public function update(Request $request, $id)
    {

        $TicketDetail = new TicketDetail();
        $TicketDetail->contentData = $request->input('content');

        if ($request->hasFile('file-input')) {
            $file = $request->file('file-input');
            $path = $file->store('uploads'); // This will store the file in the 'uploads' directory.
            $TicketDetail->attachments = $path;
        }

        $TicketDetail->ticket_id = $id;
        $TicketDetail->user_id = auth()->user()->id;
        $TicketDetail->save();

        if ($TicketDetail) {
            return response()->json(['message' => 'The item #' . $id . ' has been updated successfully.'], 200);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    //    function RenameFile($file)
    //    {
    //        $originalFileName = $file->getClientOriginalName();
    //        $extension = $file->getClientOriginalExtension();
    //        $timestamp = time();
    //        $newFileName = pathinfo($originalFileName, PATHINFO_FILENAME) . '_' . $timestamp . '.' . $extension;
    //        $path = $file->storeAs('uploads', $newFileName);
    //        return $path;
    //    }

    public function forwardTicket(Request $request, $id)
    {
        $UserList = $request->input('UserList');
        $integerIDs = array_map('intval', $UserList);

        $list = implode(',', $UserList);
        $ticket = Ticket::find($id);

        $NameHandle = User::whereIn('id', $integerIDs)->pluck('fullname')->join(', ');

        $ticket_update = $ticket->update([
            'users_handle_id' => $list,
            'status' => 5
        ]);;

        $forwardName = Auth::user()->fullname;

        if ($ticket_update) {

            $ticketNoti = [
                'title' => "Ticket id#{$ticket->id} has been forwarded",
                'text' => "{$forwardName} has assigned {$NameHandle} to handle ticket #{$ticket->id}",
                'id' => $ticket->id,
                'type' => "Ticket",
                'user_id_created' => Auth::user()->id,
                'user_receive' => $this->GetUserNotification($ticket, 'forward'),
            ];


            WriteHistoryTicket::dispatch($ticket, 'Forward ticket', "Forward to $NameHandle", Auth::user()->id);
            ProcessTicketUpdate::dispatch($ticketNoti);

            return response('Done', 200);
        } else {
            return response('Fail', 400);
        }
    }

    public function finishTicket(Request $request, $id)
    {
        $request->validate([
            'numberStar' => ['numeric', 'max:5', 'min:0'],
            'commentStar' => ['max:500'],
        ]);

        $ticket = Ticket::find($id);
        $status_finish_id = TicketStatus::where('name', 'finish')->first()->id;
        if ($ticket->created_by === Auth::id()) {
            $ticket->status = $status_finish_id;
            $ticket->done_by = Auth::id();
            $ticket->finish_at = now();
            if ($ticket->save()) {
                $TicketRate = new TicketRate();
                $TicketRate->id_ticket = $ticket->id;
                $TicketRate->star = $request->numberStar;
                $TicketRate->staff_star = $request->numberStarOfStaff;
                $TicketRate->note = $request->commentStar;
                $TicketRate->save();


                // $ticketNoti = [
                //     'title' => "Ticket has been finished #$ticket->id",
                //     'text' => "Rating: " . $TicketRate->star . ", Staff: " . $TicketRate->staff_star,
                //     'id' => $ticket->id,
                //     'type' => "Ticket",
                //     'user_id_created' => Auth::user()->id,
                //     'user_receive' => $this->GetUserNotification($ticket, 'finish'),
                // ];

                WriteHistoryTicket::dispatch($ticket, 'Finish ticket', "Finish ticket: Rating: " . $TicketRate->star . "⭐, Staff: " . $TicketRate->staff_star . "⭐, Note: " . $TicketRate->note, Auth::user()->id);
                // ProcessTicketUpdate::dispatch($ticketNoti);


                return response()->json(['message' => 'Ticket has been completed'], 200);
            } else {
                return response()->json(['message' => 'An error occurred'], 400);
            }
        }
        return response()->json(['message' => 'Invalid request'], 400);
    }

    public function SlovedTicket($id, Request $request)
    {

        $request->validate(['subtasks' => 'required']);

        if (is_numeric($id)) {

            $subTasks = SubTaks::where('id_ticket', $id)->where('id_user', Auth::id())->where('id_status', 11)->first();

            if ($subTasks && auth()->user()->can('solved_ticket')) {

                switch ($request->subtasks) {
                    case 'done':
                        $subTasks->id_status = 12;
                        $subTasks->save();
                        break;
                    case 'holding':
                        $subTasks->id_status = 13;
                        $subTasks->save();
                        break;
                }


                $this->handleTicketStatusWithSubTasksStatus($id);

                $ticket = Ticket::find($id);

                $ticketNoti = [
                    'title' => "Ticket has been $request->subtasks #$id",
                    'text' => Auth::user()->fullname . " has solved: " . Str::limit($ticket->title, 30, '...'),
                    'id' => $ticket->id,
                    'type' => "Ticket",
                    'user_id_created' => Auth::user()->id,
                    'user_receive' => $this->GetUserNotification($ticket, 'solved'),
                ];

                WriteHistoryTicket::dispatch($ticket, "$request->subtasks ticket", "$request->subtasks ticket", Auth::user()->id);
                ProcessTicketUpdate::dispatch($ticketNoti);


                return response()->json(['message' => "Ticket has $request->subtasks", 'id' => $ticket->id], 200);
            } else {
                return response()->json(['message' => 'Tickets not found or you do not have permission'], 403);
            }
        } else {
            return response()->json(['message' => 'Yêu cầu không hợp lệ'], 400);
        }
    }

    public function ApprovalTicket($id)
    {
        if (is_numeric($id)) {
            $ticket = Ticket::find($id);
            if ($ticket && auth()->user()->can('accept ticket')) {
                $ticket->status = 5;
                $ticket->hasApprove()->update(['accept' => true]);
                $ticket->save();

                $ticketNoti = [
                    'title' => "Your request has been approved",
                    'text' => Auth::user()->fullname . " has approved: " . $ticket->title,
                    'id' => $id,
                    'type' => "Ticket",
                    'user_id_created' => Auth::user()->id,
                    'dept_id' => $ticket->department_id,
                ];
                $usersList = User::where('id_dept', $ticket->department_id)
                    ->where('id', '!=', Auth::user()->id)->get();
                foreach ($usersList as $user) {
                    $user->notify(new GreetingNotification($ticketNoti));
                }
                Broadcast(new CreateIssue($ticketNoti))->toOthers();


                return response()->json(['message' => 'Ticket has approval', 'id' => $ticket->id], 200);
            } else {
                return response()->json(['message' => 'Tickets not found or you do not have permission'], 403);
            }
        } else {
            return response()->json(['message' => 'Yêu cầu không hợp lệ'], 400);
        }
    }

    public function rejectTicket($id)
    {

        $reason = request()->input('reason');

        if (is_numeric($id)) {
            $ticket = Ticket::find($id);


            $text = "";
            if (Auth::user()->hasRole('ticket-sorter') === true) {
                $text = Auth::user()->fullname . " has reject the ticket: " . Str::limit($ticket->title, 30, '...') . " with reason: " . $reason;
            } else {
                $text = Auth::user()->fullname . " has canceled  the ticket: ";
            }

            //check user has permission to reject ticket or user is author ticket
            if ($ticket && auth()->user()->can('reject ticket') or $ticket->created_by === Auth::id()) {
                $ticket->status = 2;
                TicketReject::create([
                    'id_ticket' => $id,
                    'reason' => $reason,
                    'id_user' => Auth::id(),
                ]);
                $ticket->save();
                $ticketNoti = [
                    'title' => "Ticket #$id has been rejected",
                    'text' => $text,
                    'id' => $ticket->id,
                    'type' => "Ticket",
                    'user_id_created' => Auth::user()->id,
                    'user_receive' => $this->GetListUserNotification($ticket->id, 'holder_reject_ticket'),
                ];

                WriteHistoryTicket::dispatch($ticket, 'Reject ticket', $text, Auth::user()->id);
                ProcessTicketUpdate::dispatch($ticketNoti);

                return response()->json(['message' => 'Ticket đã được từ chối'], 200);
            } else {
                return response()->json(['message' => 'Ticket not Found or You not have Permission'], 403);
            }
        } else {
            return response()->json(['message' => 'Yêu cầu không hợp lệ'], 400);
        }
    }

    public function ListManager()
    {
        $ManagerList = User::where('')->get();
        return response()->json($ManagerList);
    }


    function ConvertArrayStaff($array)
    {
        $array = explode(',', $array);
        //Convert value $author_ticket to int
        $array = array_map('intval', $array);
        //remove id = author user Auth::user()->id in array
        return array_diff($array, [Auth::user()->id]);
    }


    function handleTicketStatusWithSubTasksStatus($idTicket)
    {
        $ticket = Ticket::find($idTicket);

        if ($ticket) {
            $countStatusSubTasksHolding = SubTaks::where('id_ticket', $idTicket)->where('id_status', 13)->count();
            $countStatusSubTasksRequestHolding = SubTaks::where('id_ticket', $idTicket)->where('id_status', 14)->count();
            $countStatusSubTasksProcessing = SubTaks::where('id_ticket', $idTicket)->where('id_status', 11)->count();

            if ($countStatusSubTasksHolding > 0) {
                $ticket->status = 8; // Holding
                $ticket->save();
            } else {
                if ($countStatusSubTasksProcessing === 0 && $countStatusSubTasksRequestHolding === 0) {
                    $ticket->status = 6; // Done
                    $ticket->save();

                    $ticketNoti = [
                        'title' => "Ticket id#{$ticket->id} is done",
                        'text' => "Ticket is done",
                        'id' => $ticket->id,
                        'type' => "Ticket",
                        'user_id_created' => Auth::user()->id,
                        'user_receive' => collect($ticket->created_by)
                    ];


                    WriteHistoryTicket::dispatch($ticket, 'Ticket done!', "Ticket is done", Auth::user()->id);
                    ProcessTicketUpdate::dispatch($ticketNoti);
                } else {

                    if ($ticket->status != 5) {
                        $ticket->status = 5;
                        $ticket->save();
                        $ticketSend = Ticket::with(['createdBy', 'hasType', 'subtasks.staff_handle'])->find($ticket->id);
                        SendMailForUserCreatedTicket::dispatch($ticketSend);
                    }

                }
            }
        } else {
            return response()->json(['message' => 'Ticket not found'], 400);
        }
    }

    function GetUserNotification($ticket, $type)
    {
        //fill all user has role IT, cttap
        $ManagerListChildren = User::whereHas('roles', function ($query) {
            $query->where('name', 'IT')->OrWhere('name', 'cttap');
        })->where('id_factory', $ticket->factories_id)->pluck('id_dept');

        $id_country = Factories::find($ticket->factories_id)->id_country;

        //remove distinct
        $ManagerListChildren = $ManagerListChildren->unique();
        //get all user has role MG for each dept
        $ManagerList = User::whereIn('id_dept', $ManagerListChildren)->where('type', 'MG')->pluck('id');

        //List user handle ticket array and value is intval
        $users_handle_id = $ticket->users_handle_id;
        //convert all value to int using array_map
        $users_handle_id = array_map('intval', explode(',', $users_handle_id));


        // find user has permission to forward ticket all
        $Forwarder = User::whereHas('permissions', function ($query) {
            $query->where('name', 'forward-all-factories');
        })->pluck('id');

        //Manager of user created ticket
        $ManagerUserCreatedTicket = User::where('id_dept', $ticket->department_id)->where('type', 'MG')->pluck('id');


        //find user has  view-notification-in-country
        $UserCanViewNotificationCountryId = User::whereHas('permissions', function ($query) {
            $query->where('name', 'view-notification-in-country');
        })->where('id_country', $id_country)->pluck('id');


        //User Created Ticket // int
        $user_created = $ticket->created_by;

        //merge all array
        $rs = $ManagerList->merge($Forwarder)->merge($ManagerUserCreatedTicket)->merge($users_handle_id)
            ->merge($UserCanViewNotificationCountryId)
            ->merge($user_created);
        //remove Auth::user()->id in array
        $rs = $rs->diff([Auth::user()->id])->unique();


        // don't add forwarder to list if $users_handle_id !=''
        if ($type === 'reply') {
            $rs = $rs->diff($Forwarder);
        }

        if ($type === 'reject') {
            $rs = $rs->diff($users_handle_id);
        }

        //for solved $rs only = user created
        if ($type === 'solved') {
            $rs = $rs->diff($Forwarder);
            $rs = $rs->diff($ManagerList);
            $rs = $rs->diff($ManagerUserCreatedTicket);
        }

        //for re-open only collect lt staff handle
        if ($type === 're-open') {
            $rs = $rs->diff($Forwarder);
            $rs = $rs->diff($ManagerList);
            $rs = $rs->diff($ManagerUserCreatedTicket);
        }

        // dd(count($users_handle_id));
        return $rs->toArray();
    }


    public function GetListUserNotification($ticket_id, $type)
    {


        $ticket = ticket::with(['factories', 'subtasks'])->find($ticket_id);

        $id_factory_ticket = $ticket->factories->id;
        $id_country_ticket = $ticket->factories->id_country;


        //Select all country
        $ForwarderAllContry = User::permission('forward-all-factories')->where('is_blocked', '!=', true)->pluck('id');

        //Select in country
        $ForwarderInContry = User::permission('forward-in-country')->where('id_country', $id_country_ticket)->where('is_blocked', '!=', true)->pluck('id');

        //Select 1 factory
        $ForwarderInFactory = User::permission('forward-in-factory')->where('id_factory', $id_factory_ticket)->where('is_blocked', '!=', true)->pluck('id');


        $ticketSorter = $ForwarderAllContry->merge($ForwarderInContry)->merge($ForwarderInFactory)->unique();
        $user_created = $ticket->created_by;

        //get list id user handle Ticket_Holer
        $Ticket_Holer = $ticket->subtasks->pluck('id_user')->unique();

        switch ($type) {
            case 'user_created_ticket':
                $ListIDGetNotification = $ticketSorter;
                break;
            case 'holder_reject_ticket':
                $ListIDGetNotification = $user_created;
                break;
            case 'holder_subtaks_ticket':
                $ListIDGetNotification = $Ticket_Holer->merge($user_created);
                break;
            case 'holding_subtaks_ticket':
                $ListIDGetNotification = $Ticket_Holer->merge($ticketSorter);
                break;
            case 'new_subtaks_ticket':
                $ListIDGetNotification = $Ticket_Holer->merge($user_created);
                break;
            case 'approve_holding_subtaks_ticket':
                $ListIDGetNotification = $Ticket_Holer->merge($user_created);
                break;
            case 'reject_holding_subtaks_ticket':
                $ListIDGetNotification = $Ticket_Holer;
                break;
            case 'canncel_holding_subtaks_ticket':

                break;
            case 'auto_done_ticket':
                $ListIDGetNotification = $user_created;
                break;
            case 're-open_ticket':
                $ListIDGetNotification = $Ticket_Holer;
                break;
            case 'finished_ticket':

                break;
            case 'reply_ticket_status_waiting':
                $ListIDGetNotification = $Ticket_Holer->merge($user_created);
                break;
            case 'reply_ticket_status_processing':
                $ListIDGetNotification = $ticketSorter->merge($user_created);
                break;

            default:
                # code...
                break;
        }
        $notificationsDiff = [];
        if (!($ListIDGetNotification instanceof Collection)) {
            $ListIDGetNotification = collect($ListIDGetNotification);
        }
        $notifications = $ListIDGetNotification->unique(); // Get unique notifications
        $userNotifications = Auth::user()->id; // Get authenticated user's ID
        $notificationsDiff = $notifications->diff($userNotifications); // Find the difference
        $notificationsDiff = $notificationsDiff->map(function ($item, $key) {
            return (int)$item;
        });
        return $notificationsDiff;
    }

    public function check_permisionViewTicket($id)
    {
        $listPermissions = Auth::user()->getAllPermissions()->pluck('name');
        $querySearch = " AND a.id =$id";
        $factorySearch = null;
        $userId = Auth::id();

        if (!$listPermissions->contains('forward-all-factories')) {
            if ($listPermissions->contains('forward-in-country')) {
                $factorySearch = " AND (f.id_country = " . Auth::user()->id_country . " OR d.id_country = " . Auth::user()->id_country . ")";
            } else {
                if ($listPermissions->contains('forward-in-factory')) {
                    $factorySearch = " AND (e.factories_id = " . Auth::user()->id_factory . " OR d.id_factory = " . Auth::user()->id_factory . ")";
                } else {
                    $factorySearch = " AND (e.id_factory = " . Auth::user()->id_factory . " OR d.id_factory = " . Auth::user()->id_factory . ")";
                    $querySearch .= " AND (a.created_by = $userId OR c.id_user = $userId)";
                }
            }
        }


        $totalQuery = "WITH CTE AS (
        SELECT
            a.*,
            g.updated_at AS timeUpdate,
            ROW_NUMBER() OVER (
                PARTITION BY a.id
                ORDER BY g.updated_at DESC
            ) AS row_num
             FROM TicketingSystem_tickets AS a WITH(NOLOCK)
             INNER JOIN TicketingSystem_users AS b WITH(NOLOCK) ON a.created_by = b.id
             LEFT JOIN TicketingSystem_SubTaks AS c WITH(NOLOCK) ON a.id = c.id_ticket
             LEFT JOIN TicketingSystem_users AS d WITH(NOLOCK) ON c.id_user = d.id
             INNER JOIN TicketingSystem_users as e WITH(NOLOCK) ON a.created_by = e.id
             INNER JOIN TicketingSystem_factories AS f WITH(NOLOCK) ON a.factories_id = f.id
             INNER JOIN TicketingSystem_ticket_details AS g WITH(NOLOCK) ON a.id = g.ticket_id
             INNER JOIN TicketingSystem_ticket_status as h WITH(NOLOCK) ON a.status = h.id
             INNER JOIN TicketingSystem_prolem_lists as i WITH(NOLOCK) ON a.type = i.id
             LEFT JOIN TicketingSystem_ticket_finish_detail as j WITH(NOLOCK) ON a.id = j.id_ticket
             INNER JOIN TicketingSystem_problems as k WITH(NOLOCK) on k.id = i.problem_id
        WHERE 1=1 $querySearch $factorySearch
    ),
    TOTAL AS (
        SELECT *
        FROM CTE
        WHERE row_num = 1
    )
    SELECT COUNT(*) AS totalCount FROM TOTAL";
        $totalResult = DB::selectOne($totalQuery);
        $total = intval($totalResult->totalCount);

        if ($total == 0) {
            return false;
        } else {
            return true;
        }

    }

}
