<?php

namespace App\Http\Controllers;

use App\Models\LanguageField;
use Illuminate\Http\Request;

class TranslateController extends Controller
{


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $country = LanguageField::select('locale')->distinct()->pluck('locale');
        $zone = LanguageField::select('zone')->distinct()->pluck('zone');
        $translations = LanguageField::all()->groupBy('locale');

        return view('admin.translate.index', [
            'translations' => $translations,
            'counties' => $country,
            'zone' => $zone
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    function update(Request $request, $id)
    {
        $keys = $request->input('key', []);
        $values = $request->input('value', []);
        $zones = $request->input('zone', []);

        // Duyệt qua từng phần tử trong các mảng và cập nhật từng bản ghi
        foreach ($keys as $index => $key) {
            // Lấy giá trị và zone tương ứng
            $value = $values[$index] ?? null;
            $zone = $zones[$index] ?? null;

            // Cập nhật dữ liệu vào cơ sở dữ liệu
            LanguageField::where('locale', $id)
                ->where('key', $key) // Đảm bảo cập nhật đúng key
                ->update(['value' => $value, 'zone' => $zone]);
        }

        return redirect()->back()->with('success', 'Cập nhật dữ liệu thành công');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


}
