<?php

namespace App\Http\Controllers;

use App\Models\Departments;
use App\Models\Ticket;
use App\Models\TicketDetail;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class UserController extends Controller
{
    public function __construct()
    {

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function activeAccount()
    {

        Auth::logout();


        return view('viewactive');
    }

    public function index($id)
    {
        return view('user.profile');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    public function searchUser(Request $request)
    {
        $users = User::where('fullname', 'like', '%' . $request->term . '%')->where('id', '!=', Auth::id())->take(10)->get();
        $formattedUsers = [];
        foreach ($users as $user) {
            $formattedUsers[] = [
                'id' => $user->id,

                'text' => $user->username . ': ' . $user->fullname,
            ];
        }
        return response()->json($formattedUsers);
    }

    public function select_staff_handle_ticket(Request $request)
    {

        $users = User::whereHas('roles', function ($query) {
            $query->whereIn('id', [12, 13, 1]);
        })->with('Departments')->get();

        $formattedUsers = [];
        foreach ($users as $user) {
            $departmentName = optional($user->departments)->name; // Tránh lỗi nếu $user->departments là null

            $formattedUsers[] = [
                'id' => $user->id,
                'text' => "[$departmentName] - {$user->username} - {$user->fullname}",

            ];
        }

        return response()->json($formattedUsers);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }


    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $user = User::with(['Countries', 'Sections', 'Positions', 'Departments', 'Factories'])->find($id);
        $ReplyCompiled = TicketDetail::where('user_id', $user->id)->count();
        $TicketsCreated = Ticket::where('created_by', $user->id)->count();
        return view('user.profile', compact('user', 'ReplyCompiled', 'TicketsCreated'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = User::with(['Departments', 'Positions', 'Countries', 'Factories', 'Sections'])->find($id);

        if ($user) {
            // Trả về thông tin người dùng dưới dạng JSON
            return response()->json([
                'success' => true,
                'data' => $user
            ]);
        } else {
            // Nếu không tìm thấy người dùng, trả về lỗi
            return response()->json([
                'success' => false,
                'message' => 'User not found'
            ], 404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */

    public function active($slug)
    {
        $user = User::where('active_code', $slug)->first();

        if ($user) {
            $user->first_time_login = 1;
            $user->active_code = null;
            $user->save();
            Auth::login($user);
            return redirect()->route('changepass')->with('success', 'Your account has been activated, Please change your password to continue!');
        } else {
            return redirect()->route('login')->withErrors('Link active has expired or wrong , Please try again');


        }
    }


    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function ManagerLists()
    {
        $users = User::with('Departments')->where('type', 'MG')->get();
        return response()->json($users);
    }
}
