<?php

namespace App\Http\Livewire;

use Livewire\Component;

class Toast extends Component
{
    public $message;
    public $type;

    public function render()
    {
        return view('livewire.toast');
    }

    public function showToast($message, $type = 'success')
    {
        $this->message = $message;
        $this->type = $type;

        // Hiển thị thông báo
        $this->dispatchBrowserEvent('toast', [
            'message' => $this->message,
            'type' => $this->type,
        ]);
    }
}
