<?php

namespace App\Imports;

use App\Models\User;

use App\Models\Departments;
use App\Models\Factories;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use App\Http\Controllers\HomeController;
use App\Models\Positions;
use App\Models\Sections;
use Spatie\Permission\Models\Role;

// Import HomeController
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Row;
use Spatie\Permission\Contracts\Role as ContractsRole;

class UsersImport implements ToCollection, WithMultipleSheets, WithHeadingRow, WithValidation
{
    private $messages = [];

    public function sheets(): array
    {
        return [
            0 => $this,
        ];
    }

    public function startRow(): int
    {
        return 3; // Data starts from the 4th row
    }




    public function collection(Collection $rows)
    {
        $rows = $rows->slice(1);

        //dd('Rows before transformation:', $rows->toArray());

        //convert  "employee_id" => to string
        $rows->transform(function ($item, $key) {
            return [
                'employeeid' => (string)$item['employeeid'],
                'password' => $item['password'],
                'type' => $item['type'],
                'factoryname' => $item['factoryname'],
                'departmentnameen' => $item['departmentnameen'],
                'fullname' => $item['fullname'],
                'email' => $item['email'],
                'positionnameen' => $item['positionnameen'],
                'sectionname' => $item['sectionname'],
                'rolename' => $item['rolename'],
            ];
        });

        $validator = Validator::make($rows->toArray(), [
            '*.employeeid' => 'required|unique:users,username',
            '*.password' => 'required',
            '*.factoryname' => 'required',
            '*.departmentnameen' => 'required',
            '*.fullname' => 'required',
            '*.email' => 'required',
            '*.positionnameen' => 'required',
            '*.sectionname' => 'required',
            '*.type' => [
                'required',
                function ($attribute, $value, $fail) {
                    $allowedTypes = ['ST', 'MG'];

                    if (!in_array($value, $allowedTypes)) {
                        $fail('The ' . $attribute . ' field is required only for "ST" or "MG" types.');
                    }
                },
            ],
        ]);


        if ($validator->fails()) {
            $this->messages = $validator->errors()->all();
            return;
        }

        $successCount = 0;

        foreach ($rows as $row) {
            $findIdFactory = Factories::where('name', $row['factoryname'])->first();
            if (!$findIdFactory) {
                $this->messages[] = "Factory not found: {$row['factoryname']}";
                continue; // Skip this row
            }
        
            $findIdDept = Departments::where('nameEn', $row['departmentnameen'])
                ->where('factory_id', $findIdFactory->id)
                ->first();
            if (!$findIdDept) {
                $this->messages[] = "Department not found: {$row['departmentnameen']} in Factory: {$row['factoryname']}";
                continue; // Skip this row
            }
        
            $findIdPosition = Positions::where('position_nameEn', $row['positionnameen'])
                ->where('id_factory', $findIdFactory->id)
                ->first();
            if (!$findIdPosition) {
                $this->messages[] = "Position not found: {$row['positionnameen']}";
                continue; // Skip this row
            }
        
            $findIdSection = Sections::where('name', $row['sectionname'])
                ->where('id_factory', $findIdFactory->id)
                ->first();
            if (!$findIdSection) {
                $this->messages[] = "Section not found: {$row['sectionname']}";
                continue; // Skip this row
            }

            $user = User::firstOrCreate(['username' => $row['employeeid']],[
                'fullname' => $row['fullname'],
                'email' => $row['email'],
                'password' => bcrypt($row['password']),
                'id_dept' => $findIdDept->id,
                'id_factory' => $findIdFactory->id,
                'id_position2' => $findIdPosition->id,
                'id_section' => $findIdSection->id,
                'type' => $row['type'],
            ]);



            if ($user) {
                $user = User::where('username', $user->username)->first();
                if ($user) { // Check if the user exists
                    $user->assignRole($row['rolename']);
                }
            }



            // Tìm hoặc tạo vai trò mới nếu nó chưa tồn tại
            //$role = Role::firstOrCreate(['name' => $row['rolename']]);
            //$role = Role::where('name', 'user')->first(); // Thay 'role_name' bằng tên của vai trò bạn muốn gán
            //$user->roles()->attach($role->id); // Gán vai trò có ID là $role->id cho người dùng







            // Gán vai trò cho người dùng
            //$user->assignRole($role);





            // if ($userCreate) {
            //     //$user = User::find($userCreate->id);
            //     //$user->assignRole('user'); // Assuming 'user' is a valid role in your system
            //     // You can perform additional actions here if needed, such as sending a welcome email
            //     dd($userCreate);
            // }


            //$role = Role::where('name','user')->first();
            //dd($role);
            //set role  10  or 5 if type is MG
            //$role = Role::find(10);
            //$user = User::find($user->id);
            //$user->assignRole('user');




            $successCount++;
        }

        //call function createImagesForAllUser hom HomeController
        //$homeController = new HomeController();
        //$homeController->createImagesForAllUser();

        $this->messages[] = 'File imported . ' . $successCount . ' users created.';
    }

    public function getMessages()
    {
        return $this->messages;
    }

    public function rules(): array
    {

        return [];
        // return [
        //     '*.EmployeeID' => 'required',

        // ];
    }
}
