<?php

namespace App\Jobs;

use App\Events\CreateIssue;
use App\Models\User;
use App\Notifications\GreetingNotification;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Broadcast;

class ProcessTicketUpdate implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $ticketNoti;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(array $ticketNoti)
    {
        $this->ticketNoti = $ticketNoti;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $ticketNoti = $this->ticketNoti;

        try {
            broadcast(new CreateIssue($ticketNoti));
//            Broadcast::queue(new CreateIssue($ticketNoti));
        } catch (\Exception $e) {

        }

        try {
            $users = User::whereIn('id', $ticketNoti['user_receive'])->get();
            $users->each(function ($user) use ($ticketNoti) {
                $user->notify(new GreetingNotification($ticketNoti));
            });
        } catch (\Exception $e) {

        }
    }
}
