<?php

namespace App\Jobs;

use App\Mail\SendMail;
use App\Mail\TicketCreated;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use App\Services\EmailConfigManager;
use App\Models\MailConfig;

class SendMailForUserCreatedTicket implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $ticketSend;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($ticketSend)
    {
        $this->ticketSend = $ticketSend;
    }

    /**
     * Execute the job.
     *
     * @return void
     */


    public function handle()
    {
        $mailConfigs = MailConfig::all();
        foreach ($mailConfigs as $config) {
            $config->mail_encryption = false;
            $emailConfigManager = new EmailConfigManager();
            $emailConfigManager->applyConfig($config->toArray());
            try {
                Mail::to($this->ticketSend->createdBy->email)
                    ->send(new TicketCreated($this->ticketSend));
                Log::channel('send_mail')->info("Mail sent successfully to {$this->ticketSend->createdBy->email} using config ID {$config->id}.");
                break;
            } catch (\Exception $e) {
                Log::channel('send_mail')->error("Mail sending failed with config ID {$config->id}: " . $e->getMessage());
            }
        }
        Log::channel('send_mail')->INFO("------------------------------------------------");
    }
}
