<?php

namespace App\Jobs;

use App\Mail\SendMail;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Services\EmailConfigManager;
use App\Models\MailConfig;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;


class SendMailVeryAccount implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $slug;
    protected $id;


    /**
     * @var \Psr\Log\LoggerInterface
     */

    /**
     * Create a new job instance.
     *
     * @param int $id
     * @return void
     */
    public function __construct($id)
    {
        $this->id = $id; // Sửa lỗi gán giá trị
        $this->slug = Str::random(256);
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $mailConfigs = MailConfig::all();
        $user = User::find($this->id);

        if (!$user) {
            Log::channel('send_mail')->error("User not found with ID: {$this->id}");
            Log::channel('send_mail')->INFO("------------------------------------------------");
            return;
        }

        $user->active_code = $this->slug;
        $user->save();

        foreach ($mailConfigs as $config) {
            $config->mail_encryption = false;
            $emailConfigManager = new EmailConfigManager();
            $emailConfigManager->applyConfig($config->toArray());
            try {
                Mail::to(trim($user->email))
                    ->send(new SendMail($this->slug));
                Log::channel('send_mail')->info("Mail sent successfully to {$user->email} using config ID {$config->id}.");
                break;
            } catch (\Exception $e) {
                Log::channel('send_mail')->error("Mail sending failed with config ID {$config->id}: " . $e->getMessage());
            }
        }
        Log::channel('send_mail')->INFO("------------------------------------------------");
    }

}

