<?php

namespace App\Jobs;

use App\Models\TicketHistory;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class WriteHistoryTicket implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $ticket, $content, $author, $type;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($ticket, $type, $content, $author)
    {
        $this->ticket = $ticket;
        $this->content = $content;
        $this->author = $author;
        $this->type = $type;
    }


    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {


        //check $this->content to color
        switch ($this->type) {
            case 'Solved ticket':
            case 'Create ticket':
            case 'Finish ticket':
                $color = 'success';
                break;
            case 'Forward ticket':
            case 'Re-open':
                $color = 'info';
                break;
            case 'Reject ticket':
                $color = 'danger';
                break;
            case 'Delete Task':
                $color = 'danger';
                break;
            default:
                $color = 'primary';
                break;
        }



        TicketHistory::create([
            'id_ticket' => $this->ticket->id,
            'id_user' => $this->author,
            'content' => $this->content,
            'color' => $color,
        ]);
    }
}
