<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use ZipArchive;

class SendMail extends Mailable
{
    use Queueable, SerializesModels;



    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($slug)
    {
        $this->slug = $slug;
        $this->password = substr(str_shuffle('!@#$%&*abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, 12);
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $slug = $this->slug;
        $attachmentFileName = $this->makeAttachment();

        //$password =  min 12 characters, at least one uppercase letter, one lowercase letter, one number and one special character
        //make a password
        $password = $this->password;


        return $this->subject('Ticket System')
            ->view('mail.view', compact(['slug', 'password']))
            ->attach(storage_path($attachmentFileName));
    }


    // Function make a mail with attachment
    protected function makeAttachment()
    {
        $zip = new ZipArchive;
        $fileName = 'ActiveLink.zip';

        if (file_exists(storage_path('ActiveAccount.txt'))) {
            unlink(storage_path('ActiveAccount.html'));
        }
        if (file_exists(storage_path('ActiveLink.zip'))) {
            unlink(storage_path('ActiveLink.zip'));
        }


        $url_active = route('user.active', $this->slug);
        $fileContent = $url_active;
        if ($zip->open(storage_path($fileName), ZipArchive::CREATE) === TRUE) {
            // Set password for file
            $zip->setPassword($this->password);


            $file = fopen(storage_path('ActiveAccount'), "w");
            fwrite($file, $fileContent);
            fclose($file);

            // Add files to the zip archive
            $zip->addFile(storage_path('ActiveAccount'), 'ActiveAccount.txt');
            $zip->setEncryptionName('ActiveAccount.txt', ZipArchive::EM_AES_256);

            // Close the zip archive
            $zip->close();

            // Return the file name
            return $fileName;
        } else {
            return false;
        }
    }
}
