<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class TicketCreated extends Mailable
{
    use Queueable, SerializesModels;

    public $ticket;

    /**
     * Tạo một thông báo email mới.
     *
     * @param  mixed  $ticket
     * @return void
     */
    public function __construct($ticket)
    {
        $this->ticket = $ticket;
    }

    /**
     * Xây dựng nội dung email.
     *
     * @return \Illuminate\Mail\Mailable
     */
    public function build()
    {
        return $this->view('mail.sorter_handle') // View email
            ->with([
                'ticket' => $this->ticket,
            ]);
    }
}
