<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SubTaks extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'SubTaks';

    protected $fillable = [
        'id_ticket',
        'id_status',
        'task_name',
        'reason',
        'solution',
        'request',
        'id_user',
        'created_by',
        'updated_by',
        'deleted_by',
        'deleted_at',
        'created_at',
        'updated_at',
    ];

    public function Status()
    {
        return $this->belongsTo(TicketStatus::class, 'id_status');
    }

    public function processingActions()
    {
        return $this->hasOne(TaskProcessing::class, 'id_subtaks', 'id');
    }

    public function user_assign()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }

    public function updated_by()
    {
        return $this->belongsTo(User::class, 'updated_by', 'id');
    }

    public function staff_handle()
    {
        return $this->belongsTo(User::class, 'id_user', 'id');
    }


}
