<?php

namespace App\Models;

use Clue\Redis\Protocol\Model\StatusReply;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * @method static find($id)
 */
class Ticket extends Model
{
    use HasFactory;

    protected $fillable  =[
        'users_handle_id',
        'type',
        'factory',
        'location',
        'status',
        'date_send',
        'title',
        'accept_id',
        'done_by',
        'rating',
        'assign_at',
        'finish_at',
        'attachment',
    ];
    protected $primaryKey = 'id';

    protected $casts = [
        'created_by' => 'integer',
        'id_dept' =>'integer',
        'id' =>'integer'

    ];

    public $incrementing = true;
    public function acceptedBy()
    {
        return $this->belongsTo(User::class, 'accept_by', 'id');
    }
    public function doneBy()
    {
        return $this->belongsTo(User::class, 'done_by', 'id');
    }
    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }
    public function ticketDetails()
    {
        return $this->hasMany(TicketDetail::class, 'ticket_id', 'id');
    }

    public function factories()
    {
        return $this->belongsTo(Factories::class, 'factories_id', 'id');
    }


    public function department()
    {
        return $this->belongsTo(Departments::class, 'department_id', 'id');
    }
    public function hasStatus()
    {
        return $this->belongsTo(TicketStatus::class, 'status', 'id');
    }
    public function hasType()
    {
        return $this->belongsTo(ProblemLists::class, 'type', 'id');
    }
    public function hasRate()
    {
        return $this->hasOne(TicketRate::class, 'id_ticket', 'id');

    }
    public function hasApprove()
    {
        return $this->hasOne(ManagerPending::class, 'id', 'accept_id');
    }

    public function subtasks()
    {
        return $this->hasMany(SubTaks::class, 'id_ticket', 'id');
    }





}
