<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TicketDetail extends Model
{
    use HasFactory;

    /**
     * @var mixed|null
     */


    protected $table = 'ticket_details';

    protected $dates = ['created_at', 'updated_at'];

    protected $fillable = [
        'contentData',
        'ticket_id',
        'user_id',

    ];

    public function UserCreate()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function Ticket()
    {
        return $this->belongsTo(Ticket::class, 'ticket_id', 'id');
    }

    public function Files()
    {
        //get alll file from model Files with columns detail_ticket_id = this id
        return $this->hasMany(FilesUpload::class, 'detail_ticket_id', 'id');

    }
}

