<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TicketHistory extends Model
{
    use HasFactory;

    protected $table = 'Ticket_History';

    protected $fillable = [
        'ticket_id',
        'id_user',
        'id_ticket',
        'content',
        'color'
    ];

    // function user
    public function user()
    {
        return $this->belongsTo(User::class, 'id_user', 'id');
    }
}
