<?php

namespace App\Models;

use App\Models\Departments;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;


class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'username',
        'fullname',
        'id_dept',
        'id_factory',
        'email',
        'password',
        'type',
        'first_time_login',
        'LastedUpdatePassword',
    ];
    protected $primaryKey = 'id';
    public $incrementing = true;
    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
        'confirm_email',
        'cellphone',
        'active_code',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'id_dept' => 'integer',
        'username' => 'string',
    ];

    public function Factories()
    {
        return $this->belongsTo(Factories::class, 'id_factory');
    }

    public function Countries()
    {
        return $this->belongsTo(Countries::class, 'id_country');
    }

    public function Sections()
    {
        return $this->belongsTo(Sections::class, 'id_section');
    }

    public function Positions()
    {
        return $this->belongsTo(Positions::class, 'id_position2');
    }


    public function Departments()
    {
        return $this->belongsTo(Departments::class, 'id_dept');
    }

    public function conversations()
    {
        return $this->belongsToMany(Conversations::class, 'participants', 'user_id', 'conversation_id');
    }

    public function getUsersHandleIds()
    {
        return explode(',', $this->users_handle_id);
    }

    public function staff_handles()
    {
        return User::whereIn('id', $this->getUsersHandleIds())->get();
    }

}
