<?php
namespace App\Services;

use Illuminate\Support\Facades\Config;

class EmailConfigManager
{
    protected $defaultConfig;

    /**
     * Lưu cấu hình mail mặc định
     */
    public function __construct()
    {
        $this->defaultConfig = Config::get('mail');
    }

    /**
     * Áp dụng cấu hình mail từ database
     *
     * @param array $config
     * @return void
     */
    public function applyConfig(array $config)
    {
        Config::set('mail.mailers.smtp.host', $config['mail_host']);
        Config::set('mail.mailers.smtp.port', $config['mail_port']);
        Config::set('mail.mailers.smtp.username', $config['mail_username']);
        Config::set('mail.mailers.smtp.password', $config['mail_password']);
        Config::set('mail.mailers.smtp.encryption', $config['mail_encryption']);
        Config::set('mail.from.address', $config['mail_from_address']);
        Config::set('mail.from.name', $config['mail_from_name']);
    }

    /**
     * Khôi phục cấu hình mail mặc định
     *
     * @return void
     */
    public function restoreDefaultConfig()
    {
        Config::set('mail', $this->defaultConfig);
    }
}


