<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTicketsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tickets', function (Blueprint $table) {
            $table->id();
            $table->string('type', 50);
            $table->unsignedBigInteger('factory_id');
            $table->unsignedBigInteger('location');
            $table->unsignedBigInteger('status');
            $table->date('date_send');
            $table->string('title', 255);
            $table->unsignedBigInteger('accept_by')->nullable();
            $table->unsignedBigInteger('done_by')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->float('rating')->nullable();
            $table->string('attachment')->nullable();
            $table->timestamps();

            // Define foreign key constraints
            $table->foreign('created_by')->references('id')->on('users'); // Assuming 'id' is the primary key of the 'users' table
            $table->foreign('accept_by')->references('id')->on('users'); // Assuming 'id' is the primary key of the 'users' table
            $table->foreign('done_by')->references('id')->on('users'); // Assuming 'id' is the primary key of the 'users' table

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tickets');
    }
}
