<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDepartmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('departments', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('nameVi');
            $table->string('nameEn');
            $table->unsignedBigInteger('factory_id');
            $table->timestamps();

            //set khoa ngoai
            $table->foreign('factory_id')->references('id')->on('factories');
        });

        Schema::table('users', function (Blueprint $table) {
            $table->unsignedBigInteger('id_dept');

            // Tạo khóa ngoại
            $table->foreign('id_dept')->references('id')->on('departments');
            $table->foreign('position_id')->references('id')->on('user_positions');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('departments');
    }
}
