<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateUsersTableColumns extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropUnique('ticketingsystem_users_email_unique');
            $table->string('email')->nullable()->change();
        });

        // Tạo ràng buộc users_name_unique cho cột name và chuyển nó thành NOT NULL
        Schema::table('users', function (Blueprint $table) {
            $table->unique('username', 'users_name_unique');
            $table->string('username')->nullable(false)->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Phục hồi lại các thay đổi khi rollback migration
        Schema::table('users', function (Blueprint $table) {
            // Xóa ràng buộc users_name_unique và chuyển cột name thành cho phép NULL
            $table->dropUnique('users_name_unique');
            $table->string('username')->nullable()->change();
            // Tạo lại ràng buộc users_email_unique cho cột email và chuyển nó thành NOT NULL
            $table->unique('email', 'ticketingsystem_users_email_unique');
            $table->string('email')->nullable(false)->change();
        });
    }
}
