<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RenameColumnInTicket extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('tickets', function (Blueprint $table) {
            $table->renameColumn('factory_id', 'factories_id');
            $table->renameColumn('location', 'department_id');

        });
        Schema::table('users', function (Blueprint $table) {
            $table->softDeletes();
        });
         Schema::table('permissions', function (Blueprint $table) {
            $table->string('description')->nullable();
            $table->string('guard_name')->default('web');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tickets', function (Blueprint $table) {
            $table->renameColumn('factories_id', 'factory_id');
            $table->renameColumn('department_id', 'location');
        });
        Schema::table('users', function (Blueprint $table) {
            $table->dropSoftDeletes();
        });
        Schema::table('permissions', function (Blueprint $table) {
            $table->dropColumn('description');
        });
    }
}
