<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTicketFinishDetailTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ticket_finish_detail', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('id_ticket')->unique();
            $table->float('star');
            $table->string('note')->nullable();
            $table->timestamps();

            $table->foreign('id_ticket')
                ->references('id')
                ->on('tickets')
                ->onDelete('cascade'); // Xóa các bản ghi liên quan khi bản ghi ở bảng ticket bị xóa.
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ticket_finish_detail');
    }
}
