<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateManagerPendingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('manager_pending', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('ticket_id')->unique();
            $table->bigInteger('manager_id');
            $table->bigInteger('user_created');
            $table->boolean('accept')->nullable();
            $table->timestamps();
            $table->foreign('ticket_id')->references('id')->on('tickets');
            $table->foreign('user_created')->references('id')->on('users');
            $table->foreign('manager_id')->references('id')->on('users');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('manager_pending');
    }
}
