<?php

namespace Database\Seeders;
use Illuminate\Database\Seeder;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permissionName = 'sent_ticket';
        // Kiểm tra xem quyền đã tồn tại hay chưa
        $existingPermission = \App\Models\Permission::where('name', $permissionName)->first();

        // Chỉ chèn quyền nếu nó chưa tồn tại
        if (!$existingPermission) {
            \App\Models\Permission::create(['name' => $permissionName]);
            $this->command->info('Permission "' . $permissionName . '" created.');
        } else {
            $this->command->info('Permission "' . $permissionName . '" already exists.');
        }
    }
}
