//Create button
$(document).on("click", 'button[name="btnCreateForm"]', function (event) {
    var modalControl = $("#ModalControl");
    var modalTicket = new bootstrap.Modal(
        document.getElementById("ModalControl")
    );
    $("#FormID").attr("data-type", "add");
    $('#FormID button[type="submit"]').text("Create");
    modalControl.find(".modal-title").text("Create new");
    $("#FormID input").val("");
    formCreate();
    modalTicket.show();
});
// Edit button
$(document).on("click", 'button[name="btnEdit"]', function (event) {
    var id = $(this).data("id");
    var modalControl = $("#ModalControl");
    var modalTicket = new bootstrap.Modal(
        document.getElementById("ModalControl")
    );
    $("#FormID").attr("data-type", "edit");
    $("#FormID").attr("data-id", id);
    $('#FormID button[type="submit"]').text("Save Edit");
    formUpdate();
    modalControl.find(".modal-title").text("Show");
    modalTicket.show();
    $.ajax({
        type: "GET",
        url: showRoute + "/" + id,
        success: function (response) {
            beforeEdit(response);
            for (const key in response) {
                if (response.hasOwnProperty(key)) {
                    var formField = $('#FormID [name="' + key + '"]');
                    if (formField.length) {
                        formField.val(response[key]);
                    }
                }
            }
            let permissions = response.permissions;
            let valuesToSelect = [];
            permissions.forEach(element => {
                valuesToSelect.push(element.id);
            });
            let select2 = $(".select2");
            select2.val(valuesToSelect).trigger("change");
        },
        error: function (jqXHR) {
            showErrors(jqXHR);
        },
    });
});
//function delete data Form
$(document).on("click", 'button[name="btnDel"]', function (event) {
    if (confirm("Are you sure you want to delete this")) {
        var id = $(this).data("id");
        $.ajax({
            type: "DELETE",
            url: destroyRoute + "/" + id,
            success: function (response) {
                toastr.success(response.message, {
                    timeOut: 5000,
                });
                $("#table_index").DataTable().ajax.reload(false);
            },
            error: function (jqXHR) {
                showErrors(jqXHR);
            },
        });
    }
});

function checkFormType() {
    var formType = $("#FormID").attr("data-type");
    return formType;
}
