refreshEmails = $('.email-refresh');
emailListJq = $('#TicketListsBox');
$instance = $('.onChange-event-ratings');
document.addEventListener('DOMContentLoaded', function () {
    let hoverTimeout;
    let userInfoBox;
    let loadedUserInfo = {};  // Lưu trữ thông tin người dùng đã tải

    document.body.addEventListener('mouseover', function (event) {
        // Kiểm tra nếu phần tử có alt="user-avatar"
        if (event.target.alt === 'user-avatar') {
            const userId = event.target.dataset.userId;

            // Kiểm tra xem thông tin người dùng đã được tải chưa
            if (!loadedUserInfo[userId]) {
                userInfoBox = document.createElement('div');
                userInfoBox.style.position = 'absolute';
                userInfoBox.style.background = '#fff';
                userInfoBox.style.border = '1px solid #ccc';
                userInfoBox.style.padding = '10px';
                userInfoBox.style.zIndex = '1000';
                userInfoBox.style.display = 'none';
                document.body.appendChild(userInfoBox);

                // Thiết lập thời gian chờ
                hoverTimeout = setTimeout(() => {
                    // Gọi API để lấy thông tin người dùng
                    fetch(`${baseUrl}/user/${userId}/edit`)
                        .then(response => response.json())
                        .then(data => {
                            // Lưu trữ thông tin người dùng vào object loadedUserInfo
                            loadedUserInfo[userId] = data.data;
                            data = data.data
                            userInfoBox.innerHTML = `
                    <strong>${data.fullname}</strong><br>
                    Departments: ${data.departments && data.departments.nameEn ? data.departments.nameEn : 'No department info'}<br>
                    Country: ${data.countries && data.countries.name ? data.countries.name : 'No country info'}<br>
                    Factory: ${data.factories && data.factories.name ? data.factories.name : 'No factory info'}<br>
                    Section: ${data.sections && data.sections.name ? data.sections.name : 'No section info'}<br>
                    Position: ${data.positions && data.positions.position_name ? data.positions.position_name : 'No position info'}<br>
                    Email: ${data.email || 'No email info'}<br>
                `;
                            userInfoBox.style.display = 'block';
                            userInfoBox.style.left = event.pageX + 'px';
                            userInfoBox.style.top = event.pageY + 'px';
                        })
                        .catch(() => {
                            userInfoBox.innerHTML = 'Failed to load user information.';
                            userInfoBox.style.display = 'block';
                            userInfoBox.style.left = event.pageX + 'px';
                            userInfoBox.style.top = event.pageY + 'px';
                        });
                }, 500);
            } else {
                // Nếu đã tải thông tin rồi, chỉ cần hiển thị lại
                userInfoBox = document.createElement('div');
                userInfoBox.style.position = 'absolute';
                userInfoBox.style.background = '#fff';
                userInfoBox.style.border = '1px solid #ccc';
                userInfoBox.style.padding = '10px';
                userInfoBox.style.zIndex = '1000';
                userInfoBox.style.display = 'none';
                document.body.appendChild(userInfoBox);

                const data = loadedUserInfo[userId];
                userInfoBox.innerHTML = `
                    <strong>${data.fullname}</strong><br>
                    Departments: ${data.departments && data.departments.nameEn ? data.departments.nameEn : 'No department info'}<br>
                    Country: ${data.countries && data.countries.name ? data.countries.name : 'No country info'}<br>
                    Factory: ${data.factories && data.factories.name ? data.factories.name : 'No factory info'}<br>
                    Section: ${data.sections && data.sections.name ? data.sections.name : 'No section info'}<br>
                    Position: ${data.positions && data.positions.position_name ? data.positions.position_name : 'No position info'}<br>
                    Email: ${data.email || 'No email info'}<br>
                `;
                userInfoBox.style.display = 'block';
                userInfoBox.style.left = event.pageX + 'px';
                userInfoBox.style.top = event.pageY + 'px';
            }
        }
    });

    document.body.addEventListener('mouseout', function (event) {
        // Kiểm tra nếu rời khỏi avatar
        if (event.target.alt === 'user-avatar') {
            clearTimeout(hoverTimeout); // Hủy thời gian chờ
            if (userInfoBox) {
                userInfoBox.remove(); // Xóa hộp thông tin
            }
        }
    });
});


var flatpickrRange = document.querySelector("#flatpickr-range");

flatpickrRange.flatpickr({
    mode: "range", dateFormat: "Y-m-d", // Định dạng ngày thành Y-M-D
    onChange: function (dates) {
        if (dates.length == 2) {
            search.ranges = dates.map(date => date.toLocaleDateString('en-GB'));
            LoadAllTicket(current_page);
        }
    }
});


let emailViewContent = $('.app-email-view-content');
let current_page = 1;
let current_view = 1;
var search = {
    status: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    type: [],
    title: null,
    department: null,
    fullname: null,
    factories: null,
    ranges: null,
    onlyMe: false
};


$('#check_box_all_label').click(function () {

    //Check all checkbox in id list_status
    if ($(this).is(':checked')) {
        $('#list_status input[type="checkbox"]').prop('checked', true)
        search.status = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]

    }
    if ($(this).is(':not(:checked)')) {
        $('#list_status input[type="checkbox"]').prop('checked', false)
        search.status = [];
    }

    LoadAllTicket(current_page);
})


function LoadDataFirst() {
    $('#problem').trigger('change');
    $('#factories').trigger('change');
    $('#departments').select2({
        dropdownParent: $('#emailComposeSidebar')
    });
}

$('#clear-search').click(function () {
    $('.email-search-input').val('');
    $('#searchFullName').val('');
    $('#searchDepartment').val('');
    $('#flatpickr-range').val('');
    $('select#search_factories').val('');
    search.fullname = null;
    search.title = null;
    search.department = null;
    search.ranges = null;
    LoadAllTicket(current_page);

})

$('select#search_factories').change(function () {
    search.factories = $(this).val();
    LoadAllTicket(current_page);
})


$('#searchFullName').keyup(function () {
    search.fullname = $(this).val();
    LoadAllTicket(current_page);
})
$('#searchDepartment').keyup(function () {
    search.department = $(this).val();
    LoadAllTicket(current_page);
})

let searchTimeout; // Khai báo biến timeout toàn cục
$('.email-search-input').keyup(function () {
    const searchValue = $('.email-search-input').val();
    clearTimeout(searchTimeout); // Xóa timeout trước đó nếu tồn tại

    searchTimeout = setTimeout(() => {
        search.title = searchValue;
        LoadAllTicket(current_page); // Gọi hàm sau 1s
    }, 1000); // Delay 1 giây
});

$('.email-filter-labels input[name="status"]').on('change', function () {
    search.status = [];
    $('.email-filter-labels input[name="status"]:checked').each(function () {
        search.status.push($(this).val());
    });
    //check this check or not
    var uncheckedCount = $('.email-filter-labels input[name="status"]:not(:checked)').length;

    if (uncheckedCount > 0) {
        $('#check_box_all_label').prop('checked', false)
    } else {
        $('#check_box_all_label').prop('checked', true)
    }


    LoadAllTicket(current_page);
});
$('.email-filter-labels input[name="RequestType"]').on('change', function () {
    search.type = [];
    $('.email-filter-labels input[name="RequestType"]:checked').each(function () {
        search.type.push($(this).val());
    });
    LoadAllTicket(current_page);
});


refreshEmails.click(function () {
    LoadAllTicket(current_page);
})

$(document).on('click', '.email-card-prev .card-body p img', function () {
    ImagesURL = $(this).attr('src');

    $('#PreviewImageModal .modal-content').html(`<img src="${ImagesURL}">`);
    $('#PreviewImageModal').modal('show');
});


$(document).on('click', '.email-prev:not(.text-muted), .email-next:not(.text-muted)', function () {
    $('.email-next').off('click');
    $('.email-prev').off('click');
    LoadAllTicket($(this).data('page'));
});

function renderPagination(currentPage, lastPage) {
    const pagination = $("#pagination");
    pagination.empty(); // Xóa nội dung cũ

    const maxVisible = 7; // Số trang hiển thị chính giữa
    const ellipsis = `<li class="page-item disabled"><span class="page-link">...</span></li>`;

    // Nút Previous
    if (currentPage > 1) {
        pagination.append(`
      <li class="page-item">
        <a class="page-link" href="#" data-page="${currentPage - 1}"><i class="fa-solid fa-chevron-left"></i></a>
      </li>
    `);
    } else {
        pagination.append(`
      <li class="page-item disabled">
        <a class="page-link" href="#"><i class="fa-solid fa-chevron-left"></i></a>
      </li>
    `);
    }

    // Hiển thị trang đầu tiên nếu cách xa cụm
    if (currentPage > maxVisible) {
        pagination.append(`
      <li class="page-item">
        <a class="page-link" href="#" data-page="1">1</a>
      </li>
    `);
        pagination.append(ellipsis);
    }

    // Hiển thị các trang trong cụm
    const start = Math.max(1, currentPage - Math.floor(maxVisible / 2));
    const end = Math.min(lastPage, start + maxVisible - 1);

    for (let i = start; i <= end; i++) {
        if (i === currentPage) {
            // Trang hiện tại (disabled và active)
            pagination.append(`
        <li class="page-item active disabled">
            <a class="page-link" href="#" tabindex="-1">${i}</a>
        </li>
        `);
        } else {
            // Các trang khác (có thể nhấn)
            pagination.append(`
        <li class="page-item">
            <a class="page-link" href="#" data-page="${i}">${i}</a>
        </li>
        `);
        }
    }


    // Hiển thị trang cuối cùng nếu cách xa cụm
    if (end < lastPage) {
        pagination.append(ellipsis);
        pagination.append(`
      <li class="page-item">
        <a class="page-link" href="#" data-page="${lastPage}">${lastPage}</a>
      </li>
    `);
    }

    // Nút Next
    if (currentPage < lastPage) {
        pagination.append(`
      <li class="page-item">
        <a class="page-link" href="#" data-page="${currentPage + 1}"><i class="fa-solid fa-chevron-right"></i></a>
      </li>
    `);
    } else {
        pagination.append(`
      <li class="page-item disabled">
        <a class="page-link" href="#"><i class="fa-solid fa-chevron-right"></i></a>
      </li>
    `);
    }

    // Xử lý sự kiện click trên các nút
    $(".page-link").off("click").on("click", function (e) {
        e.preventDefault();
        const page = $(this).data("page");
        if (page) {
            LoadAllTicket(page);
        }
    });
}

function LoadAllTicket(page = 1) {

    page < 1 ? page = 1 : page;

    $('#side_timeline').hide();
    $('#side_filler').show();

    $.ajax({
        type: "GET", url: "./ticket", data: {page: page, search: search}, success: function (response) {


            renderPagination(response.current_page, response.last_page);
            current_page = response.current_page
            var newURL = window.location.href.split('?')[0] + '?page=' + current_page;
            history.pushState(null, null, newURL);
            // $('.email-prev').data('page', current_page - 1);
            // $('.email-next').data('page', current_page + 1);
            // $('.text-page-info').text(`${response.from}-${response.to} of ${response.total}`)
            // $('.email-next').toggleClass('text-muted', response.last_page <= current_page);
            // $('.email-prev').toggleClass('text-muted', current_page === 1);
            let data = response.data;
            let dataArray = Object.keys(data);
            let numberOfItems = dataArray.length;


            let rating = null;
            $('#ticketbox').empty();

            if (numberOfItems > 0) {
                for (const key in data) {
                    if (data.hasOwnProperty(key)) {
                        const element = data[key];
                        let createLasted = moment(element.timeUpdate).calendar();

                        $('#ticketbox').append(`<li class="email-list-item " data-starred="true" data-bs-toggle="sidebar" data-ticket="${element.id}">
                                        <div class="d-flex align-items-center">
                                        <span>#${element.id}</span>

                                            <span class="badge bg-${element.problemDisplay} ms-2 me-3">${element.problemName}</span>
                                            <img src="${element.created_by_avatar}" alt="user-avatar" data-user-id="${element.created_by_id}"
                                            class="d-block flex-shrink-0 rounded-circle me-sm-3 me-2" height="32" width="32">
                                            <div class="email-list-item-content ms-2 ms-sm-0 me-2">
                                                <span class="h6 email-list-item-username me-2">${element.created_by_name}</span>
                                                <span class="email-list-item-subject d-xl-inline-block d-block">${element.title}</span>
                                            </div>
                                            <div class="email-list-item-meta ms-auto d-flex align-items-center">
                                                <span class="email-list-item-label badge d-none d-md-inline-block me-2" data-label="${(element.statusName)}">
                                                <span>${moment(element.date_send).format("DD/MM/YYYY")}</span>
                                                <span class="badge bg-${(element.statusDisplay)} ms-2 me-3">${(element.statusName)} ${element.starCount ?? ''}</span>
                                                </span>
                                                <ul class="list-inline email-list-item-actions text-nowrap">
                                                    <li class="list-inline-item ">${createLasted}</li>
                                                </ul>
                                            </div>
                                        </div>
                                        </li>`);
                    }
                }


            } else {
                $('#ticketbox').children().append(`
                              <ul class="list-unstyled m-0">
                                <li class="email-list-empty text-center" id="email-list-empty">No items found.</li>
                            </ul>`);
            }

            $('.app-emails-list').unblock();


        }, beforeSend: function () {
            $('.app-emails-list').block({
                message: '<div class="spinner-border text-primary" role="status"></div>', css: {
                    backgroundColor: "transparent", border: "0"
                }, overlayCSS: {
                    backgroundColor: "#000", opacity: 0.25
                }
            })
        }, error: function (jqXHR) {
            $('.app-emails-list').unblock();
        }

    });
}


$('#SendApproval').on('submit', function (e) {
    e.preventDefault();
    let Manager = $('#ListManager option:selected').val();
    console.log(current_view)
    $.ajax({
        type: "PUT",
        url: `./requestapprovalTicket/${current_view}`,
        data: {Manager: Manager},
        success: function (response) {
            $('#ModalToApproval').modal('hide')
            TicketShow(current_view);
            toastr.success('Successfully', 'Successfully sent to manager for approval')
        },
        error: function (jqXHR) {
            showErrors(jqXHR);
        }
    });
});

// onChange Event
$(document).on('click', '#Ticket-finish', function () {
    $(this).off('click');
    $('#ModalToFinish').modal('show');
    $('#commentStar').val('');
    let rating_staff = 0
    let rating_problem = 0
    $('.finish_staff_ratings').rateYo({
        rating: 1, fullStar: true,
    }).on('rateyo.change', function (e, data) {
        rating_staff = data.rating;
        if (rating_staff < 3 || rating_problem < 3) {
            $('#commentStar').prop('required', true)
        } else {
            $('#commentStar').prop('required', false)
        }
        $(this)
            .parent()
            .find('.counter')
            .text(data.rating);
    }).rateYo('rating', 0);

    $('.onChange-event-ratings').rateYo({
        rating: 1, fullStar: true,
    }).on('rateyo.change', function (e, data) {
        rating_problem = data.rating;
        if (rating_staff < 3 || rating_problem < 3) {
            $('#commentStar').prop('required', true)
        } else {

            $('#commentStar').prop('required', false)
        }

        $(this)
            .parent()
            .find('.counter')
            .text(rating_problem);
    }).rateYo('rating', 0);


    $('#ModalToFinish').find('.counter').text('');

});


$(document).on('click', 'button#done_subtask , button#holding_subtask', function (e) {
    e.preventDefault();
    let idHandle = $(this).val()
    let subtasks = $(this).data('status')
    let thisHandle = $(this);

    //block this button
    $(this).prop('disabled', true);


    // call to subtask ajax
    $.ajax({
        type: "GET", url: './checkSubTaskEmpty/' + idHandle, success: function (response) {

            if (response.reason === false || response.solution === null) {
                Swal.fire({
                    title: "Type reason or solution",
                    text: "You reason empty or solution empty",
                    icon: "warning",
                    target: "app-email-view"
                });

            } else {

                // case for done and process has #id = holding_subtask
                if (thisHandle.attr('id') === 'holding_subtask') {
                    // thisHandle.attr('disabled', true)
                    Swal.fire({
                        title: "Request",
                        input: "text",
                        inputAttributes: {
                            autocapitalize: "off"
                        },
                        showCancelButton: true,
                        confirmButtonText: "Request Holding",
                        showLoaderOnConfirm: true,
                        preConfirm: async (request_text) => {
                            try {
                                // call to ajax
                                await $.ajax({
                                    type: "PUT",
                                    url: `./updateholdingsustaks/${idHandle}`,
                                    data: {subtask_request: request_text, subtasks: subtasks},
                                });

                                $('#staff_processing_info').DataTable().ajax.reload();
                                TicketShow(current_view)
                            } catch (error) {
                                Swal.showValidationMessage(`Request failed: ${error}`);
                            }
                        },
                        allowOutsideClick: () => !Swal.isLoading()
                    }).then((result) => {
                        if (result.isConfirmed) {


                            // show toast success
                            Swal.fire({
                                icon: 'success',
                                title: 'Nice work!',
                                text: 'Ticket has been sent to Ticket Storer',
                                customClass: {
                                    confirmButton: 'btn btn-success'
                                }
                            });

                        }
                    });

                } else {
                    $.ajax({
                        type: "PUT",
                        url: './done_subtask/' + idHandle,
                        data: {subtasks: subtasks},
                        success: function (response) {

                            Swal.fire({
                                icon: 'success', title: 'Nice work!', text: 'Ticket has been solved', customClass: {
                                    confirmButton: 'btn btn-success'
                                }
                            });
                            thisHandle.unblock()
                            thisHandle.attr('disabled', false)
                            $('#staff_processing_info').DataTable().ajax.reload();

                        },
                        error: function (jqXHR) {
                            toastr.error(jqXHR.responseJSON.message, 'error', {
                                timeOut: 2000,
                            });
                            thisHandle.unblock()
                            thisHandle.attr('disabled', false)
                        }
                    });
                }


            }

            thisHandle.unblock()
            thisHandle.attr('disabled', false)
        }, error: function (jqXHR) {
            thisHandle.unblock()
            thisHandle.attr('disabled', false)
        },


    });

    //block this button
    $(this).prop('disabled', false);
    TicketShow(current_view);

});


$(document).on('click', '#Ticket-Approval', function () {
    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, Approval it!',
        customClass: {
            confirmButton: 'btn btn-primary me-1', cancelButton: 'btn btn-label-secondary'
        },
        buttonsStyling: false
    }).then(function (result) {
        if (result.value) {
            $.ajax({
                type: "PUT", url: './ApprovalTicket/' + current_view, success: function (response) {
                    TicketShow(response.id);
                    Swal.fire({
                        icon: 'success', title: 'Approval!', text: 'Ticket has been Approval', customClass: {
                            confirmButton: 'btn btn-success'
                        }
                    });
                }, error: function (jqXHR) {
                    toastr.error(jqXHR.responseJSON.message, 'error', {
                        timeOut: 2000,
                    });

                }
            });


        }
    });
})
$('#emailComposeSidebar').on('shown.bs.modal', function (e) {
    // call can TicketController checkLimitCreateTicket with ajax, if return true , block button sent
    $.ajax({
        type: "GET", url: './checkLimitCreateTicket', success: function (res) {
            var result = res;


            if (result.status === false) {
                //jqeury block form #CreateTicketForm
                $('#emailComposeSidebar .modal-body').block({
                    message: `<div class="alert alert-danger" role="alert">
                          You have created more than 5 tickets within 15 minutes, please wait ${result.wait} minutes to unlock this function
                        </div>`, css: {
                        backgroundColor: "transparent", border: "0", cursor: "no-drop"
                    }, overlayCSS: {
                        backgroundColor: "#000", opacity: 0.25, cursor: "no-drop"
                    }
                })
            } else {
                $('#emailComposeSidebar .modal-body').unblock();
            }
        }, error: function (error) {
            $('#emailComposeSidebar .modal-body').unblock();
        }
    });
});

// $('#emailComposeSidebar').on('shown.bs.modal', function (e) {
//     // $('#bottom_button_area').removeClass('d-none')
//     // $('#bottom_button_area').after().empty()
// })


$('#FinishTicket').on('submit', function (e) {
    e.preventDefault();
    id = current_view;
    let numberStar = $('.onChange-event-ratings').rateYo(("rating"));
    let numberStarOfStaff = $('.finish_staff_ratings').rateYo(("rating"));
    let commentStar = $('#commentStar').val();
    var data = {
        id: id, numberStar: numberStar, commentStar: commentStar, numberStarOfStaff: numberStarOfStaff
    };

    if (numberStar === 0 || numberStarOfStaff === 0) {
        Swal.fire({
            icon: 'error',
            title: 'Oops...',
            text: 'You need to enter star number and employee star!',
            showCancelButton: false, // Ẩn nút hủy bỏ
            showConfirmButton: true, // Hiển thị nút xác nhận
            confirmButtonText: 'OK', // Đặt văn bản cho nút xác nhận
            allowOutsideClick: false // Không cho phép đóng cửa sổ bằng cách click bên ngoài
        }).then((result) => {
            if (result.isConfirmed) {
                // Code xử lý khi người dùng nhấn OK
                Swal.close(); // Đóng cửa sổ thông báo
            }
        });
        return false;
    }

    $('#btn-submit-finish').block({
        message: '<div class="spinner-border text-primary" role="status"></div>', css: {
            backgroundColor: "transparent", border: "0"
        }, overlayCSS: {
            backgroundColor: "#000", opacity: 0.25
        }
    })


    $('#btn-submit-finish').prop('disabled', true)

    $.ajax({
        url: './finishTicket/' + id,
        type: 'PUT',
        data: JSON.stringify(data),
        contentType: 'application/json',
        success: function (response) {
            $('#ModalToFinish').modal('hide')
            TicketShow(id);
            $('#btn-submit-finish').unblock()
            $('#btn-submit-finish').prop('disabled', false)


        },
        error: function (jqXHR) {
            showErrors(jqXHR);
            $('#btn-submit-finish').unblock()
            $('#btn-submit-finish').prop('disabled', false)
        }
    });
});


// ALERT WITH Reject BUTTON
$(document).on("click", "#Ticket-Reject", function () {
    let rejectid = $(this).val();
    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, reject it!',
        customClass: {
            confirmButton: 'btn btn-primary me-1 btn-reject', cancelButton: 'btn btn-label-secondary'
        },
        buttonsStyling: false,
        allowOutsideClick: false, // Disable clicking outside the modal
        allowEscapeKey: false, // Disable pressing escape key
        showLoaderOnConfirm: true, // Show loading spinner
        preConfirm: () => {
            return new Promise((resolve) => {
                let reason = $('#rejectReason').val();
                if (reason.trim() === '') {
                    Swal.showValidationMessage('Pls type')
                    resolve();
                } else {

                    $.ajax({
                        type: "PUT",
                        url: './rejectTicket/' + rejectid,
                        data: {reason: reason},
                        success: function (response) {
                            resolve();
                        },
                        error: function (jqXHR) {
                            toastr.error(jqXHR.responseJSON.message, 'error', {
                                timeOut: 2000,
                            });
                        },
                        complete: function () {
                            TicketShow(rejectid);
                        }
                    });
                }

            });
        },
        html: ' <label for="html">Please type reason (required)*:</label><br><input id="rejectReason" class="swal2-input" placeholder="Enter reason for rejection" required>',
        didOpen: function () {
            $(".swal2-confirm").attr('disabled', true);
            $('#rejectReason').on('keyup', function () {
                if ($(this).val().trim() !== '') {
                    $(".swal2-confirm").attr('disabled', false);
                } else {
                    $(".swal2-confirm").attr('disabled', true);
                }
            })

        }
    })
        .then(function (result) {
            if (result.value) {
                Swal.fire({
                    icon: 'success', title: 'Rejected!', text: 'Ticket has been rejected', customClass: {
                        confirmButton: 'btn btn-success'
                    }
                });
            }
        });
});

function addSubTasks() {
    $('#modal_subtaksInfor').modal({
        backdrop: 'static', keyboard: false
    });

    $('form#form_subtasks').unblock();

    $('#subtask_title').val('').removeAttr('disabled');
    $('#subtask_reason').val('');
    $('#subtask_solution').val('');
    $('#subtask_request').val('');
    $('#subtask_id').val('');
    $(".js-example-basic-single").val(null).trigger('change').removeAttr('disabled');
    $('#form_subtasks').data('action', 'create')
    $('#subtask-create').show()
    $('#modal_subtaksInfor').modal('show');

}


$('#modal_subtaksInfor').on('hidden.bs.modal', function (e) {
    $('#subtask-create').hide()
    $('#subtask-save').hide()
    $('#subtask-approved').hide()
    $('#subtask-reject').hide()
})

$('#form_subtasks').on('submit', function (e) {
    id_button_submit = e.originalEvent.submitter.id
    e.preventDefault();
    let subtask_title = $('#subtask_title').val()
    let subtask_reason = $('#subtask_reason').val();
    let subtask_solution = $('#subtask_solution').val();
    let subtask_staff = $('#subtask_staff').val()
    let subtask_id = $('#subtask_id').val();
    let data = {
        subtask_title: subtask_title,
        subtask_reason: subtask_reason,
        subtask_solution: subtask_solution,
        subtask_staff: subtask_staff,
        id_ticket: current_view,
    }

    switch (id_button_submit) {
        case 'subtask-create':
            createUpdateSubTasks(data, './subtasks', 'POST');
            break;
        case 'subtask-save':
            createUpdateSubTasks(data, `./subtasks/${subtask_id}`, 'PUT');
            break;


    }


})


function createUpdateSubTasks(data, url, method,) {


    $('button#subtask-create').prop('disabled', true);
    $('button#subtask-save').prop('disabled', true);

    $('form#form_subtasks').block({
        message: '<div class="spinner-border text-primary" role="status"></div>', css: {
            backgroundColor: "transparent", border: "0"
        }, overlayCSS: {
            backgroundColor: "#000", opacity: 0.25
        }
    })

    //call to ajax
    $.ajax({
        type: method, url: url, data: data, success: function (response) {

            $('#ticket_breakdown_table').DataTable().ajax.reload();
            $('#modal_subtaksInfor').modal('hide');


            $('form#form_subtasks').block({
                message: '<div class="spinner-border text-primary" role="status"></div>', css: {
                    backgroundColor: "transparent", border: "0"
                }, overlayCSS: {
                    backgroundColor: "#000", opacity: 0.25
                }
            })

            $('button#subtask-create').prop('disabled', false);
            $('button#subtask-save').prop('disabled', false);


            TicketShow(current_view);
        }, error: function (jqXHR) {

            $('form#form_subtasks').unblock();
            $('button#subtask-create').prop('disabled', false);
            $('button#subtask-save').prop('disabled', false);
            toastr.error(jqXHR.responseJSON.message, 'error', {
                timeOut: 2000,
            });
        },
    })
}


// $('#btn-add-breakdown').click(function () {
//     addSubTasks();
// })

function deleteSubTask(id) {

    // show toast check are you sure of modal #ModalToForwardTicket
    Swal.fire({
        target: document.getElementById('ModalToForwardTicket'),
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!',
        customClass: {
            confirmButton: 'btn btn-primary me-1', cancelButton: 'btn btn-label-secondary'
        },
        buttonsStyling: false
    }).then(function (result) {
        if (result.value) {
            $.ajax({
                type: "DELETE", url: `./subtasks/${id}`, success: function (response) {
                    $('#ticket_breakdown_table').DataTable().ajax.reload();
                    TicketShow(current_view);
                    Swal.fire({
                        target: document.getElementById('ModalToForwardTicket'),
                        icon: 'success',
                        title: 'Deleted!',
                        text: 'Subtask has been deleted',
                        customClass: {
                            confirmButton: 'btn btn-success'
                        }
                    });
                }, error: function (jqXHR) {
                    toastr.error(jqXHR.responseJSON.message, 'error', {
                        timeOut: 2000,
                    });
                }
            });
        }
    });
}


$(document).on('click', 'button#subtask-approved', function () {
    let buttonID = $(this).val();

    $('form#form_subtasks').block({
        message: '<div class="spinner-border text-primary" role="status"></div>', css: {
            backgroundColor: "transparent", border: "0"
        }, overlayCSS: {
            backgroundColor: "#000", opacity: 0.25
        }
    })

    $('button#subtask-approved').prop('disabled', true);
    $('button#subtask-reject').prop('disabled', true);
    $('button#subtask-save').prop('disabled', true);

    $.ajax({
        type: "PUT", url: `./subtasksapproveds/${buttonID}`, success: function (response) {

            $('button#subtask-approved').prop('disabled', false);
            $('button#subtask-reject').prop('disabled', false);
            $('button#subtask-save').prop('disabled', false);
            $('form#form_subtasks').unblock();

            toastr.success('Successfully', 'Approved subtask success');
            $('#modal_subtaksInfor').modal('hide');
            $('#ticket_breakdown_table').DataTable().ajax.reload();
            $('#DetailReload').trigger('click');


        }, error: function (xhr, status, error) {
            // Enable the button in case of error
            $('button#subtask-approved').prop('disabled', false);
            $('button#subtask-reject').prop('disabled', false);
            $('button#subtask-save').prop('disabled', false);
            $('form#form_subtasks').unblock();
            // Handle the error, you can log it or show an error message to the user
            toastr.error('Error occurred while approving subtask', 'Error');
        }
    })
})

$(document).on('click', 'button#subtask-reject', function () {
    let buttonID = $(this).val();
    $('form#form_subtasks').block({
        message: '<div class="spinner-border text-primary" role="status"></div>', css: {
            backgroundColor: "transparent", border: "0"
        }, overlayCSS: {
            backgroundColor: "#000", opacity: 0.25
        }
    })

    $('button#subtask-approved').prop('disabled', true);
    $('button#subtask-reject').prop('disabled', true);
    $('button#subtask-save').prop('disabled', true);


    $.ajax({
        type: "PUT", url: `./reject_subtask/${buttonID}`, success: function (response) {
            $('button#subtask-approved').prop('disabled', false);
            $('button#subtask-reject').prop('disabled', false);
            $('button#subtask-save').prop('disabled', false);
            $('form#form_subtasks').unblock();

            toastr.success('Successfully', 'reject subtask success');
            $('#modal_subtaksInfor').modal('hide');
            $('#ticket_breakdown_table').DataTable().ajax.reload();
            $('#DetailReload').trigger('click');
        }, error: function (xhr, status, error) {
            // Enable the button in case of error
            $('form#form_subtasks').unblock();
            $('button#subtask-approved').prop('disabled', false);
            $('button#subtask-reject').prop('disabled', false);
            $('button#subtask-save').prop('disabled', false);

            // Handle the error, you can log it or show an error message to the user
            toastr.error('Error occurred while approving subtask', 'Error');
        }
    })
})


$(document).on('click', 'button#cancel_holding_subtask', function () {
    $(this).attr('disabled', true)
    let buttonID = $(this).val();
    //sent ajax to './subtasks/{id}/update'
    $.ajax({
        type: "PUT", url: `./cancel_request_subtask/${buttonID}`, success: function (response) {
            $(this).attr('disabled', false)
            toastr.success('Successfully', 'Canncel request subtask success');
            $('#modal_subtaksInfor').modal('hide');
            TicketShow(current_view)
            $('#staff_processing_info').DataTable().ajax.reload();


        }, error: function (xhr, status, error) {
            // Enable the button in case of error
            $(this).attr('disabled', false);
            // Handle the error, you can log it or show an error message to the user
            toastr.error('Error occurred while approving subtask', 'Error');
        }
    })
})


function editSubTasks(id) {

    $('form#form_subtasks').unblock();

    //call api add to form #staff-process
    $.ajax({
        type: "GET", url: `./subtasks/${id}/edit`, success: function (response) {
            $('#subtask_title').val(response.task_name)
            $('#subtask_reason').val(response.reason).removeAttr('disabled');
            $('#subtask_solution').val(response.solution).removeAttr('disabled');
            $('#subtask_request').val(response.request);
            $('#subtask_id').val(response.id);


            if (roles.includes('manager')) {
                $(".js-example-basic-single").removeAttr('disabled');
            }

            $('#subtask_status').html(`<div class="d-flex align-items-center lh-1 me-3 mb-3 mb-sm-0" bis_skin_checked="1">
          <span class="badge badge-dot bg-${response.status.display} me-1"></span> ${response.status.name}
        </div>`);
            //if null empty select
            if (response.processing_actions === null) {
                $(".js-example-basic-single").val(null).trigger('change').attr('disabled', true);
            } else {
                $(".js-example-basic-single").val(response.staff_handle.id).trigger('change')
            }


            if (response.status.id === 14) {
                $('button#subtask-approved').show()
                $('button#subtask-reject').prop('disabled', false).show()
                $('#subtask-approved').val(response.id)
                $('#subtask-reject').val(response.id)
            }

        }, //loaded
        complete: function () {
            $('#modal_subtaksInfor').modal({
                backdrop: 'static', keyboard: false
            });
            $('#subtask-save').show()
            $('#modal_subtaksInfor').modal('show');
            //unblock
            $('#ModalToForwardTicket').unblock();
        }, //wait load show snipper
        beforeSend: function () {
            $('#ModalToForwardTicket').block({
                message: '<div class="spinner-border text-primary" role="status"></div>', css: {
                    backgroundColor: "transparent", border: "0"
                }, overlayCSS: {
                    backgroundColor: "#000", opacity: 0.25
                }
            })
        }, //error
        error: function (jqXHR) {
            $('#ModalToForwardTicket').unblock();
            toastr.error(jqXHR.responseJSON.message, 'error', {
                timeOut: 2000,
            });
        }
    });


}


$('#showOnlyMe').change(function () {
    if ($(this).is(':checked')) {
        search.onlyMe = true
    } else {
        search.onlyMe = false
    }

    LoadAllTicket(current_page);
})
$(document).on("click", "#Ticket-Forward", function () {
    let ticket_id = $(this).val();

    $('#ticket_breakdown_table').DataTable({
        processing: true, destroy: true, paging: false, fixedColumns: {
            start: 1
        }, dom: 'Bfrtip', buttons: [{
            text: 'Add Sub-task', className: 'btn-success', action: function (e, dt, node, config) {
                // Điều hướng hoặc hiển thị modal để tạo mới bản ghi
                addSubTasks();
            }
        }], ajax: {
            type: "GET", url: `./subtasks/${ticket_id}`,

        }, columns: [{
            data: null, title: 'Actions', render: function (data, type, row) {

                if (data.id_status !== '12') {
                    // Tạo nút Delete nếu điều kiện thỏa mãn
                    let buttonDelete = '';


                    //Role admin dc xoa
                    if (roles == 'admin') {
                        buttonDelete = `<a class="dropdown-item btn btn-danger" href="javascript:void(0);" onclick="deleteSubTask(${data.id})">
                        <i class="fa-solid fa-trash"></i> Delete
                    </a>`;
                    }

                    // Chi nguoi create moi dc xoa
                    if (auth.id === parseInt(data.created_by)) {
                        buttonDelete = `<a class="dropdown-item btn btn-danger" href="javascript:void(0);" onclick="deleteSubTask(${data.id})">
                                            <i class="fa-solid fa-trash"></i> Delete
                                        </a>`;
                    }

                    // Trả về HTML
                    return `
                        <div class="btn-group" role="group">
                            <button style="border: unset" id="btnGroupDrop1" type="button" class="btn btn-outline-secondary waves-effect" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa-solid fa-ellipsis"></i>
                            </button>
                            <div class="dropdown-menu" aria-labelledby="btnGroupDrop1">
                                <a class="dropdown-item btn btn-success" href="javascript:void(0);" onclick="editSubTasks(${data.id})">
                                    <i class="fa-solid fa-pen-to-square"></i> Edit
                                </a>
                                ${buttonDelete}
                            </div>
                        </div>`;
                } else {
                    return '';
                }


            }
        }, {
            data: 'id', title: '#',
        }, {
            data: 'task_name', title: 'Task name', render: function (data) {
                return `<strong class="text-nowrap text-info">${data}</strong>`
            }
        }, {
            data: 'status', title: 'Status', render: function (data) {
                return `<strong class="text-nowrap text-${data.display}">${data.name}</strong>`
            }
        }, {
            data: 'staff_handle', title: 'Staff handle', render: function (data) {
                if (data !== null) {
                    return `<tag
title="${data.email}"
contenteditable="false"
spellcheck="false"
tabindex="-1"
class="tagify__tag tagify--noAnim"
name="${data.fullname}"
avatar="${data.avatar_url}"
email="${data.email}">
<div><div class="tagify__tag__avatar-wrap">
<img onerror="this.style.visibility='hidden'"
src="${data.avatar_url}"></div><span class="tagify__tag-text">${data.fullname}</span></div></tag>`

                } else {
                    return `<strong class="text-nowrap">Empty</strong>`
                }

            }
        }, {
            data: 'user_assign', title: 'Created by', render: function (data) {
                if (data !== null) {
                    return `<tag
title="${data.email}"
contenteditable="false"
spellcheck="false"
tabindex="-1"
class="tagify__tag tagify--noAnim"
name="${data.fullname}"
avatar="${data.avatar_url}"
email="${data.email}">
<div><div class="tagify__tag__avatar-wrap">
<img onerror="this.style.visibility='hidden'"
src="${data.avatar_url}"></div><span class="tagify__tag-text text-nowrap">${data.fullname}</span></div></tag>`

                } else {
                    return `<strong class="text-nowrap">Empty</strong>`
                }

            }
        }, {
            data: 'created_at', title: 'created_at', render: function (data) {
                return moment(data).format('YYYY-MM-DD HH:mm:ss')
            }
        },

            {
                data: 'updated_at', title: 'updated_at', render: function (data) {
                    return moment(data).format('YYYY-MM-DD HH:mm:ss')
                }
            },

        ]
    });


    // edit sub tasks


    //call tol show_subTask_byTicket/{ticket_id}


    // $.ajax({
    //     type: "GET", url: "select_staff_handle_ticket", dataType: "json", success: function (response) {
    //
    //         $('#select_staff_handle_ticket').select2({
    //             minimumInputLength: 0, data: response
    //         });
    //     }, error: function (jqXHR) {
    //
    //         toastr.error(jqXHR.responseJSON.message, 'error', {
    //             timeOut: 2000,
    //         });
    //     }
    // });
    $('#ModalToForwardTicket').modal('show');
});

$(document).on('keyup', '#edit_solution, #edit_reason', function () {
    let thisText = $(this).val();
    if (thisText == '') {
        $(this).closest('div').find('button').hide();
    } else {
        $(this).closest('div').find('button').show();
    }

});


//Handle for all button of forward function
$(document).on('click', '#btn_edit_reason,#btn_edit_solution', function () {
    let thisId = $(this).data('subtask-id');
    //call update laravel api /subtasks ajax
    $.ajax({
        type: "PUT",
        url: `./subtasks/${thisId}`,
        data: {subtask_reason: $('#edit_reason').val(), subtask_solution: $('#edit_solution').val()},
        success: function (response) {
            //Toast success
            toastr.success('Successfully', 'Update subtask success');
            $('#staff_processing_info').DataTable().ajax.reload()
        },
        error: function (jqXHR) {
            //Toast error
            toastr.error(jqXHR.responseJSON.message, 'error', {
                timeOut: 2000,
            });
        }
    });
})


function addBreaktask(json) {
    $('#ticket_breakdown').empty()

    json.forEach(element => {
        $('#ticket_breakdown').append(`<div class="d-flex align-items-center my-2 gap-2">
                                        <div class="d-flex justify-center justify-items-center">
                                           <strong class="text-nowrap text-info">${element.task_name}</strong>
                                        </div>
                                        <div class="d-flex" style="width: 100%">
                                        ${element.processing_actions !== null ?


            `<tag title="${element.processing_actions.user.email}" contenteditable="false" spellcheck="false" tabindex="-1" class="tagify__tag tagify--noAnim" value="3" name="Ardeen Batisse" avatar="${element.processing_actions.user.avatar_url}" email="${element.processing_actions.user.email}"><x title="" class="tagify__tag__removeBtn" role="button" aria-label="remove tag"></x><div><div class="tagify__tag__avatar-wrap"><img onerror="this.style.visibility='hidden'" src="${element.processing_actions.user.avatar_url}"></div><span class="tagify__tag-text">${element.processing_actions.user.fullname}</span></div></tag>
` : 'Empty'}
                                        </div>
                                        <div class="d-flex justify-end gap-1">
                                        <button class="btn btn-success fw-edit waves-effect waves-light" type="button"><i class="fa-solid fa-pen-to-square"></i></button>
                                        <button class="btn btn-danger fw-del waves-effect waves-light" type="button"><i class="fa-solid fa-trash"></i></button>
                                        <button type="button" class="btn btn-label-dark waves-effect">${element.status['name']}</button>
                                        </div>
                                    </div>
                                    <hr>`)
    })


}

$('#ForwardTicket').on('submit', function (e) {
    e.preventDefault()
    let id_ticket = $.urlParam('s');
    let dataForm = $(this).serializeArray();
    $('#ForwardHandleTicket').block({
        message: '<div class="spinner-border text-primary" role="status"></div>', css: {
            backgroundColor: "transparent", border: "0"
        }, overlayCSS: {
            backgroundColor: "#000", opacity: 0.25
        }
    }).prop('disabled', true)

    $.ajax({
        type: "PUT", url: `forward-ticket/${id_ticket}`, data: dataForm, success: function (response) {
            TicketShow(id_ticket);
            $('#ForwardHandleTicket').unblock().prop('disabled', false);
            toastr.success('Successfully', response)
            $('#ModalToForwardTicket').modal('hide');
        }, error: function (jqXHR) {
            $('#ForwardHandleTicket').unblock().prop('disabled', false);
            toastr.error(jqXHR.responseJSON.message, 'error')
        }
    });

})

$.urlParam = function (name) {
    var results = new RegExp('[\?&]' + name + '=([^&#]*)').exec(window.location.href);
    return results !== null ? results[1] || 0 : false;
}


// Users List suggestion
//------------------------------------------------------
function tagTemplate(tagData) {
    return `
    <tag title="${tagData.title || tagData.email}"
      contenteditable='false'
      spellcheck='false'
      tabIndex="-1"
      class="${this.settings.classNames.tag} ${tagData.class ? tagData.class : ''}"
      ${this.getAttributes(tagData)}
    >
      <x title='' class='tagify__tag__removeBtn' role='button' aria-label='remove tag'></x>
      <div>
        <div class='tagify__tag__avatar-wrap'>
          <img onerror="this.style.visibility='hidden'" src="${tagData.avatar}">
        </div>
        <span class='tagify__tag-text'>${tagData.name}</span>
      </div>
    </tag>
  `;
}

function suggestionItemTemplate(tagData) {
    return `
    <div ${this.getAttributes(tagData)}
      class='tagify__dropdown__item align-items-center ${tagData.class ? tagData.class : ''}'
      tabindex="0"
      role="option"
    >
      ${tagData.avatar ? `<div class='tagify__dropdown__item__avatar-wrap'>
          <img onerror="this.style.visibility='hidden'" src="${tagData.avatar}">
        </div>` : ''}
      <div class="fw-medium">${tagData.name}</div>
      <span>${tagData.departments}</span>
    </div>
  `;
}

function dropdownHeaderTemplate(suggestions) {
    return `
        <div class="${this.settings.classNames.dropdownItem} ${this.settings.classNames.dropdownItem}__addAll">
            <strong>${this.value.length ? `Add remaning` : 'Add All'}</strong>
            <span>${suggestions.length} members</span>
        </div>
    `;
}

$(document).on('click', 'button#Ticket-send-Approval', function () {
    $.ajax({
        url: './ManagerLists', method: 'GET', success: function (response) {
            $('#ListManager').empty();
            response.forEach(element => {
                $('select#ListManager').append(`<option value="${element.id}">${element.departments.name} - ${element.fullname}</option>`)
            });
            $('select#ListManager').select2({
                dropdownParent: $('#ModalToApproval')
            });
        }, error: function (err) {
            console.error('Error fetching data:', err);
        }
    });
})


///////////////////////////////////////////////////////////////////END part 1

$('li.email-list-item').off('click');


$(document).on('click', 'li.email-list-item', function () {
    let id = $(this).data('ticket');
    current_view = id;
    addSParameterToURL(id);
    TicketShow(id);
})

$(document).on('click', '#DetailReload', function () {
    TicketShow(current_view)
})

//Button back list Ticket
$('#backtoListTicket').click(function () {
    removeSParameterFromURL();
    LoadAllTicket()
})

//dark mode check
let darkMode = false;
let skinEdit = null;
if ($('html').hasClass('dark-style')) {
    darkMode = 'dark';
    skinEdit = 'oxide-dark';
}

tinymce.init({
    selector: '#myTextarea_create',
    noneditable_class: 'nonedit',
    skin: skinEdit,
    content_css: darkMode,
    plugins: 'fullscreen autolink lists link image charmap preview anchor',
    toolbar: 'fullscreen | undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
    images_upload_url: './upload-image',
    images_upload_base_path: '',
    images_upload_credentials: false,
    images_upload_headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    height: "200",

});


tinymce.init({
    selector: '#myTextarea_comment',
    noneditable_class: 'nonedit',
    skin: skinEdit,
    content_css: darkMode,
    plugins: 'fullscreen autolink lists link image charmap preview anchor',
    toolbar: 'fullscreen | undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
    images_upload_url: './upload-image',
    images_upload_base_path: '',
    images_upload_credentials: false,
    images_upload_headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    height: "200",

});


//Event submit of form
$('#CreateTicketForm,#CreateTicketOffLineForm').on('submit', function (e) {

    e.preventDefault();
    var url = storeRoute
    // Tạo một đối tượng FormData
    var formData = new FormData(this);
    var editor_formCreate = tinymce.get('myTextarea_create');
    var content = editor_formCreate.getContent();


    $("#CreateTicketForm button[type='submit'], #CreateTicketOffLineForm button[type='submit']").block({
        message: '<div class="spinner-border text-primary" role="status"></div>', css: {
            backgroundColor: "transparent", border: "0"
        }, overlayCSS: {
            backgroundColor: "#000", opacity: 0.25
        }
    });


    $("#CreateTicketForm button[type='submit']").prop('disabled', true);
    $("#CreateTicketOffLineForm button[type='submit']").prop('disabled', true);


    if (this.id === "CreateTicketOffLineForm") {
        url = storeRouteOffline
    } else {
        formData.append('content', content);
    }

    $.ajax({
        url: url, type: "POST", data: formData, processData: false, contentType: false, success: function (response) {
            toastr.success('Ticket has new create', 'Create successfully', {
                timeOut: 2000,
            });
            $('#emailComposeSidebar').modal('hide');
            editor_formCreate.setContent('');
            //name="title" = ''
            $('input[name="title"]').val('');

            $("#CreateTicketForm button[type='submit']").prop('disabled', false);
            $("#CreateTicketOffLineForm button[type='submit']").prop('disabled', false);
            TicketShow(response['ticket_id'])
            //LoadAllTicket(current_page);

        }, error: function (data) {
            editor_formCreate.setContent('');
            showErrors(data);
        }, complete: function () {
            $("#CreateTicketForm button[type='submit']").unblock();
            $("#CreateTicketForm button[type='submit']").prop('disabled', false);

            $("#CreateTicketOffLineForm button[type='submit']").unblock();
            $("#CreateTicketOffLineForm button[type='submit']").prop('disabled', false);
        }
    });
});


$('select[name="factories"]').on('change', function () {
    idFactory = $(this).val();
    $.ajax({
        type: "GET", url: "./loadDepartment" + '/' + idFactory, dataType: 'json', success: function (response) {

            $('select[name="departments"]').empty();
            let AuthDept = response.Auth;
            let Departments = response.Departments;
            let selectMe = '';
            Departments.forEach(element => {
                selectMe = element.id === AuthDept ? 'selected' : '';
                $('select[name="departments"]').append(`<option ${selectMe} data-factory=${element.factory_id} value=${element.id} > ${element.name} - ${element.nameEn}</option>`)
            });

        }
    });
});

// Change prolem -> type
$('#problem').change(function () {
    let idProblem = $(this).val();
    $.ajax({
        type: "GET", url: './loadprolemType/' + idProblem, success: function (response) {
            $('#type').empty();
            $('#type2').empty();
            response.forEach(element => {
                const langArr = JSON.parse(element.name_)
                $('#type').append(`<option value="${element.id}">${langArr[lang]}</option>`);
                $('#type2').append(`<option value="${element.id}">${langArr[lang]}</option>`);
            });
        }
    });
})

// Function area
function DrawStatus(Status) {
    switch (Status) {
        case 'reject':
            return '<span class="badge bg-danger bg-glowr">' + Status + '</span>';
            break;
        case 'finish':
            return '<span class="badge bg-success bg-glowr">' + Status + '</span>';
            break;
        default:
            return '<span class="badge bg-primary bg-glowr">' + Status + '</span>';
            break;
    }
}

// Function Show Ticket
function TicketShow(id) {


    $('#side_filler').hide();
    $('#side_timeline').show();
    $('#ticket-reply').off('submit');
    $('#DetailReload').off('click');
    $('#app-email-view').attr('data-ticket', id);
    $('#ticketTimeLine').html(`#${id} `)
    $('#timeLineContent').empty().append(`<div class="d-flex justify-content-center">
  <div class="spinner-border" role="status">
    <span class="sr-only">Loading...</span>
  </div>
</div>
        `);

    current_view = id;
    clearFormReply();
    $.ajax({
        type: "GET", url: `./ticket/${current_view}`, success: function (response) {
            addSParameterToURL(id);

            //add timeLineContent from Timeline
            let timeLineContent = response.Timeline;
            console.log(response.TicketInfo.factories.name);
            //foreach timeLineContent add to #timeLineContent //convert ${element.created_at} to YYYY/MM/DD HH:MM:SS
            $('#timeLineContent').empty();
            timeLineContent.forEach(element => {
                $('#timeLineContent').append(`  <li class="timeline-item timeline-item-transparent" style="padding-left:  1rem !important;">
                            <span class="timeline-point timeline-point-${element.color}"></span>
                                <div class="timeline-event">
                                    <div class="timeline-header">
                                    <span>${element.formatted_created_at}</span>
                                    </div>
                                    <div class="justify-content-between flex-wrap">
                                        ${element.fullname} <i class="fa-solid fa-arrow-right"></i>  ${element.content}
                                    </div>
                                </div>
                            </li>`);
            });


            $('.app-email-view-content').removeClass('ps ps--active-y')
            $('#TicketContent').children().not('#staffHandleCollapse').remove();

            $('#list_staff_handle').removeClass('show');

            let TicketDetail = response.TicketDetail;
            let TicketInfo = response.TicketInfo;
            let ButtonLists = response.Buttons;
            let TextareaChat = response.Buttons['Textarea'];
            if (TextareaChat === true) {
                $('.email-reply').removeClass('d-none');
                tinymce.init({
                    selector: '#myTextarea',
                    noneditable_class: 'nonedit',
                    skin: skinEdit,
                    content_css: darkMode,
                    plugins: 'autolink lists link image charmap preview anchor',
                    toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
                    images_upload_url: './upload-image',
                    images_upload_base_path: '',
                    images_upload_credentials: false,
                    images_upload_headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    height: "200"
                });
            } else {
                $('.email-reply').addClass('d-none');
            }

            $('#ticketDetailTitle').text(TicketDetail[0].ticket.title)
            $('#ticketDetailFactory').text(response.TicketInfo.factories.name)
            $('#ButtonTopArea').html(`
<span class="me-2 badge bg-label-info">${response.TicketInfo.has_type.has_problem.name}: ${TicketDetail[0].ticket.has_type['name']}</span>
<span class="me-2 badge bg-label-info">Department: ${TicketDetail[0].ticket.department['name']}</span>
<span class="me-2 badge bg-${TicketDetail[0].ticket.has_status['display']}">Status: ${TicketDetail[0].ticket.has_status['name']}</span>
`)


            $('#ButtonBottomArea').empty();
            ButtonLists.ButtonBottomArea.forEach(element => {
                $('#ButtonBottomArea').append(element);
            });

            DataContent = "";
            Attachments = ""
            //  tinymce.activeEditor.setContent('');


            TicketDetail.forEach(element => {
                if (element.files !== null && element.files !== '') {
                    Attachments += '<hr>';
                    const fileList = element.files;
                    fileList.forEach(file => {
                        Attachments += '<p class="email-attachment-title mb-2"></p>';
                        Attachments += `<a href="./downloadFile/${file.slug}"><i class="ti ti-file"></i>${file.filename} (${Math.round(file.size / 1024)} KB)</a>`;

                    });

                }


                ;DataContent += `<div class="card email-card-prev mx-sm-4 mx-3 mt-4" style="display: block;">
                            <div class="card-header d-flex justify-content-between align-items-center flex-wrap">
                                <a class="d-flex align-items-center mb-sm-0 mb-3 cursor-pointer" href="${homepage}user/${element.user_create.id}">
                                    <img src="${element.user_create['avatar_url']}" alt="user-avatar"
                                         class="flex-shrink-0 rounded-circle me-3" height="40" width="40" data-user-id="${element.user_create['id']}">
                                    <div class="flex-grow-1 ms-1">
                                        <h6 class="m-0">${element.user_create['fullname']}</h6>
                                        <span class="badge bg-primary">${element.user_create.departments['name']}</span>
                                    </div>
                                </a>
                                <div class="d-flex align-items-center">
                                    <p class="mb-0 me-3 text-muted">${element.formatted_created_at}</p>
                                </div>
                            </div>
                            <div class="card-body">
                               ${element.contentData}
                               ${Attachments}
                            </div>
                        </div>`;
                Attachments = "";
            });

            //show display list staff handle
            $('#list_staff_handle').empty()

            $('#staffHandleCollapse').removeClass('show')

            //show display list staff handle or not

            if (TicketInfo.subtasks.length === 0) {
                $('#list_staff_handle').append(`<smaill class="">Not staff handle!</smaill>`);

            } else {
                TicketInfo.subtasks.forEach(staff => {
                    $('#list_staff_handle')
                        .append(`<tag title="${staff.staff_handle?.fullname || ''}"
                                  contenteditable='false'
                                  spellcheck='false'
                                  tabIndex="-1"
                                  class="tagify__tag tagify--noAnim"
                                  data-staff-id = "${staff.staff_handle?.id || ''}"
                                  style="padding-right: 5px !important;"
                                >
                                  <div>
                                    <div class='tagify__tag__avatar-wrap'>
                                      <img onerror="this.style.visibility='hidden'" src="./${staff.staff_handle?.avatar_url || ''}">
                                    </div>
                                    <span class='tagify__tag-text'>${staff.staff_handle?.fullname || ''}</span>
                                  </div>
                                </tag>`);
                })
            }


            $('#TicketContent').append(DataContent);
            let emailViewContent = $('.app-email-view-content');
            emailViewContent.find('.scroll-to-reply').on('click', function () {
                // $('.email-reply').append(`<h6 class="card-header border-0">'Repy hello'</h6>`)
                if (emailViewContent[0].scrollTop === 0) {
                    emailViewContent.animate({
                        scrollTop: emailViewContent[0].scrollHeight
                    }, 1500);
                }
            });
            emailView = document.querySelector('.app-email-view-content');
            if (emailView) {
                new PerfectScrollbar(emailView, {
                    wheelPropagation: false, suppressScrollX: true
                });
            }
            $('#app-email-view').addClass('show');
            if (emailViewContent[0].scrollTop === 0) {
                emailViewContent.animate({
                    scrollTop: emailViewContent[0].scrollHeight
                }, 1500);
            }

        }, error: function (jqXHR) {
            LoadAllTicket(current_page);
            toastr.error(jqXHR.responseJSON.message, 'ERROR', {
                timeOut: 10000,
            });
        }, beforeSend: function () {

        }, complete: function () {


        }
    });

    // $('#list_staff_handle').on('click','tag', function () {
    //     let staff_id = $(this).data('staff-id')
    //     console.log(staff_id)
    //     //show collapse #staffHandleCollapse
    //     $('#staffHandleCollapse').collapse('show');
    // })

    //code for event staffHandleCollapse is collapse show
    $('#staffHandleCollapse').off('show.bs.collapse').on('show.bs.collapse', function () {


        //call table staff_processing_info
        $('#staff_processing_info').DataTable({
            paging: false, scrollX: true, scrollY: "500px",
            //scroller: true,
            processing: true, destroy: true, searching: false, "bInfo": false, ajax: {
                type: "GET", url: `./subtasks/${current_view}`,

            }, columns: [{
                data: null, title: '#', render: function (data, type, row, meta) {
                    return meta.row + 1; // Add 1 to the row index to display the serial number
                }
            }
                // { data: 'id', title: '#' }
                , {
                    data: 'status', title: 'Status', render: function (data) {
                        return `<strong class="text-nowrap text-${data.display}">${data.name}</strong>`
                    }
                }, {
                    data: 'staff_handle.fullname', title: 'Staff handle'
                },

                {
                    data: null, title: 'Action', // return input filed reason
                    render: function (data, type, row) {
                        if (auth.id === data.staff_handle.id) {
                            if (data.id_status === '13' || data.id_status === '14') {
                                return `
<div class="btn-group" role="group">
                  <button style="border: unset" id="btnGroupDrop1" type="button" class="btn btn-outline-secondary waves-effect" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fa-solid fa-ellipsis"></i></button>
                  <div class="dropdown-menu" aria-labelledby="btnGroupDrop1" style="">
                  <button id="cancel_holding_subtask" data-status="cancel-holding" type="button" value='${data.id}'
                  class="btn btn-danger waves-effect waves-light">Cancel Holding</button>

                  </div>
                </div>


                                `

                            }
                            if (data.id_status === '11') {

                                return `<div class="btn-group" role="group">
                  <button style="border: unset" id="btnGroupDrop1" type="button" class="btn btn-outline-secondary waves-effect" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fa-solid fa-ellipsis"></i></button>
                  <div class="dropdown-menu" aria-labelledby="btnGroupDrop1" style="">
                  <button id="holding_subtask" data-status="holding" type="button" value='${data.id}'
                  class="btn btn-warning waves-effect waves-light">Request Holding</button>
                  <button id="done_subtask" data-status="done" type="button" value='${data.id}'
                  class="btn btn-success waves-effect waves-light">Done</button>
                  </div>
                </div>`
                            } else {
                                return `<div class="btn-group" role="group">
                                <button style="border: unset" id="btnGroupDrop1" type="button" class="btn btn-outline-secondary waves-effect" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fa-solid fa-ellipsis"></i></button>
                                <div class="dropdown-menu" aria-labelledby="btnGroupDrop1" style="">
                                <button id="holding_subtask" data-status="holding" type="button" value='${data.id}'
                                class="btn btn-warning waves-effect waves-light">Request Holding</button>

                                </div>
                              </div>`
                            }


                        } else {
                            return ''
                        }
                    }

                }, {
                    data: 'task_name', title: 'task_name'
                }, {
                    data: null, title: 'reason', // return input filed reason
                    render: function (data, type, row) {
                        if (auth.id === data.staff_handle.id) {
                            const reasonValue = data.reason != null ? data.reason : '';

                            return `<div class="d-flex"><input id="edit_reason"  placeholder="Type you reason" style ="${data.reason === null ? 'border:dashed red' : ''}"  title="text"class="form-control" value="${reasonValue}">
                       <button id="btn_edit_reason" style="display:  ${reasonValue == '' ? 'none' : 'block'}" data-subtask-id = ${data.id} class="btn btn-success"><i class="fa-solid fa-floppy-disk"></i></button><div>`


                        } else {
                            return data.reason
                        }
                    }

                }, {
                    data: null, title: 'solution', // return input filed solution
                    render: function (data, type, row) {
                        if (auth.id === data.staff_handle.id) {
                            const solutionValue = data.solution != null ? data.solution : '';

                            return `<div class="d-flex"><input id="edit_solution"  placeholder="Type you solution" style ="${data.solution === null ? 'border:dashed red' : ''}" title="text"class="form-control" value="${solutionValue}">
                        <button id="btn_edit_solution" style="display:  ${solutionValue == '' ? 'none' : 'block'}" data-subtask-id = ${data.id} class="btn btn-success"><i class="fa-solid fa-floppy-disk"></i></button></div>`
                        } else {
                            return data.solution
                        }
                    }
                }, {
                    data: 'request', title: 'Request'
                }, {
                    data: 'user_assign.fullname', title: 'Assign by'
                },],

        })
    })


    //Action reply
    $('#ticket-reply').on('submit', function (e) {
        e.preventDefault();
        let id = current_view;
        let formData = new FormData(this);
        let editor2 = tinymce.get('myTextarea');
        var content = editor2.getContent();
        formData.append('content', content);

        $("button#sendComment").block({
            message: '<div class="spinner-border text-primary" role="status"></div>', css: {
                backgroundColor: "transparent", border: "0"
            }, overlayCSS: {
                backgroundColor: "#000", opacity: 0.25
            }
        });
        $("button#sendComment").prop('disabled', true);

        $.ajax({
            type: "POST",
            url: './updateDetail' + "/" + id,
            data: formData,
            processData: false,
            contentType: false,
            success: function (response) {
                editor2.setContent('');
                $("button#sendComment").unblock();
                $("button#sendComment").prop('disabled', false);
                toastr.success(response.message, 'Reply successfully', {
                    timeOut: 2000,
                });
                TicketShow(id);
            },
            error: function (jqXHR) {
                editor2.setContent('');
                $("button#sendComment").unblock();
                $("button#sendComment").prop('disabled', false);
                showErrors(jqXHR);
            },

        });
    });
}

function updateAttachmentName(input) {
    const attachmentSpanId = input.getAttribute("data-attachment-span");
    const span = document.getElementById(attachmentSpanId);

    console.log(input.files)
    if (span && input.files.length > 0) {
        const fileNames = Array.from(input.files).map(file => file.name);
        span.textContent = fileNames.join(', ');

    }
}

function clearFormReply() {
    if (tinymce.get('myTextarea')) {
        // Kiểm tra xem trình soạn thảo có tồn tại không
        tinymce.get('myTextarea').setContent(' '); // Clear the TinyMCE editor content
    }

    $('#attach-file-2').val(''); // Clear the file input value
    $('span#attachment-2').text(''); // Clear the file input value
}

function addSParameterToURL(id) {
    var newURL = new URL(window.location.href);
    if (!newURL.searchParams.has('s')) {
        newURL.searchParams.set('s', id);
        history.pushState({}, '', newURL.toString());
    }
}

function removeSParameterFromURL() {
    var newURL = new URL(window.location.href);
    if (newURL.searchParams.has('s')) {
        newURL.searchParams.delete('s');
        history.pushState({}, '', newURL.toString());
    }
}

function ScrollDown() {
    $('.app-email-view-content.py-4.ps.ps--active-y').scrollTop(1999);
}

function ScrollUp() {
    $('.app-email-view-content.py-4.ps.ps--active-y').scrollTop(0);
}


// create an "add all" custom suggestion element every time the dropdown changes


