console.log('connect successfully message.js')
let ChatlistItem = $('li.chat-contact-list-item');
let ConversationView = null;


ShowConversation();


$('#CreateConversation').click(function () {
    $(this).prop('disabled', true);
    $(this).block({
        message: '<div class="spinner-border text-primary" role="status"></div>',
        css: {
            backgroundColor: "transparent",
            border: "0"
        },
        overlayCSS: {
            backgroundColor: "#000",
            opacity: 0.25
        }
    }),


        $.ajax({
            type: "POST",
            url: "conversation",
            data: { users: $('#select2Primary').val(), name: $('#nameConversation').val() },

            success: function (response) {
                $('#exampleModal').modal('hide');
                ChatHistory(response);
                $('#CreateConversation').prop('disabled', false).unblock();
            }
        });
})

$('#select2Primary').select2({
    ajax: {
        type: 'GET',
        url: 'searchUser',
        delay: 250,
        processResults: function (data) {
            return {
                results: data
            };
        },
        cache: true
    },
    minimumInputLength: 1,
});

$(document).on('click', 'li.chat-contact-list-item', function () {
    ChatHistory($(this).data('id'));
    ConversationView = $(this).data('id');
})


$('.form-send-message').on('submit', function (e) {
    e.preventDefault();
    let messcontent = $('#messcontent').val();
    $('.send-msg-btn').prop('disabled', true).block({
        message: '<div class="spinner-border text-primary" role="status"></div>',
        css: {
          backgroundColor: "transparent",
          border: "0"
        },
        overlayCSS: {
          backgroundColor: "#000",
          opacity: 0.25
        }
    });
    $.ajax({
        type: "POST",
        url: "messengers",
        data: { messcontent: messcontent, conversation_id: ConversationView },
        success: function (response) {
            ChatHistory(response.conversationID);
            $('#messcontent').val('');
            $('.send-msg-btn').prop('disabled', false).unblock();
        },
        complete: function () {

        }
    });

})

// FUNCTION AREA //
function ShowConversation() {
    $.ajax({
        type: "GET",
        url: 'conversation/create',
        success: function (response) {
            $('#chat-list').empty();
            if (response.length > 0) {


                response.forEach(element => {
                    let LastedMess = element.messages[0] !== undefined ? element.messages[0].content : 'no message yet';
                    let LastedMessTime = element.messages[0] !== undefined ? moment(element.messages[0].created_at).calendar() : '';

                    $('#chat-list').append(`
                      <li class="chat-contact-list-item" data-id = ${element.id}>
                                        <a class="d-flex align-items-center">
                                            <div class="flex-shrink-0 avatar avatar-offline">
                                                <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/8/85/Circle-icons-chat.svg/1024px-Circle-icons-chat.svg.png"
                                                     class="rounded-circle"/>
                                            </div>
                                            <div class="chat-contact-info flex-grow-1 ms-2">
                                                <h6 class="chat-contact-name text-truncate m-0">${element.name}</h6>
                                                <p class="chat-contact-status text-muted text-truncate mb-0">
                                                 ${LastedMess}
                                                </p>
                                            </div>
                                            <small class="text-muted mb-auto"> ${LastedMessTime}</small>
                                        </a>
                                    </li>
                    `);
                });
            } else {
                $('#chat-list').children().append(`  <li class="chat-contact-list-item chat-list-item-0 d-none">
                                    <h6 class="text-muted mb-0">No Chats Found</h6>
                                </li>`);
            }

        }
    });
}

function ChatHistory(conversationID) {
    ConversationView = conversationID;
    ShowConversation();

    $.ajax({
        type: "GET",
        url: `conversation/${conversationID}`,
        success: function (response) {

            let Conversations = response.Conversations;
            let MessList = response.MessList;
            let Auth = response.Auth;

            $('#NameGroupTitle').text(Conversations[0].name);

            let ListMenber = Conversations[0].participants.map(participant => participant.fullname).join(', ');
            $('#NameGroupUser').text(ListMenber);


            MessList.forEach(element => {
                timecreate = element.updated_at;
                let right = element.user_id == Auth ? 'chat-message-right' : '';

                $('ul.list-unstyled.chat-history').append(`<li class="chat-message ${right}">
                            <div class="d-flex overflow-hidden">
                              <div class="user-avatar flex-shrink-0 me-3">
                                <div class="avatar avatar-sm">
                                  <img src="${element.user['avatar_url']}" alt="Avatar" class="rounded-circle">
                                </div>
                              </div>
                              <div class="chat-message-wrapper flex-grow-1">
                                <div class="chat-message-text">
                                  <p class="mb-0">${element.content}</p>
                                </div>
                                <div class="text-muted mt-1">
                                  <small>${moment(element.updated_at).calendar()}</small>
                                </div>
                              </div>
                            </div>
                          </li>`);

            });

            new PerfectScrollbar('.chat-history-body', {
                wheelPropagation: false, suppressScrollX: true
            });
            chatHistoryBody = document.querySelector('.chat-history-body');
            chatHistoryBody.scrollTo(0, chatHistoryBody.scrollHeight);

        },
        beforeSend: function () {
            $('.col.app-chat-history.bg-body').show();
            $('.chat-history-body').removeClass('ps--active-y');
            $('ul.list-unstyled.chat-history').empty();
        }
    });

}



