@extends('layouts.master')

@section('page-title', 'Create User')

@section('content')
<div class="container-fluid">
    <div class="row mt-5">
        <div class="col-6">
            <form action="{{ Route('admin.users.store') }}" method="POST">
                @csrf
                @method('POST')
                @if ($errors->any())
                    @foreach ($errors->all() as $error)
                        <div class="alert alert-danger d-flex align-items-center" role="alert">
                            <span class="alert-icon text-danger me-2">
                                <i class="ti ti-ban ti-xs"></i>
                            </span>
                            {{ $error }}
                        </div>
                    @endforeach
                @endif
                @if (session('error'))
                    <div class="alert alert-danger d-flex align-items-center" role="alert">
                        <span class="alert-icon
                                    text-success me-2">
                            <i class="ti ti-check ti-xs"></i>
                        </span>
                        {{ session('success') }}
                    </div>
                @endif
                @if (session('success'))
                    <div class="alert alert-success d-flex align-items-center" role="alert">
                        <span class="alert-icon
                                    text-success me-2">
                            <i class="ti ti-check ti-xs"></i>
                        </span>
                        {{ session('success') }}
                    </div>
                @endif
                <div class="card">

                    <div class="card-header">
                        <h5 class="card-title">Create User</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="name">Username([a-zA-Z0-9_])</label>
                            <input type="text" id="username" name="username" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="name">Full name</label>
                            <input type="text" id="fullname" name="fullname" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="name">Passwords (required|min:6|max:255)</label>
                            <input type="password" id="password" name="password" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="name">Re-Passwords</label>
                            <input type="password" id="re-password" name="re-password" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="name">Email</label>
                            <input type="email" name="email" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="name">Role</label>
                            <select name="role" id="role" class="form-control" required>
                                @foreach ($roles as $role)
                                    <option value="{{ $role->id }}">{{ $role->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="name">Factory</label>
                            <select name="factory" id="factory" class="form-control" required>
                               
                                @foreach ($factories as $factory)
                                    <option value="{{ $factory->id }}">{{ $factory->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="name">Deperment</label>
                            <select name="department" id="department" class="form-control" required>
                                <option value="">Please choose Factory first</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="name">Sesion</label>
                            <select name="section" id="section" class="form-control" required>
                                <option value="">Please choose Sesion</option>
                                @foreach ($sessions as $session)
                                    <option value="{{ $session->id }}">{{ $session->contry->name }} - {{ $session->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="name">positions</label>
                            <select name="position" id="position" class="form-control" required>
                                <option value="">Please choose positions</option>
                                @foreach ($positions as $position)
                                    <option value="{{ $position->id }}">{{ $position->contry->name }} -
                                        {{ $position->position_name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="card-footer d-flex justify-content-end">
                        <button type="submit" class="btn btn-primary m-1">Create</button>
                        <a href="{{ route('admin.users.index') }}" class="btn btn-secondary m-1">Back</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- script for change factory load ajax show dept --}}

{{-- Route::get('/loadDepartment/{id}', [TicketController::class, 'loadDepartment']); --}}
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>

    $('#factory,#department, #section, #position').select2();

    $('#factory').change(function () {
        var factoryId = $(this).val();
        if (factoryId) {
            $.ajax({
                type: "GET",
                url: "{{ url('./loadDepartment') }}/" + factoryId,
                success: function (res) {
                    var datas = res['Departments']

                    //foreach using jquery
                    $("#department").empty();
                    $.each(datas, function (key, value) {
                        $("#department").append('<option value="' + value.id + '">' + value
                            .nameVi + '</option>');
                    });


                }
            });
        } else {
            $("#department").empty();
        }
    });
</script>

@endsection