@extends('layouts.master')

@section('page-title', 'Users Settings')

@section('content')

    <div class="container-fluid">
        <div class="col6">
            @if ($errors->any())
                @foreach ($errors->all() as $error)
                    <div class="alert alert-danger">{{ $error }}</div>
                @endforeach
            @endif
            @if (session('message'))
                <h6 class="alert alert-success">
                    {{ session('message') }}
                </h6>
            @endif
            <form action="{{ route('admin.users.update', ['user' => $users_edit['id']]) }}" method="POST">  
                @csrf
                @method('PUT')
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">Edit User</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input type="text" id="name" name="name" value="{{ $users_edit['username'] }}"
                                class="form-control" disabled>
                        </div>
                        <div class="form-group">
                            <label for="fullname">Fullname</label>
                            <input type="text" id="fullname" name="fullname" value="{{ $users_edit['fullname'] }}"
                                class="form-control">
                        </div>
                        <div class="form-group">
                            <label for="role">Role</label>
                            <select name="role" id="role" class="form-control">
                                @foreach ($roles as $role)
                                    <option value="{{ $role['id'] }}"
                                    {{ $users_edit['roles'][0]['id'] === $role['id'] ? 'selected' : ''}} 
                                    >{{ $role['name'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="factories">Factories</label>
                            <select name="factories" id="fatories_list" class="form-control">
                                @foreach ($factories as $factory)
                                    <option value="{{ $factory['id'] }}"
                                        {{ $users_edit['id_factory'] == $factory['id'] ? 'selected' : '' }}>
                                        {{ $factory['name'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="email">Email</label>
                            <input type="email" name="email" class="form-control" value="{{ $users_edit['email'] }}">
                        </div>
                        <div class="form-group">
                            <label for="name">Departements</label>
                            <select id="departments_list" class="form-control" name="department">
                                <option value="" selected>-- Chose Department --</option>

                                @foreach ($departments as $department)
                                    <option data-factory="{{ $department['id'] }}" value="{{ $department['id'] }}"
                                        {{ $users_edit['id_dept']== $department['id'] ? 'selected' : '' }}>
                                        {{ $department['name'] }} :
                                        {{ $department['nameEn'] }}
                                    </option>
                                @endforeach

                            </select>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary"><i class="fa-solid fa-floppy-disk"></i> Save</button>
                        <a href="{{ route('admin.users.index') }}" class="btn btn-secondary"><i
                                class="fa-solid fa-arrow-left"></i> Back</a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script>
        $('#fatories_list').change(function () {
            var factoryId = $(this).val();
            if (factoryId) {
                $.ajax({
                    type: "GET",
                    url: "{{ url('./loadDepartment') }}/" + factoryId,
                    success: function (res) {
                        var datas = res['Departments']

                        //foreach using jquery
                        $("#departments_list").empty();
                        $.each(datas, function (key, value) {
                            $("#departments_list").append('<option value="' + value.id + '">' + value.nameVi + '</option>');
                        });


                    }
                });
            } else {
                $("#departments_list").empty();
            }
        });
    </script>
@endsection
