@extends('layouts.master')

@section('page-title', 'Translate')

@section('content')
    <div class="container-fluid pt-5">
        <livewire:toast />
        <div class="row">
            <div>
            </div>
            <div class="col-lg-12">
                <!-- Breadcrumb -->
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.index') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.translate.index') }}">Translate</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Edit Translation</li>
                    </ol>
                </nav>

                <!-- Card content -->
                <div class="card">
                    <div class="card-header">
                        <h4>Translate</h4>
                        <span>List all translate</span>
                        <span>Dont remove :variable </span>
                    </div>
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="nav flex-column nav-pills me-3" id="v-pills-tab" role="tablist"
                                 aria-orientation="vertical" style="width: 200px;">
                                @foreach($counties as $country)
                                    <button class="nav-link" id="v-pills-{{$country}}-tab" data-bs-toggle="pill"
                                            data-bs-target="#v-pills-{{$country}}" type="button" role="tab"
                                            aria-controls="v-pills-{{$country}}" aria-selected="true">{{$country}}
                                    </button>
                                @endforeach
                            </div>
                            <div class="tab-content flex-grow-1" id="v-pills-tabContent">
                                @foreach($counties as $country)
                                    <div class="tab-pane fade show" id="v-pills-{{$country}}" role="tabpanel"
                                         aria-labelledby="v-pills-{{$country}}-tab">
                                        <form action="{{ route('admin.translate.update', $country) }}" method="POST">
                                            @csrf
                                            @method('PUT')

                                            <table class="table table-bordered">
                                                <thead>
                                                <tr>
                                                    <th class="col-2">Locale</th>
                                                    <th class="col-4">Key</th>
                                                    <th class="col-4">Value</th>
                                                    <th class="col-2">Zone</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($translations[$country] as $index => $translation)
                                                    <tr>
                                                        <td>
                                                            <input type="text" class="form-control" id="locale"
                                                                   value="{{ $translation->locale }}" disabled>
                                                        </td>
                                                        <td>
                                                            <input type="text" class="form-control" value="{{ $translation->key }}" disabled>
                                                            <input type="hidden" name="key[]" value="{{ $translation->key }}">
                                                        </td>
                                                        <td>
                                                            <input type="text"
                                                                   class="form-control @error('value') is-invalid @enderror"
                                                                   id="value" name="value[]"
                                                                   value="{{ old('value.' . $index, $translation->value) }}"
                                                                   required>

                                                            @error('value.' . $index)
                                                            <div class="invalid-feedback">{{ $message }}</div>
                                                            @enderror
                                                        </td>
                                                        <td>
                                                            <input type="text" class="form-control" value="{{ $translation->zone }}" disabled>
                                                            <input type="hidden" name="zone[]" value="{{ $translation->zone }}">
                                                        </td>
                                                    </tr>
                                                @endforeach
                                                </tbody>


                                            </table>

                                            <div class="text-end">
                                                <button type="submit" class="btn btn-primary">Save Changes</button>
                                                <a href="{{ route('admin.translate.index') }}"
                                                   class="btn btn-secondary">Back</a>
                                            </div>
                                        </form>
                                    </div>
                                @endforeach

                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        @if(session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
