@extends('layouts.master')

@section('page-title', 'User Control')

@section('content')
    <!-- CSS only -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet"
          integrity="sha384-+0n0xVW2eSR5Zmz9+Xu5B/w6xZ3Z6Vr1z9q0w2X+X7ZxineVRqF9RvA4gJwZxg2I" crossorigin="anonymous">

    <!-- JavaScript Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"
            integrity="sha384-4Yf5PfX+U5zOJvZ2J+5+JF8n5T+Jz7+oq6w5vZv0W6p4+8+X5R5+1J6c0d+4Zwz9" crossorigin="anonymous">
    </script>

    <div class="container-fluid">

        @if (session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        @if (session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif

        <div class="card">
            <div class="card-header ui-sortable-handle" style="cursor: move;">
                <h3 class="card-title">
                    <i class="fas fa-user mr-1"></i>
                    User lists
                </h3>
                <div class="card-tools">
                    <!-- Button trigger modal -->
                    <a type="button" class="btn btn-primary" href="{{ Route('admin.users.create') }}">
                        Create new user
                    </a>
                    <a type="button" class="btn btn-primary" href="{{ Route('admin.users.importView') }}">
                        Import User
                    </a>
                </div>
            </div>
            <div class="card-body">
                <!-- Modal -->
                <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog"
                     aria-labelledby="exampleModalLabel"
                     aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Create new user</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="button" class="btn btn-primary">Save changes</button>
                            </div>
                        </div>
                    </div>
                </div>
                {{ $users->links('pagination.bootstrap-4') }}
                <div class="row">
                    <div class="col-md-6">
                        <form action="{{ route('admin.users.index') }}" method="GET">
                            <div class="input-group mb-3">
                                <input type="text" class="form-control" placeholder="Search like {name} or like {id}"
                                       name="search" value="{{ $search ?? request()->query('search') }}">
                                <select class="form-control" name='factory'>
                                    @foreach ($Factories as $factory)
                                        <option value="{{ $factory->id }}"
                                                @if (isset($s_factory) && $s_factory == $factory->id) selected
                                                @elseif($factory->id == auth()->user()->id_factory) selected @endif>
                                            {{ $factory->name }}</option>
                                    @endforeach
                                </select>
                                <div class="input-group-append">
                                    <button class="btn btn-primary" type="submit">Search</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <table class="table table-bordered table-hover" id="table_user">
                    <thead class="thead-dark">
                    <tr>
                        <th>ID</th>
                        <th>Employee ID</th>
                        <th>Name</th>
                        <th>Factory</th>
                        <th>Role</th>
                        <th>Permision</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody class="table-group-divider">
                    @foreach ($users as $user)
                        <tr>
                            <td>{{ $user->id }}</td>
                            <td>{{ $user->username }}</td>
                            <td>
                                {{ $user->fullname }}
                            </td>
                            <td>
                                {{ $user->factories['name'] }}
                            </td>
                            <td>
                                @foreach ($user->roles as $role)
                                    <span class="badge bg-primary">{{ $role->name }}</span>
                                @endforeach
                            </td>
                            <td>
                                @foreach ($user->roles as $role)
                                    @foreach ($role->permissions as $permission)
                                        <span class="badge bg-primary">{{ $permission->name }}</span>
                                    @endforeach
                                @endforeach
                            </td>
                            <td class="d-flex justify-content-around align-items-center">
                                @can('add user')
                                    <a href="{{ route('admin.users.edit', ['user' => $user->id]) }}"
                                       class="btn btn-success"><i class="fa-solid fa-user-pen"></i> Edit</a>
                                @endcan
                                @can('delete user')
                                    <form id="form-delete-user" method="POST"
                                          action="{{ route('admin.users.destroy', ['user' => $user->id]) }}"
                                          style="display:inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger" id="delete_user"><i
                                                class="fa-solid fa-user-times"></i>
                                            Delete
                                        </button>
                                    </form>
                                @endcan
                                @can('ban user')
                                    <a href="{{ route('admin.users.edit', ['user' => $user->id]) }}"
                                       class="btn btn-secondary"><i class="fa-solid fa-ban"></i> Ban</a>
                                @endcan
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
                {{ $users->links('pagination.bootstrap-4') }}
            </div>
        </div>
    </div>


    <script>
        $(document).on('submit', '#form-delete-user', function (e) {
            e.preventDefault();
            var form = this; // Store the form element

            Swal.fire({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit(); // Submit the form
                }
            });

        });
    </script>

@endsection
