<x-guest-layout>
    <x-auth-card>
        <x-slot name="logo">
            <a href="/">
                <x-application-logo class="w-20 h-20 fill-current text-gray-500" />
            </a>
        </x-slot>

        <!-- Validation Errors -->
        <x-auth-validation-errors class="mb-4" :errors="$errors" />

        <form method="POST" action="{{ route('register') }}">
            @csrf

            <!-- Name -->
            <div>
                <x-label for="username" :value="('Username')" />

                <x-input id="username" class="block mt-1 w-full" type="text" name="username" :value="old('username')" required
                    autofocus />
            </div>
            <div class="mt-4">
                <x-label for="fullname" :value="('Fullname')" />

                <x-input id="fullname" class="block mt-1 w-full" type="text" name="fullname" :value="old('fullname')"
                    required autofocus />
            </div>

            <!-- Password -->
            <div class="mt-4">
                <x-label for="password" :value="('Password')" />

                <x-input id="password" class="block mt-1 w-full" type="password" name="password" required
                    autocomplete="new-password" />
            </div>

            <!-- Confirm Password -->
            <div class="mt-4">
                <x-label for="password_confirmation" :value="('Confirm Password')" />

                <x-input id="password_confirmation" class="block mt-1 w-full" type="password"
                    name="password_confirmation" required />
            </div>

            <div class="mt-4">
                <x-label for="fatories_list" :value="('Factories')" />

                <select id="fatories_list" class="block mt-1 w-full" name="factories" required>
                    <option value="">-- Chose Factory --</option>
                    @foreach ($datas['fatories'] as $factory)
                        <option value="{{ $factory->id }}">{{ $factory->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="mt-4">
                <x-label for="departments" :value="('Departments')" />




                <select id="departments_list" class="block mt-1 w-full" name="department" required>
                    <option value="">-- Chose Department --</option>
                    @foreach ($datas['fatories'] as $factory)
                        @foreach ($factory->departments as $department)
                            <option data-factory="{{$factory->id}}" value="{{ $department->id }}">{{ $department->name }} : {{ $department->nameEn }}</option>
                        @endforeach
                    @endforeach
                </select>
            </div>


            <div class="flex items-center justify-end mt-4">
                <a class="underline text-sm text-gray-600 hover:text-gray-900" href="{{ route('login') }}">
                    {{ ('Already registered?') }}
                </a>

                <x-button class="ml-4">
                    {{ ('Register') }}
                </x-button>
            </div>
        </form>


        <script>
            $(document).ready(function() {
                $('#fatories_list').on('change', function() {
                    var selectedFactoryId = $(this).val();
                    // Ẩn tất cả các lựa chọn
                    $('#departments_list option:not([value=""])').hide();
                    // Hiển thị lựa chọn có data-factory tương ứng với selectedFactoryId
                    //$('#departments_list').val("");
                    $('#departments_list option[data-factory="' + selectedFactoryId + '"]').show();
                });
            });
        </script>

    </x-auth-card>
</x-guest-layout>
