@extends('layouts.master')
@section('Page-title', 'Ticket Dashboard')

@section('Page-css')
    <link rel="stylesheet" href="{{ asset('assets/vendor/css/pages/app-email.css') }}"/>
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/rateyo/rateyo.css') }}"/>
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/select2/select2.css') }}"/>
    <script src="https://cdn.datatables.net/2.0.8/js/dataTables.js"></script>
    <style>
        #TicketContent img {
            max-width: 600px;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice {
            font-size: unset !important;
            line-height: unset !important;
        }

        #edit_solution,
        #edit_reason {
            min-width: 500px;
        }

    </style>

@endsection

@section('content')

    <script>
        const roles = @json(auth()->user()->roles()->pluck('name'));
    </script>

    <script>
        let updateRoute = "{{ route('ticket.update', '') }}";
        let storeRoute = "{{ route('ticket.store') }}";
        let storeRouteOffline = "{{ route('ticket_offline') }}";
        let showRoute = "{{ route('ticket.show', '') }}";
        let createRoute = "{{ route('ticket.create') }}";
        let destroyRoute = "{{ route('ticket.destroy', '') }}";
        const auth = @json(auth()->user());
    </script>


    <link rel="stylesheet" href="https://cdn.datatables.net/2.0.4/css/dataTables.dataTables.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/fixedcolumns/5.0.0/css/fixedColumns.dataTables.css"/>

    <script src="https://code.jquery.com/jquery-3.7.1.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.datatables.net/2.0.4/js/dataTables.js"></script>
    <script src="https://cdn.datatables.net/fixedcolumns/5.0.0/js/fixedColumns.dataTables.js"></script>
    <script src="https://cdn.datatables.net/fixedcolumns/5.0.0/js/dataTables.fixedColumns.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet"/>

    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="modal fade" id="PreviewImageModal" tabindex="-1" aria-labelledby="PreviewImageModalLabel"
             aria-hidden="true">
            <div class="modal-dialog modal-fullscreen" role="document">
                <div>
                    <div class="d-flex justify-content-center">
                        <div class="btn btn-danger" style="border-radius: 5px; width:50px;">Close</div>
                    </div>
                </div>
                <div class="modal-content">

                </div>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="modal_subtaksInfor" data-backdrop="static" data-bs-keyboard="false"
             style="z-index: 9999;" tabindex="-1" role="dialog" aria-labelledby="modal_subtaksInfor" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                <div class="modal-content">
                    <form id="form_subtasks">
                        <div class="modal-header">
                            <h5 class="modal-title">Sub task detail</h5>
                            <div id="subtask_status"></div>
                            <button type="button" class="btn-close text-danger" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div id="staff-process">

                                <div class="form-group d-none">
                                    <input type="text" class="form-control" id="subtask_id" disabled>
                                </div>
                                <div class="form-group">
                                    <label for="subtask_reason" class="form-label">subtask_title
                                        <smail class="text-danger">
                                            *
                                        </smail>
                                    </label>
                                    <input type="text" class="form-control" id="subtask_title"
                                           placeholder="Enter subtask_title" required>
                                </div>

                                <div class="form-group">
                                    <label for="staff-handle-list" class="form-label">Staff name
                                        <smail class="text-danger">
                                            *
                                        </smail>
                                    </label>
                                    <select class="js-example-basic-single" id="subtask_staff" name="state"
                                            required></select>
                                </div>

                                <div class="form-group">
                                    <label for="subtask_reason" class="form-label">subtask_reason</label>
                                    <input type="text" class="form-control" id="subtask_reason"
                                           placeholder="Enter subtask name">
                                </div>
                                <div class="form-group">
                                    <label for="subtask_solution" class="form-label">subtask_solution</label>
                                    <input type="text" class="form-control" id="subtask_solution"
                                           placeholder="Enter subtask name">
                                </div>

                                <div class="form-group">
                                    <label for="subtask_request" class="form-label">subtask_request</label>
                                    <input type="text" class="form-control" id="subtask_request"
                                           placeholder="Enter subtask subtask_request" disabled>
                                </div>


                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="submit" id="subtask-create" value="create" class="btn btn-success"
                                    style="display: none">Create
                            </button>
                            <button type="submit" id="subtask-save" value="save" class="btn btn-success"
                                    style="display: none">Save
                            </button>
                            <button type="submit" id="subtask-approved" value="approved" class="btn btn-warning"
                                    style="display: none">Approved
                            </button>
                            <button type="submit" id="subtask-reject" value="reject" class="btn btn-danger"
                                    style="display: none">Reject
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>


        <!-- Modal Giao viec -->
        <form id="ForwardTicket">
            <div class="modal hide fade in" style="z-index: 9998;" data-backdrop="static" data-bs-keyboard="false"
                 id="ModalToForwardTicket" tabindex="-1" aria-labelledby="ModalToApprovalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalToggleLabel">Staffs Assign Panel</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                        </div>
                        <div class="modal-body" style="min-height: 500px;">
                            <div class="col-12 mb-3">
                                <div id="ticket_breakdown"></div>
                                <table class="table table-striped table-bordered row-border order-column"
                                       id="ticket_breakdown_table" style="width: 100%"></table>
                            </div>
                        </div>
                        <div class="modal-footer">

                        </div>
                    </div>
                </div>
            </div>
        </form>

        <!-- Modal Xin approval -->
        <form id="SendApproval">
            <div class="modal fade" id="ModalToApproval" tabindex="-1" aria-labelledby="ModalToApprovalLabel"
                 aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalToggleLabel">Manager Lists</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="col-12 mb-3">
                                <label for="ListManager" class="form-label">Manager Lists</label>
                                <select id="ListManager" required name="ListManager" class="form-control"></select>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="SendApproval" class="btn btn-primary">Submit a request for
                                approval
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </form>


        <!-- Modal Notice -->


        @if (Session::has('warning'))
            <div class="alert alert-warning">
                {{ Session::get('warning') }}
            </div>
        @endif

        @if (Session::has('danger'))
            <div class="alert alert-danger">
                {{ Session::get('danger') }}
            </div>
        @endif



        <!-- Modal Finish -->
        <form id="FinishTicket" method="POST">
            <div class="modal fade" id="ModalToFinish" tabindex="-1" aria-labelledby="ModalToFinishLabel"
                 aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalToggleLabel">Finish Ticket</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <span class="fw-medium">Ratings:</span>
                                <span class="counter"></span>
                                <div class="onChange-event-ratings"></div>
                            </div>
                            <div class="form-group pt-2">
                                <span class="fw-medium counter_staff_text">Star of Staff :</span>
                                <span class="counter"></span>
                                <div class="finish_staff_ratings"></div>
                            </div>


                            <div class="counter-wrapper mt-3">
                            </div>
                            <div class="form-group comment-star">
                                <label for="commentStar">Note:</label>
                                <input class="form-control" type="text" name="commentStar" id="commentStar" required>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="btn-submit-finish" class="btn btn-primary">OK</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>

        <div class="app-email card">
            <div class="row g-0">

                <!-- Email Sidebar -->
                <div class="col app-email-sidebar border-end flex-grow-0" id="app-email-sidebar">
                    <!-- History Sidebar -->
                    <div class="overflow-auto">

                        <div class="btn-compost-wrapper overflow-auto" id="side_timeline" style="max-height: 500px">
                            <h5><span id="ticketTimeLine"></span>{{translate('ticket.Time Line')}}</h5>
                            <ul class="timeline mb-0" id="timeLineContent">
                                <div class="d-flex justify-content-center">
                                    <div class="spinner-border" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                </div>
                            </ul>
                        </div>
                    </div>
                    <div id="side_filler" class="">
                        <div class="btn-compost-wrapper d-grid">

                            @can('create ticket')
                                <button class="btn btn-primary btn-compose" data-bs-toggle="modal"
                                        data-bs-target="#emailComposeSidebar" id="emailComposeSidebarLabel">
                                    <i class="ti ti-mail-plus me-1"></i>
                                    {{ __('ticket.Create Ticket') }}
                                </button>
                            @endcan
                        </div>
                        <!-- Email Filters -->
                        <div class="email-filters py-2">
                            <!-- Email Filters: Folder -->
                            <ul class="email-filter-folders list-unstyled mb-4">

                                {{--                            <li class="d-flex" data-target="sent"> --}}
                                {{--                                <a href="javascript:void(0);" class="d-flex flex-wrap align-items-center"> --}}
                                {{--                                    <i class="ti ti-send ti-sm"></i> --}}
                                {{--                                    <span class="align-middle ms-2">Sent</span> --}}
                                {{--                                </a> --}}
                                {{--                            </li> --}}
                                {{--                            <li class="d-flex" data-target="draft"> --}}
                                {{--                                <a href="javascript:void(0);" class="d-flex flex-wrap align-items-center"> --}}
                                {{--                                    <i class="ti ti-file ti-sm"></i> --}}
                                {{--                                    <span class="align-middle ms-2">Draft</span> --}}
                                {{--                                </a> --}}
                                {{--                            </li> --}}
                                {{--                            <li class="d-flex justify-content-between" data-target="starred"> --}}
                                {{--                                <a href="javascript:void(0);" class="d-flex flex-wrap align-items-center"> --}}
                                {{--                                    <i class="ti ti-star ti-sm"></i> --}}
                                {{--                                    <span class="align-middle ms-2">Starred</span> --}}
                                {{--                                </a> --}}
                                {{--                                <div class="badge bg-label-warning rounded-pill badge-center">10</div> --}}
                                {{--                            </li> --}}
                                {{--                            <li class="d-flex align-items-center" data-target="spam"> --}}
                                {{--                                <a href="javascript:void(0);" class="d-flex flex-wrap align-items-center"> --}}
                                {{--                                    <i class="ti ti-info-circle ti-sm"></i> --}}
                                {{--                                    <span class="align-middle ms-2">Spam</span> --}}
                                {{--                                </a> --}}
                                {{--                            </li> --}}
                                {{--                            <li class="d-flex align-items-center" data-target="trash"> --}}
                                {{--                                <a href="javascript:void(0);" class="d-flex flex-wrap align-items-center"> --}}
                                {{--                                    <i class="ti ti-trash ti-sm"></i>aaaaaaa --}}
                                {{--                                    <span class="align-middle ms-2">Trash</span> --}}
                                {{--                                </a> --}}
                                {{--                            </li> --}}
                            </ul>
                            <!-- Email Filters: Labels -->

                            <div class="email-filter-labels">
                                <div class="col-md m-4">
                                    <div class="form-group">
                                        <label
                                            for="">{{translate("ticket.Show only the ticket myself related")}}</label>
                                        <input type="checkbox" class="form-checkbox" id="showOnlyMe">
                                    </div>

                                    <hr>
                                </div>
                                <div class="col-md m-4">

                                    <small
                                        class="fw-normal text-uppercase text-muted m-4">{{ __('ticket.Label Status') }}</small>

                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="check_box_all_label"
                                               checked>
                                        <label class="form-check-label">{{ __('ticket.All') }}</label>
                                    </div>
                                    <div id="list_status">

                                        @foreach ($datas['statusList'] as $status)
                                            <div class="form-check-{{ $status->display }}">
                                                <input class="form-check-input" type="checkbox"
                                                       value="{{ $status->id }}" id="status{{ $status->id }}"
                                                       name="status" checked>
                                                <label class="form-check-label"
                                                       for="status{{ $status->id }}">{{ trans("ticket.{$status->name}") }}
                                                </label>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                                <div class="col-md m-4">
                                    <small class="fw-normal text-uppercase text-muted m-4">
                                        {{ __('ticket.Choose Type') }}</small>
                                    @foreach ($datas['problemList'] as $problemList)
                                        <div class="form-check-{{ $problemList->display }}">
                                            <input class="form-check-input" type="checkbox"
                                                   value="{{ $problemList->id }}" id="problemList{{ $problemList->id }}"
                                                   name="RequestType" checked>
                                            <label class="form-check-label" for="problemList{{ $problemList->id }}">
                                                {{ $problemList->name }} </label>
                                        </div>
                                    @endforeach
                                </div>


                                {{--                            <ul class="list-unstyled mb-0 mt-2"> --}}
                                {{--                                <li data-target="work"> --}}
                                {{--                                    <a href="javascript:void(0);"> --}}
                                {{--                                        <span class="badge badge-dot bg-success"></span> --}}
                                {{--                                        <span class="align-middle ms-2">Finish</span> --}}
                                {{--                                    </a> --}}
                                {{--                                </li> --}}
                                {{--                                <li data-target="company"> --}}
                                {{--                                    <a href="javascript:void(0);"> --}}
                                {{--                                        <span class="badge badge-dot bg-primary"></span> --}}
                                {{--                                        <span class="align-middle ms-2">Waiting</span> --}}
                                {{--                                    </a> --}}
                                {{--                                </li> --}}
                                {{--                                <li data-target="important"> --}}
                                {{--                                    <a href="javascript:void(0);"> --}}
                                {{--                                        <span class="badge badge-dot bg-info"></span> --}}
                                {{--                                        <span class="align-middle ms-2">Hold</span> --}}
                                {{--                                    </a> --}}
                                {{--                                </li> --}}
                                {{--                                <li data-target="private"> --}}
                                {{--                                    <a href="javascript:void(0);"> --}}
                                {{--                                        <span class="badge badge-dot bg-danger"></span> --}}
                                {{--                                        <span class="align-middle ms-2">Reject</span> --}}
                                {{--                                    </a> --}}
                                {{--                                </li> --}}
                                {{--                            </ul> --}}
                            </div>
                            <!--/ Email Filters -->
                        </div>
                    </div>
                </div>
                <!--/ Email Sidebar -->

                <!-- Emails List -->
                <div class="col app-emails-list">
                    <div class="shadow-none border-0">
                        <div class="emails-list-header p-3 py-lg-3 py-2">
                            <!-- Email List: Search -->
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center w-100">
                                    <i class="ti ti-menu-2 ti-sm cursor-pointer d-block d-lg-none me-3"
                                       data-bs-toggle="sidebar" data-target="#app-email-sidebar" data-overlay></i>
                                    <div class="mb-0 mb-lg-2 w-100">
                                        <div class="input-group input-group-merge shadow-none">
                                            <span class="input-group-text border-0 ps-0 cursor-pointer dropdown-toggle"
                                                  id="email-search" data-bs-toggle="collapse"
                                                  data-bs-target="#collapseExample" aria-expanded="false"
                                                  aria-controls="collapseExample">
                                                Advanced search
                                                <i class="ti ti-message-2-search"></i>
                                            </span>

                                            <input type="text" class="form-control email-search-input border-0"
                                                   placeholder=" {{ __('ticket.Search Ticket, ID') }}"
                                                   aria-label="  {{ __('ticket.Search Ticket') }}"
                                                   aria-describedby="email-search"/>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex align-items-center mb-0 mb-md-2">
                                    <span class="input-group-text border-0 cursor-pointer" id="clear-search"><i
                                            class="ti ti-clear-formatting"></i></span>

                                    <div class="dropdown d-flex align-self-center">
                                        <button class="btn p-0" type="button" id="emailsActions"
                                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            {{--                                            <i class="ti ti-dots-vertical ti-sm"></i> --}}
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-end" aria-labelledby="emailsActions">

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="collapse p-2" id="collapseExample">

                                @if (auth()->user()->roles->pluck('id')[0] == '9' ||
                                        auth()->user()->roles->pluck('id')[0] == '11' ||
                                        auth()->user()->roles->pluck('id')[0] == '1')
                                    <div class="mb-3">
                                        <label for="defaultFormControlInput" class="form-label">
                                            {{ __('ticket.Factoies') }}</label>

                                        <select id="search_factories" name="search_factories"
                                                class="select2 form-select"
                                                aria-label="Default select example" multiple="multiple">
                                            <!-- <option value="0">All</option> -->
                                            @foreach ($datas['factories'] as $factorie)
                                                <option value="{{ $factorie->id }}">
                                                    {{ $factorie->name }}</option>
                                            @endforeach
                                        </select>

                                    </div>

                                    <div class="mb-3">
                                        <label for="defaultFormControlInput"
                                               class="form-label">{{ __('ticket.Department') }}:</label>
                                        <input type="text" class="form-control" id="searchDepartment"
                                               placeholder="CTTAP" aria-describedby="defaultFormControlHelp"/>
                                    </div>
                                @endif
                                <div class="mb-3">
                                    <label for="defaultFormControlInput" class="form-label">
                                        {{ __('ticket.Full name or username') }}</label>
                                    <input type="text" class="form-control" id="searchFullName"
                                           placeholder="John Doe" aria-describedby="defaultFormControlHelp"/>
                                </div>
                                <div class="mb-3">
                                    <label for="flatpickr-range"
                                           class="form-label">{{ __('ticket.Range Date Create') }}</label>
                                    <input type="text" class="form-control" placeholder="DD-MM-YYYY to DD-MM-YYYY"
                                           id="flatpickr-range"/>
                                </div>
                            </div>
                            <hr class="mx-n3 emails-list-header-hr"/>
                            <!-- Email List: Actions -->
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center">
                                </div>


                                <div
                                    class="email-pagination d-sm-flex d-none align-items-center flex-wrap justify-content-between justify-sm-content-end">
                                    <div class="pagination justify-content-center" id="pagination">
                                        <!-- Phân trang sẽ được chèn vào đây -->
                                    </div>
                                    {{--                                    <span class="d-sm-block d-none mx-3 text-muted text-page-info">1-10 of 653</span>--}}
                                    <i class="ti ti-rotate-clockwise ti-sm rotate-180 scaleX-n1-rtl cursor-pointer email-refresh me-2"></i>
                                    {{--                                    <i class="email-prev ti ti-chevron-left ti-sm scaleX-n1-rtl cursor-pointer"></i>--}}
                                    {{--                                    <i class="email-next ti ti-chevron-right ti-sm scaleX-n1-rtl cursor-pointer"></i>--}}
                                </div>
                                {{--                                                                {{ $tickets->links('pagination.simple-ticket') }} --}}
                            </div>
                        </div>
                        <hr class="container-m-nx m-0"/>
                        <!-- Email List: Items -->
                        <div class="email-list pt-0" id="TicketListsBox">
                            <ul class="list-unstyled m-0" id="ticketbox">
                            </ul>
                        </div>
                    </div>
                    <div class="app-overlay"></div>
                </div>
                <!-- /Emails List -->

                <!-- Email View -->
                <div class="col app-email-view flex-grow-0 bg-body" id="app-email-view">
                    <div class="card shadow-none border-0 rounded-0 app-email-view-header p-3 py-md-3 py-2 gap-1">
                        <!-- Email View : Title  bar-->
                        <div class="d-flex justify-content-between align-items-center py-2">
                            <div class="d-flex align-items-center overflow-hidden">
                                <i class="ti ti-chevron-left ti-sm cursor-pointer me-2" data-bs-toggle="sidebar"
                                   id="backtoListTicket" data-target="#app-email-view"></i>
                                <div id="ticketDetailStatus"></div>
                                <div class="row">
                                    <h6 class="text-truncate mb-0 me-2" id="ticketDetailTitle">Focused impactful open
                                        issues</h6>

                                </div>


                            </div>

                            <!-- Email View : Action  bar-->
                            <div class="d-flex align-items-center">
                                <i id="DetailReload"
                                   class="ti ti-reload ti-sm mt-1 cursor-pointer d-sm-block d-none"></i>
                            </div>
                            {{--                            Ticket info --}}
                            <div class="d-flex align-items-center" id="ButtonTopArea"></div>
                        </div>

                        <div class="d-flex justify-content-between align-items-center">


                            <div class="d-flex align-items-center flex-wrap justify-content-end">

                            </div>
                        </div>
                        <small id="ticketDetailFactory"></small>
                        <span class="input-group-text dropdown-toggle" id="list_staff_handle" data-bs-toggle="collapse"
                              data-bs-target="#staffHandleCollapse" aria-expanded="false"
                              aria-controls="staffHandleCollapse">
                        </span>

                    </div>
                    <hr class="m-0"/>
                    <!-- Email View : Content-->

                    <div class="app-email-view-content py-0">
                        {{--                        <p class="email-earlier-msgs text-center text-muted cursor-pointer mb-5">1 Earlier Message</p> --}}
                        <!-- Email View : Previous mails-->
                        <div id="TicketContent">
                            <div class="collapse border" id="staffHandleCollapse" style="min-height: 60vh">
                                <table id="staff_processing_info" class="table table-striped table-bordered"
                                       width="100%">
                                </table>
                                <div class="card email-card-prev mx-sm-4 mx-3 mt-4" style="display: block;"
                                     bis_skin_checked="1">

                                </div>
                            </div>
                        </div>

                        <!-- Email View : Last mail-->

                        <!-- Email View : Reply mail-->
                        <div class="email-reply card mt-4 mx-sm-4 mx-3" bis_skin_checked="1">


                        </div>

                        <form action="#" method="PUT" id="ticket-reply" enctype="multipart/form-data">
                            @csrf
                            <div class="email-reply card mt-4 mx-sm-4 mx-3">
                                <h6 class="card-header border-0 d-none"></h6>


                                <div class="card-body pt-0 px-3">
                                    <div class="modal-body flex-grow-1 pb-sm-0 p-4 py-2"></div>
                                    <textarea id="myTextarea"></textarea>


                                    <div class="d-flex justify-content-end align-items-center mt-3">
                                        <div class="me-3">
                                            <label class="cursor-pointer" for="attach-file-2">
                                                <i class="ti ti-paperclip me-2"></i>
                                                <span class="align-middle" id="attachment-2"></span>
                                            </label>
                                            <input type="file" multiple=true name="file-input[]" class="d-none"
                                                   id="attach-file-2" data-attachment-span="attachment-2"
                                                   onchange="updateAttachmentName(this)"/>
                                            <span id="ButtonBottomArea" class="px-2"></span>
                                             </div>

                                    </div>

                                </div>

                                <div class="ps__rail-x" style="left: 0px; bottom: 0px;">
                                    <div class="ps__thumb-x" tabindex="0" style="left: 0px; width: 0px;"></div>
                                </div>
                                <div class="ps__rail-y" style="top: 0px; height: 609px; right: 0px;">
                                    <div class="ps__thumb-y" tabindex="0" style="top: 0px; height: 485px;"></div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- Email View -->
            </div>

            <!-- Compose Email  emailComposeSidebar-->
            <div class="modal fade" id="emailComposeSidebar" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-lg modal-add-ticket">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                        </div>
                        <div class="modal-body">

                            <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="pills-home-tab" data-bs-toggle="pill"
                                            data-bs-target="#pills-home" type="button" role="tab"
                                            aria-controls="pills-home" aria-selected="true">Create Ticket
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill"
                                            data-bs-target="#pills-profile" type="button" role="tab"
                                            aria-controls="pills-profile" aria-selected="false">Ticket Done
                                    </button>
                                </li>

                            </ul>
                            <div class="tab-content" id="pills-tabContent">
                                <div class="tab-pane fade show active" id="pills-home" role="tabpanel"
                                     aria-labelledby="pills-home-tab">
                                    <div class="text-center mb-4">
                                        <h3 class="mb-2">{{ __('ticket.Create Ticket') }}</h3>
                                        <p class="text-muted">{{ __('ticket.Ticket Create Description') }}</p>
                                    </div>
                                    <form id="CreateTicketForm" class="row g-3" enctype="multipart/form-data">
                                        @csrf
                                        <div class="col-12 col-md-6">
                                            <label class="form-label"
                                                   for="problem">{{ __('ticket.Choose Type') }}</label>
                                            <select id="problem" name="problem" class="select2 form-select" required
                                                    aria-label="Default select example">
                                                @foreach ($datas['problemList'] as $problemList)
                                                    <option value="{{ $problemList->id }}">
                                                        {{ trans("ticket.{$problemList->name}") }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label"
                                                   for="problem">{{ __('ticket.Problem Type') }}</label>
                                            <select id="type" name="type" class="select2 form-select" required
                                                    aria-label="Default select example">
                                            </select>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label"
                                                   for="factories">{{ __('ticket.Factories') }}</label>
                                            <select id="factories" name="factories" class="select2 form-select" required
                                                    aria-label="Default select example">
                                                @foreach ($datas['factories'] as $factorie)
                                                    <option value="{{ $factorie->id }}"
                                                        {{ auth()->user()->id_factory == $factorie->id ? 'selected' : '' }}>
                                                        {{ $factorie->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label"
                                                   for="departments">{{ __('ticket.Department') }}</label>
                                            <select id="departments" name="departments" required class="form-select"
                                                    aria-label="Default select example">
                                                {{--                                        <option selected value="{{auth()->user()->Departments['id']}}">{{auth()->user()->Departments['name']}} : {{auth()->user()->Departments['nameEn']}} </option> --}}
                                            </select>

                                        </div>
                                        <div class="col-12">
                                            <label class="form-label"
                                                   for="modalEditUserName">{{ __('ticket.Problem Title') }}</label>
                                            <input class="form-control typeahead tt-input" type="text" name="title"
                                                   required>
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label"
                                                   for="modalEditUserName">{{ __('ticket.Problem Description') }}</label>
                                            <textarea id="myTextarea_create" name="content"></textarea>
                                        </div>

                                        <div class="d-flex justify-content-end align-items-center mt-3"
                                             id="bottom_button_area">
                                            <div class="me-3">
                                                <label class="cursor-pointer" for="attach-file-1">
                                                    <i class="ti ti-paperclip me-2"></i>
                                                    <span class="align-middle"
                                                          id="attachment-1">{{ __('ticket.Attachments') }}</span>
                                                </label>
                                                <input type="file" multiple="true" name="file-input[]" class="d-none"
                                                       id="attach-file-1" data-attachment-span="attachment-1"
                                                       onchange="updateAttachmentName(this)"/>
                                            </div>
                                            <hr>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                                <i class="ti ti-send ti-xs me-1"></i>
                                                <span class="align-middle">{{ __('ticket.Send') }}</span>
                                            </button>
                                        </div>


                                    </form>
                                </div>
                                <div class="tab-pane fade" id="pills-profile" role="tabpanel"
                                     aria-labelledby="pills-profile-tab">
                                    <form id="CreateTicketOffLineForm" action="{{ route('ticket_offline') }}"
                                          method="POST" class="row g-3" enctype="multipart/form-data">
                                        @csrf
                                        <div class="col-12 col-md-6">
                                            <label class="form-label"
                                                   for="problem">{{ __('ticket.Choose Type') }}</label>
                                            <select id="problem" name="problem" class="select2 form-select" required
                                                    aria-label="Default select example">
                                                @foreach ($datas['problemList'] as $problemList)
                                                    <option value="{{ $problemList->id }}">
                                                        {{ trans("ticket.{$problemList->name}") }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label"
                                                   for="problem">{{ __('ticket.Problem Type') }}</label>
                                            <select id="type2" name="type" class="select2 form-select" required
                                                    aria-label="Default select example">
                                            </select>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label"
                                                   for="factories">{{ __('ticket.Factories') }}</label>
                                            <select id="factories" name="factories" class="select2 form-select" required
                                                    aria-label="Default select example">
                                                @foreach ($datas['factories'] as $factorie)
                                                    <option value="{{ $factorie->id }}"
                                                        {{ auth()->user()->id_factory == $factorie->id ? 'selected' : '' }}>
                                                        {{ $factorie->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label"
                                                   for="departments">{{ __('ticket.Department') }}</label>
                                            <select id="departments" name="departments" required class="form-select"
                                                    aria-label="Default select example">
                                            </select>

                                        </div>


                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="time_start">Time Start</label>
                                            <input type="datetime-local" name="time_start" class="form-control"
                                                   required>
                                        </div>

                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="time_end">Time End</label>
                                            <input type="datetime-local" name="time_end" class="form-control" required>
                                        </div>

                                        <div class="col-12 ">
                                            <label class="form-label" for="title">Issue Title</label>
                                            <input type="text" class="form-control" name="title" required>
                                        </div>


                                        <div class="col-12">
                                            <label class="form-label" for="departments">Task</label>
                                            <hr>
                                            <button class="btn btn-success" id="btn-add_new_holder">+</button>
                                            <div id="taskArea" class="mt-3">
                                                <!-- Các dòng mới sẽ được thêm ở đây -->
                                            </div>
                                        </div>


                                        <script>
                                            document.getElementById('btn-add_new_holder').addEventListener('click', function (e) {
                                                e.preventDefault();

                                                // Tạo container cho dòng mới
                                                const taskContainer = document.createElement('div');
                                                taskContainer.className = 'input-group mb-3';

                                                // Tạo input cho "Holder Name"
                                                const holderName = document.createElement('select');
                                                holderName.type = 'select';
                                                holderName.id = 'subtask_staff'
                                                holderName.name = 'holder_name[]'; // Đặt name dạng mảng
                                                holderName.className = 'form-control';
                                                holderName.placeholder = 'Enter holder name';
                                                holderName.required = true;

                                                // Tạo textarea cho "Reason"
                                                const inputReason = document.createElement('textarea');
                                                inputReason.name = 'inputReason[]'; // Đặt name dạng mảng
                                                inputReason.className = 'form-control';
                                                inputReason.placeholder = 'Enter reason';
                                                inputReason.required = true;

                                                // Tạo textarea cho "Solution"
                                                const inputSolution = document.createElement('textarea');
                                                inputSolution.name = 'inputSolution[]'; // Đặt name dạng mảng
                                                inputSolution.className = 'form-control';
                                                inputSolution.placeholder = 'Enter solution';
                                                inputSolution.required = true;

                                                // Tạo nút xóa
                                                const removeButton = document.createElement('button');
                                                removeButton.type = 'button';
                                                removeButton.className = 'btn btn-danger';
                                                removeButton.innerHTML = 'Delete'; // Icon Bootstrap
                                                removeButton.addEventListener('click', function () {
                                                    taskContainer.remove(); // Xóa dòng hiện tại
                                                });

                                                // Thêm các phần tử vào container
                                                const inputGroup = document.createElement('div');
                                                inputGroup.className = 'd-flex flex-column gap-2 w-100'; // Tăng khoảng cách giữa các trường


                                                //call ajax
                                                $.ajax({
                                                    url: './select_staff_handle_ticket', // Adjust the URL if necessary
                                                    type: 'GET', // Method (GET, POST, etc.)
                                                    success: function (data) {
                                                        // Assuming data is an array of objects with id and name properties
                                                        data.forEach(item => {
                                                            const option = document.createElement('option');
                                                            option.value = item.id;
                                                            option.textContent = item.text;
                                                            holderName.appendChild(option);
                                                        });

                                                        // Apply select2 to the select element
                                                        $(holderName).select2({
                                                            placeholder: 'Select a staff member', // Optional placeholder
                                                            allowClear: true // Optional: Allows clearing selection
                                                            //dropdownParent: $("#emailComposeSidebar")
                                                        });
                                                    },
                                                    error: function (err) {
                                                        console.error('Error fetching staff options:', err);
                                                    }
                                                });

                                                inputGroup.appendChild(holderName);
                                                inputGroup.appendChild(inputReason);
                                                inputGroup.appendChild(inputSolution);

                                                taskContainer.appendChild(inputGroup);
                                                taskContainer.appendChild(removeButton);

                                                // Thêm container vào taskArea
                                                document.getElementById('taskArea').appendChild(taskContainer);


                                            });
                                        </script>

                                        <div class="col-12">
                                            <label class="form-label"
                                                   for="modalEditUserName">{{ __('ticket.Problem Description') }}</label>
                                            <textarea id="myTextarea_create" name="content"></textarea>
                                        </div>

                                        <div class="d-flex justify-content-end align-items-center mt-3"
                                             id="bottom_button_area">
                                            <div class="me-3">
                                                <label class="cursor-pointer" for="attach-file-1">
                                                    <i class="ti ti-paperclip me-2"></i>
                                                    <span class="align-middle"
                                                          id="attachment-1">{{ __('ticket.Attachments') }}</span>
                                                </label>
                                                <input type="file" multiple="true" name="file-input[]" class="d-none"
                                                       id="attach-file-1" data-attachment-span="attachment-1"
                                                       onchange="updateAttachmentName(this)"/>
                                            </div>
                                            <hr>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                                <i class="ti ti-send ti-xs me-1"></i>
                                                <span class="align-middle">Create ticket Downtime</span>
                                            </button>
                                        </div>


                                    </form>
                                </div>

                            </div>


                        </div>
                    </div>
                </div>
            </div>
            <!-- /Compose Email -->


        </div>
    </div>



    <script>
        const baseUrl = "{{ url('/') }}";
        $("#search_factories").select2();
        const lang = '{{ app()->getLocale() }}'
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $.ajax({
            type: "GET",
            url: './select_staff_handle_ticket',
            success: function (response) {
                $(".js-example-basic-single").select2({
                    dropdownParent: $("#modal_subtaksInfor"),
                    minimumInputLength: 0,
                    data: response
                });
            }
        })


        $(function () {
            @if (request()->has('s'))
            TicketShow({{ request()->input('s') }});
            @elseif (request()->has('page'))
            LoadAllTicket({{ request()->input('page') }});
            @else
            LoadAllTicket();
            @endif
            LoadDataFirst();
        });
    </script>

@endsection
@section('Page-script')
    <script src="{{ asset('assets/js/app-email.js') }}?v={{ filemtime(public_path('assets/js/app-email.js')) }}" defer></script>
    <script src="{{ asset('js/pages/mail.js') }}?v={{ filemtime(public_path('js/pages/mail.js')) }}" defer></script>


@endsection
