@extends('layouts.master')
@section('Page-title', 'Notifications Dashboard')

@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Notifications Dashboard</h5>
                <div class="table-responsive">
                    {{ $notifications->links() }}
                    <table class="table">
                        <thead>
                        <tr>
                            <th>Content</th>
                            <th>ID Ticket</th>
                            <th>Title</th>
                            <th>Type</th>
                            <th>User Created</th>
                            <th>Created at</th>
                            <th>Read at</th>
                        </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">

                        @foreach($notifications as $notification)
                            <tr>
                                <td>{!! $notification->data['text'] !!}</td>
                                <td><a href="./?page=1&s={{$notification->data['id']}}" class="btn btn-primary">View ticket #{{$notification->data['id']}}</a></td>
                                <td>{{$notification->data['title']}}</td>
                                <td>{{$notification->data['type']}}</td>
                                <td>{{$notification->fullname}}</td>
                                <td>{{$notification->created_at}}</td>
                                <td>{{$notification->read_at}}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                    {{ $notifications->links() }}
                </div>
            </div>
        </div>
    </div>
@endsection
